/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.webconsole.internal.i18n;

import java.util.Enumeration;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.felix.webconsole.internal.i18n.CombinedEnumeration;

class CombinedResourceBundle
extends ResourceBundle {
    private final ResourceBundle resourceBundle;
    private final ResourceBundle defaultResourceBundle;
    private final Locale locale;

    CombinedResourceBundle(ResourceBundle resourceBundle, ResourceBundle defaultResourceBundle, Locale locale) {
        this.resourceBundle = resourceBundle;
        this.defaultResourceBundle = defaultResourceBundle;
        this.locale = locale;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public Enumeration getKeys() {
        return new CombinedEnumeration(this.resourceBundle.getKeys(), this.defaultResourceBundle.getKeys());
    }

    protected Object handleGetObject(String key) {
        try {
            return this.resourceBundle.getObject(key);
        }
        catch (MissingResourceException mre) {
            try {
                return this.defaultResourceBundle.getObject(key);
            }
            catch (MissingResourceException missingResourceException) {
                return key;
            }
        }
    }
}

