/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.webconsole.internal.core;

import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.util.Enumeration;
import org.apache.felix.webconsole.internal.AbstractConfigurationPrinter;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.condpermadmin.ConditionInfo;
import org.osgi.service.condpermadmin.ConditionalPermissionAdmin;
import org.osgi.service.condpermadmin.ConditionalPermissionInfo;
import org.osgi.service.permissionadmin.PermissionAdmin;
import org.osgi.service.permissionadmin.PermissionInfo;

public final class PermissionsConfigurationPrinter
extends AbstractConfigurationPrinter {
    private static final String TITLE = "Permissions";
    static /* synthetic */ Class class$org$osgi$service$permissionadmin$PermissionAdmin;
    static /* synthetic */ Class class$org$osgi$service$condpermadmin$ConditionalPermissionAdmin;
    static /* synthetic */ Class class$org$osgi$service$condpermadmin$ConditionalPermissionInfo;

    public final String getTitle() {
        return TITLE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void printConfiguration(PrintWriter pw) {
        block16: {
            BundleContext bc = this.getBundleContext();
            ServiceReference paRef = bc.getServiceReference((class$org$osgi$service$permissionadmin$PermissionAdmin == null ? (class$org$osgi$service$permissionadmin$PermissionAdmin = PermissionsConfigurationPrinter.class$("org.osgi.service.permissionadmin.PermissionAdmin")) : class$org$osgi$service$permissionadmin$PermissionAdmin).getName());
            ServiceReference cpaRef = bc.getServiceReference((class$org$osgi$service$condpermadmin$ConditionalPermissionAdmin == null ? (class$org$osgi$service$condpermadmin$ConditionalPermissionAdmin = PermissionsConfigurationPrinter.class$("org.osgi.service.condpermadmin.ConditionalPermissionAdmin")) : class$org$osgi$service$condpermadmin$ConditionalPermissionAdmin).getName());
            PermissionAdmin pa = paRef != null ? (PermissionAdmin)bc.getService(paRef) : null;
            ConditionalPermissionAdmin cpa = cpaRef != null ? (ConditionalPermissionAdmin)bc.getService(cpaRef) : null;
            try {
                pw.print("Status: Permission Admin ");
                if (null == pa) {
                    pw.print("not ");
                }
                pw.print("available, Conditional Permission Admin ");
                if (null == cpa) {
                    pw.print("not ");
                }
                pw.println("available.");
                if (pa != null) {
                    pw.println();
                    pw.println("Permission Admin");
                    pw.println("  Default Permissions:");
                    PermissionsConfigurationPrinter.print(pa.getDefaultPermissions(), pw);
                    String[] locations = pa.getLocations();
                    for (int i = 0; locations != null && i < locations.length; ++i) {
                        pw.print("  Location: ");
                        pw.println(locations[i]);
                        PermissionsConfigurationPrinter.print(pa.getPermissions(locations[i]), pw);
                    }
                }
                if (cpa == null) break block16;
                pw.println();
                pw.println("Conditional Permission Admin");
                Method getAccessDecision = null;
                try {
                    getAccessDecision = (class$org$osgi$service$condpermadmin$ConditionalPermissionInfo == null ? (class$org$osgi$service$condpermadmin$ConditionalPermissionInfo = PermissionsConfigurationPrinter.class$("org.osgi.service.condpermadmin.ConditionalPermissionInfo")) : class$org$osgi$service$condpermadmin$ConditionalPermissionInfo).getMethod("getAccessDecision", null);
                }
                catch (Throwable t) {
                    // empty catch block
                }
                boolean hasPermissions = false;
                Enumeration e = cpa.getConditionalPermissionInfos();
                while (e.hasMoreElements()) {
                    hasPermissions = true;
                    ConditionalPermissionInfo info = (ConditionalPermissionInfo)e.nextElement();
                    pw.print("  ");
                    pw.print(info.getName());
                    if (getAccessDecision != null) {
                        try {
                            Object ad = getAccessDecision.invoke((Object)info, null);
                            pw.print(" (");
                            pw.print(ad);
                            pw.print(")");
                        }
                        catch (Throwable t) {
                            // empty catch block
                        }
                    }
                    pw.println();
                    pw.println("  Conditions:");
                    PermissionsConfigurationPrinter.print(info.getConditionInfos(), pw);
                    pw.println("  Permissions:");
                    PermissionsConfigurationPrinter.print(info.getPermissionInfos(), pw);
                }
                if (!hasPermissions) {
                    pw.println("  n/a");
                }
            }
            finally {
                if (paRef != null) {
                    bc.ungetService(paRef);
                }
                if (cpaRef != null) {
                    bc.ungetService(cpaRef);
                }
            }
        }
    }

    private static final void print(PermissionInfo[] infos, PrintWriter pw) {
        if (infos == null || infos.length == 0) {
            pw.println("    n/a");
        } else {
            int len = infos.length;
            for (int i = 0; i < len; ++i) {
                pw.print("    ");
                pw.println(infos[i].getEncoded());
            }
        }
        pw.println();
    }

    private static final void print(ConditionInfo[] infos, PrintWriter pw) {
        if (infos == null || infos.length == 0) {
            pw.println("    empty conditions set");
        } else {
            int len = infos.length;
            for (int i = 0; i < len; ++i) {
                pw.print("    ");
                pw.println(infos[i].getEncoded());
            }
        }
        pw.println();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

