/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.webconsole.internal.compendium;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.felix.webconsole.internal.BaseWebConsolePlugin;
import org.osgi.framework.Bundle;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.metatype.AttributeDefinition;
import org.osgi.service.metatype.MetaTypeInformation;
import org.osgi.service.metatype.MetaTypeService;
import org.osgi.service.metatype.ObjectClassDefinition;

abstract class ConfigManagerBase
extends BaseWebConsolePlugin {
    private static final long serialVersionUID = -6691093960031418130L;
    private static final String CONFIGURATION_ADMIN_NAME = (class$org$osgi$service$cm$ConfigurationAdmin == null ? (class$org$osgi$service$cm$ConfigurationAdmin = ConfigManagerBase.class$("org.osgi.service.cm.ConfigurationAdmin")) : class$org$osgi$service$cm$ConfigurationAdmin).getName();
    private static final String META_TYPE_NAME = (class$org$osgi$service$metatype$MetaTypeService == null ? (class$org$osgi$service$metatype$MetaTypeService = ConfigManagerBase.class$("org.osgi.service.metatype.MetaTypeService")) : class$org$osgi$service$metatype$MetaTypeService).getName();
    private static final IdGetter PID_GETTER = new IdGetter(){

        public String[] getIds(MetaTypeInformation metaTypeInformation) {
            return metaTypeInformation.getPids();
        }
    };
    private static final IdGetter FACTORY_PID_GETTER = new IdGetter(){

        public String[] getIds(MetaTypeInformation metaTypeInformation) {
            return metaTypeInformation.getFactoryPids();
        }
    };
    static /* synthetic */ Class class$org$osgi$service$cm$ConfigurationAdmin;
    static /* synthetic */ Class class$org$osgi$service$metatype$MetaTypeService;

    ConfigManagerBase() {
    }

    protected ConfigurationAdmin getConfigurationAdmin() {
        return (ConfigurationAdmin)this.getService(CONFIGURATION_ADMIN_NAME);
    }

    protected MetaTypeService getMetaTypeService() {
        return (MetaTypeService)this.getService(META_TYPE_NAME);
    }

    protected Collection getPidObjectClasses(String locale) {
        return this.getObjectClasses(PID_GETTER, locale);
    }

    protected Collection getFactoryPidObjectClasses(String locale) {
        return this.getObjectClasses(FACTORY_PID_GETTER, locale);
    }

    private Collection getObjectClasses(IdGetter idGetter, String locale) {
        ArrayList<ObjectClassDefinition> objectClasses = new ArrayList<ObjectClassDefinition>();
        MetaTypeService mts = this.getMetaTypeService();
        if (mts != null) {
            Bundle[] bundles = this.getBundleContext().getBundles();
            for (int i = 0; i < bundles.length; ++i) {
                MetaTypeInformation mti = mts.getMetaTypeInformation(bundles[i]);
                if (mti == null) continue;
                String[] idList = idGetter.getIds(mti);
                for (int j = 0; idList != null && j < idList.length; ++j) {
                    ObjectClassDefinition ocd = mti.getObjectClassDefinition(idList[j], locale);
                    if (ocd == null) continue;
                    objectClasses.add(ocd);
                }
            }
        }
        return objectClasses;
    }

    protected ObjectClassDefinition getObjectClassDefinition(Configuration config, String locale) {
        MetaTypeInformation mti;
        MetaTypeService mts;
        Bundle bundle;
        if (config.getBundleLocation() != null && (bundle = this.getBundle(config.getBundleLocation())) != null && (mts = this.getMetaTypeService()) != null && (mti = mts.getMetaTypeInformation(bundle)) != null) {
            if (config.getFactoryPid() != null) {
                return mti.getObjectClassDefinition(config.getFactoryPid(), locale);
            }
            return mti.getObjectClassDefinition(config.getPid(), locale);
        }
        if (config.getFactoryPid() != null) {
            return this.getObjectClassDefinition(config.getFactoryPid(), locale);
        }
        return this.getObjectClassDefinition(config.getPid(), locale);
    }

    protected ObjectClassDefinition getObjectClassDefinition(Bundle bundle, String pid, String locale) {
        MetaTypeInformation mti;
        MetaTypeService mts;
        if (bundle != null && (mts = this.getMetaTypeService()) != null && (mti = mts.getMetaTypeInformation(bundle)) != null) {
            return mti.getObjectClassDefinition(pid, locale);
        }
        return null;
    }

    protected ObjectClassDefinition getObjectClassDefinition(String pid, String locale) {
        Bundle[] bundles = this.getBundleContext().getBundles();
        for (int i = 0; i < bundles.length; ++i) {
            try {
                ObjectClassDefinition ocd = this.getObjectClassDefinition(bundles[i], pid, locale);
                if (ocd == null) continue;
                return ocd;
            }
            catch (IllegalArgumentException iae) {
                // empty catch block
            }
        }
        return null;
    }

    protected Map getAttributeDefinitionMap(Configuration config, String locale) {
        AttributeDefinition[] ad;
        ObjectClassDefinition ocd = this.getObjectClassDefinition(config, locale);
        if (ocd != null && (ad = ocd.getAttributeDefinitions(-1)) != null) {
            HashMap<String, AttributeDefinition> adMap = new HashMap<String, AttributeDefinition>();
            for (int i = 0; i < ad.length; ++i) {
                adMap.put(ad[i].getID(), ad[i]);
            }
            return adMap;
        }
        return null;
    }

    protected Bundle getBundle(String bundleLocation) {
        if (bundleLocation == null) {
            return null;
        }
        Bundle[] bundles = this.getBundleContext().getBundles();
        for (int i = 0; i < bundles.length; ++i) {
            if (!bundleLocation.equals(bundles[i].getLocation())) continue;
            return bundles[i];
        }
        return null;
    }

    protected Locale getLocale(HttpServletRequest request) {
        try {
            return request.getLocale();
        }
        catch (Throwable t) {
            return Locale.getDefault();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static interface IdGetter {
        public String[] getIds(MetaTypeInformation var1);
    }
}

