/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.webconsole.internal.compendium;

import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.felix.scr.Component;
import org.apache.felix.scr.Reference;
import org.apache.felix.scr.ScrService;
import org.apache.felix.webconsole.internal.AbstractConfigurationPrinter;
import org.apache.felix.webconsole.internal.compendium.ComponentsServlet;
import org.osgi.framework.ServiceReference;

public class ComponentConfigurationPrinter
extends AbstractConfigurationPrinter {
    public String getTitle() {
        return "Declarative Services Components";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printConfiguration(PrintWriter pw) {
        ServiceReference sr = this.getBundleContext().getServiceReference("org.apache.felix.scr.ScrService");
        if (sr == null) {
            pw.println("  Apache Felix Declarative Service not installed");
        } else {
            ScrService scrService = (ScrService)this.getBundleContext().getService(sr);
            try {
                this.printComponents(pw, scrService.getComponents());
            }
            finally {
                this.getBundleContext().ungetService(sr);
            }
        }
    }

    public void printComponents(PrintWriter pw, Component[] components) {
        if (components == null || components.length == 0) {
            pw.println("  No Components Registered");
        } else {
            Component component;
            TreeMap<Long, Component> componentMap = new TreeMap<Long, Component>();
            for (int i = 0; i < components.length; ++i) {
                component = components[i];
                componentMap.put(new Long(component.getId()), component);
            }
            Iterator ci = componentMap.values().iterator();
            while (ci.hasNext()) {
                component = (Component)ci.next();
                this.component(pw, component);
            }
        }
    }

    private void component(PrintWriter pw, Component component) {
        pw.print(component.getId());
        pw.print("=[");
        pw.print(component.getName());
        pw.println("]");
        pw.println("  Bundle" + component.getBundle().getSymbolicName() + " (" + component.getBundle().getBundleId() + ")");
        pw.println("  State=" + ComponentsServlet.toStateString(component.getState()));
        pw.println("  DefaultState=" + (component.isDefaultEnabled() ? "enabled" : "disabled"));
        pw.println("  Activation=" + (component.isImmediate() ? "immediate" : "delayed"));
        this.listServices(pw, component);
        this.listReferences(pw, component);
        this.listProperties(pw, component);
        pw.println();
    }

    private void listServices(PrintWriter pw, Component component) {
        String[] services = component.getServices();
        if (services == null) {
            return;
        }
        pw.println("  ServiceType=" + (component.isServiceFactory() ? "service factory" : "service"));
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < services.length; ++i) {
            if (i > 0) {
                buf.append(", ");
            }
            buf.append(services[i]);
        }
        pw.println("  Services=" + buf);
    }

    private void listReferences(PrintWriter pw, Component component) {
        Reference[] refs = component.getReferences();
        if (refs != null) {
            for (int i = 0; i < refs.length; ++i) {
                pw.println("  Reference=" + refs[i].getName() + ", " + (refs[i].isSatisfied() ? "Satisfied" : "Unsatisfied"));
                pw.println("    Service Name: " + refs[i].getServiceName());
                if (refs[i].getTarget() != null) {
                    pw.println("  Target Filter: " + refs[i].getTarget());
                }
                pw.println("    Multiple: " + (refs[i].isMultiple() ? "multiple" : "single"));
                pw.println("    Optional: " + (refs[i].isOptional() ? "optional" : "mandatory"));
                pw.println("    Policy: " + (refs[i].isStatic() ? "static" : "dynamic"));
                ServiceReference[] boundRefs = refs[i].getServiceReferences();
                if (boundRefs != null && boundRefs.length > 0) {
                    for (int j = 0; j < boundRefs.length; ++j) {
                        pw.print("    Bound Service: ID ");
                        pw.print(boundRefs[j].getProperty("service.id"));
                        String name = (String)boundRefs[j].getProperty("component.name");
                        if (name == null && (name = (String)boundRefs[j].getProperty("service.pid")) == null) {
                            name = (String)boundRefs[j].getProperty("service.description");
                        }
                        if (name != null) {
                            pw.print(" (");
                            pw.print(name);
                            pw.print(")");
                        }
                        pw.println();
                    }
                    continue;
                }
                pw.println("    No Services bound");
            }
        }
    }

    private void listProperties(PrintWriter pw, Component component) {
        Dictionary props = component.getProperties();
        if (props != null) {
            pw.println("  Properties=");
            TreeSet keys = new TreeSet(Collections.list(props.keys()));
            Iterator ki = keys.iterator();
            while (ki.hasNext()) {
                String key = (String)ki.next();
                Object value = props.get(key);
                if (value.getClass().isArray()) {
                    value = Arrays.asList((Object[])value);
                }
                pw.println("    " + key + "=" + value);
            }
        }
    }
}

