/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.webconsole.internal.servlet;

import java.io.IOException;
import java.util.Collection;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.servlet.GenericServlet;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.felix.webconsole.AbstractWebConsolePlugin;
import org.apache.felix.webconsole.Action;
import org.apache.felix.webconsole.BrandingPlugin;
import org.apache.felix.webconsole.internal.Logger;
import org.apache.felix.webconsole.internal.OsgiManagerPlugin;
import org.apache.felix.webconsole.internal.WebConsolePluginAdapter;
import org.apache.felix.webconsole.internal.servlet.ConfigurationListener;
import org.apache.felix.webconsole.internal.servlet.OsgiManagerHttpContext;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.http.HttpContext;
import org.osgi.service.http.HttpService;
import org.osgi.util.tracker.ServiceTracker;

public class OsgiManager
extends GenericServlet {
    private static final long serialVersionUID = 1L;
    private static final String ATTR_APP_ROOT_OLD = (class$org$apache$felix$webconsole$internal$servlet$OsgiManager == null ? (class$org$apache$felix$webconsole$internal$servlet$OsgiManager = OsgiManager.class$("org.apache.felix.webconsole.internal.servlet.OsgiManager")) : class$org$apache$felix$webconsole$internal$servlet$OsgiManager).getName() + ".appRoot";
    private static final String ATTR_LABEL_MAP_OLD = (class$org$apache$felix$webconsole$internal$servlet$OsgiManager == null ? (class$org$apache$felix$webconsole$internal$servlet$OsgiManager = OsgiManager.class$("org.apache.felix.webconsole.internal.servlet.OsgiManager")) : class$org$apache$felix$webconsole$internal$servlet$OsgiManager).getName() + ".labelMap";
    public static final String PARAM_NO_REDIRECT_AFTER_ACTION = "_noredir_";
    static final String PROP_MANAGER_ROOT = "manager.root";
    static final String PROP_DEFAULT_RENDER = "default.render";
    static final String PROP_REALM = "realm";
    static final String PROP_USER_NAME = "username";
    static final String PROP_PASSWORD = "password";
    static final String PROP_ENABLED_PLUGINS = "plugins";
    static final String DEFAULT_PAGE = "bundles";
    static final String DEFAULT_REALM = "OSGi Management Console";
    static final String DEFAULT_USER_NAME = "admin";
    static final String DEFAULT_PASSWORD = "admin";
    static final String DEFAULT_MANAGER_ROOT = "/system/console";
    static final String[] PLUGIN_CLASSES = new String[]{"org.apache.felix.webconsole.internal.compendium.ComponentConfigurationPrinter", "org.apache.felix.webconsole.internal.compendium.ComponentsServlet", "org.apache.felix.webconsole.internal.compendium.ConfigManager", "org.apache.felix.webconsole.internal.compendium.ConfigurationAdminConfigurationPrinter", "org.apache.felix.webconsole.internal.compendium.LogServlet", "org.apache.felix.webconsole.internal.compendium.PreferencesConfigurationPrinter", "org.apache.felix.webconsole.internal.core.BundlesServlet", "org.apache.felix.webconsole.internal.core.ServicesServlet", "org.apache.felix.webconsole.internal.core.InstallAction", "org.apache.felix.webconsole.internal.core.SetStartLevelAction", "org.apache.felix.webconsole.internal.deppack.DepPackServlet", "org.apache.felix.webconsole.internal.misc.LicenseServlet", "org.apache.felix.webconsole.internal.misc.ConfigurationRender", "org.apache.felix.webconsole.internal.misc.ShellServlet", "org.apache.felix.webconsole.internal.obr.BundleRepositoryRender", "org.apache.felix.webconsole.internal.obr.InstallFromRepoAction", "org.apache.felix.webconsole.internal.obr.RefreshRepoAction", "org.apache.felix.webconsole.internal.system.GCAction", "org.apache.felix.webconsole.internal.system.VMStatPlugin"};
    private BundleContext bundleContext;
    private Logger log;
    private ServiceTracker httpServiceTracker;
    private HttpService httpService;
    private ServiceTracker operationsTracker;
    private ServiceTracker pluginsTracker;
    private ServiceTracker brandingTracker;
    private ServiceRegistration configurationListener;
    private Map plugins = new HashMap();
    private Map labelMap = new HashMap();
    private Map operations = new HashMap();
    private Servlet defaultRender;
    private String defaultRenderName;
    private String webManagerRoot;
    private boolean httpServletRegistered;
    private boolean httpResourcesRegistered;
    private Dictionary configuration;
    private Set enabledPlugins;
    static /* synthetic */ Class class$org$apache$felix$webconsole$internal$servlet$OsgiManager;
    static /* synthetic */ Class class$org$osgi$service$http$HttpService;
    static /* synthetic */ Class class$org$apache$felix$webconsole$BrandingPlugin;

    public OsgiManager(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
        this.log = new Logger(bundleContext);
        this.updateConfiguration(null);
        try {
            this.configurationListener = ConfigurationListener.create(this);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.httpServiceTracker = new HttpServiceTracker(this);
        this.httpServiceTracker.open();
    }

    public void dispose() {
        if (this.httpServiceTracker != null) {
            this.httpServiceTracker.close();
            this.httpServiceTracker = null;
        }
        if (this.configurationListener != null) {
            this.configurationListener.unregister();
            this.configurationListener = null;
        }
        if (this.log != null) {
            this.log.dispose();
        }
        this.defaultRender = null;
        this.bundleContext = null;
    }

    public void init() {
        ClassLoader classLoader = ((Object)((Object)this)).getClass().getClassLoader();
        for (int i = 0; i < PLUGIN_CLASSES.length; ++i) {
            String pluginClassName = PLUGIN_CLASSES[i];
            try {
                Class<?> pluginClass = classLoader.loadClass(pluginClassName);
                Object plugin = pluginClass.newInstance();
                if (this.isPluginDisabled(pluginClassName, plugin)) {
                    this.log.log(3, "Ignoring plugin " + pluginClassName + ": Disabled by configuration");
                    continue;
                }
                if (plugin instanceof OsgiManagerPlugin) {
                    ((OsgiManagerPlugin)plugin).activate(this.bundleContext);
                }
                if (plugin instanceof AbstractWebConsolePlugin) {
                    AbstractWebConsolePlugin amp = (AbstractWebConsolePlugin)((Object)plugin);
                    this.bindServlet(amp.getLabel(), (Servlet)amp);
                    continue;
                }
                if (plugin instanceof Action) {
                    this.bindOperation((Action)plugin);
                }
                if (!(plugin instanceof BrandingPlugin)) continue;
                AbstractWebConsolePlugin.setBrandingPlugin((BrandingPlugin)plugin);
                continue;
            }
            catch (Throwable t) {
                this.log.log(3, "Failed to instantiate plugin " + pluginClassName + ". Reason: " + t);
            }
        }
        this.operationsTracker = new OperationServiceTracker(this);
        this.operationsTracker.open();
        this.pluginsTracker = new PluginServiceTracker(this);
        this.pluginsTracker.open();
        this.brandingTracker = new BrandingServiceTracker(this);
        this.brandingTracker.open();
    }

    public void service(ServletRequest req, ServletResponse res) throws ServletException, IOException {
        Servlet plugin;
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)res;
        if (this.handleAction(request, response)) {
            return;
        }
        if (request.getPathInfo() == null || request.getPathInfo().equals("/")) {
            String path = request.getRequestURI();
            if (!path.endsWith("/")) {
                path = path.concat("/");
            }
            path = path.concat(this.defaultRenderName);
            response.sendRedirect(path);
            return;
        }
        String label = request.getPathInfo();
        int slash = label.indexOf("/", 1);
        if (slash < 2) {
            slash = label.length();
        }
        if ((plugin = (Servlet)this.plugins.get(label = label.substring(1, slash))) == null) {
            response.sendError(404);
            return;
        }
        req.setAttribute("felix.webconsole.labelMap", (Object)this.labelMap);
        req.setAttribute("felix.webconsole.appRoot", (Object)(request.getContextPath() + request.getServletPath()));
        req.setAttribute("felix.webconsole.pluginRoot", (Object)(request.getContextPath() + request.getServletPath() + '/' + label));
        req.setAttribute(ATTR_LABEL_MAP_OLD, (Object)this.labelMap);
        req.setAttribute(ATTR_APP_ROOT_OLD, (Object)(request.getContextPath() + request.getServletPath()));
        plugin.service(req, res);
    }

    public void destroy() {
        if (this.operationsTracker != null) {
            this.operationsTracker.close();
            this.operationsTracker = null;
        }
        if (this.pluginsTracker != null) {
            this.pluginsTracker.close();
            this.pluginsTracker = null;
        }
        if (this.brandingTracker != null) {
            this.brandingTracker.close();
            this.brandingTracker = null;
        }
        Iterator pi = this.plugins.values().iterator();
        while (pi.hasNext()) {
            Object plugin = pi.next();
            if (!(plugin instanceof OsgiManagerPlugin)) continue;
            ((OsgiManagerPlugin)plugin).deactivate();
        }
        this.plugins.clear();
        this.labelMap.clear();
        this.operations.clear();
    }

    protected boolean handleAction(HttpServletRequest req, HttpServletResponse resp) throws IOException, ServletException {
        Action action;
        String actionName = AbstractWebConsolePlugin.getParameter(req, "action");
        if (actionName != null && (action = (Action)this.operations.get(actionName)) != null) {
            boolean redirect = true;
            try {
                redirect = action.performAction(req, resp);
            }
            catch (IOException ioe) {
                this.log.log(2, ioe.getMessage(), ioe);
            }
            catch (ServletException se) {
                this.log.log(2, se.getMessage(), se.getRootCause());
            }
            if (PARAM_NO_REDIRECT_AFTER_ACTION.equals(AbstractWebConsolePlugin.getParameter(req, PARAM_NO_REDIRECT_AFTER_ACTION))) {
                resp.setStatus(200);
                resp.setContentType("text/html");
                resp.getWriter().println("Ok");
                return true;
            }
            if (redirect) {
                String uri = req.getRequestURI();
                resp.sendRedirect(uri);
            }
            return true;
        }
        return false;
    }

    BundleContext getBundleContext() {
        return this.bundleContext;
    }

    protected synchronized void bindHttpService(HttpService httpService) {
        if (this.httpService != null) {
            this.log.log(4, "bindHttpService: Already bound to an HTTP Service, ignoring further services");
            return;
        }
        Dictionary config = this.getConfiguration();
        String realm = this.getProperty(config, PROP_REALM, DEFAULT_REALM);
        String userId = this.getProperty(config, PROP_USER_NAME, "admin");
        String password = this.getProperty(config, PROP_PASSWORD, "admin");
        try {
            OsgiManagerHttpContext httpContext = new OsgiManagerHttpContext(httpService, realm, userId, password);
            Dictionary servletConfig = this.toStringConfig(config);
            httpService.registerServlet(this.webManagerRoot, (Servlet)this, servletConfig, (HttpContext)httpContext);
            this.httpServletRegistered = true;
            httpService.registerResources(this.webManagerRoot + "/res", "/res", (HttpContext)httpContext);
            this.httpResourcesRegistered = true;
        }
        catch (Exception e) {
            this.log.log(1, "bindHttpService: Problem setting up", e);
        }
        this.httpService = httpService;
    }

    protected synchronized void unbindHttpService(HttpService httpService) {
        if (this.httpService != httpService) {
            this.log.log(4, "unbindHttpService: Ignoring unbind of an HttpService to which we are not registered");
            return;
        }
        this.httpService = null;
        if (this.httpResourcesRegistered) {
            try {
                httpService.unregister(this.webManagerRoot + "/res");
            }
            catch (Throwable t) {
                this.log.log(2, "unbindHttpService: Failed unregistering Resources", t);
            }
            this.httpResourcesRegistered = false;
        }
        if (this.httpServletRegistered) {
            try {
                httpService.unregister(this.webManagerRoot);
            }
            catch (Throwable t) {
                this.log.log(2, "unbindHttpService: Failed unregistering Servlet", t);
            }
            this.httpServletRegistered = false;
        }
    }

    protected void bindServlet(String label, Servlet servlet) {
        try {
            String title;
            servlet.init(this.getServletConfig());
            this.plugins.put(label, servlet);
            if (servlet instanceof GenericServlet && (title = ((GenericServlet)servlet).getServletName()) != null) {
                this.labelMap.put(label, title);
            }
            if (this.defaultRender == null) {
                this.defaultRender = servlet;
            } else if (label.equals(this.defaultRenderName)) {
                this.defaultRender = servlet;
            }
        }
        catch (ServletException servletException) {
            // empty catch block
        }
    }

    protected void unbindServlet(String label) {
        Servlet servlet = (Servlet)this.plugins.remove(label);
        if (servlet != null) {
            this.labelMap.remove(label);
            if (this.defaultRender == servlet) {
                this.defaultRender = this.plugins.isEmpty() ? null : (Servlet)this.plugins.values().iterator().next();
            }
            servlet.destroy();
        }
    }

    protected void bindOperation(Action operation) {
        this.operations.put(operation.getName(), operation);
    }

    protected void unbindOperation(Action operation) {
        this.operations.remove(operation.getName());
    }

    private Dictionary getConfiguration() {
        return this.configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void updateConfiguration(Dictionary config) {
        Object pluginValue;
        if (config == null) {
            config = new Hashtable();
        }
        this.configuration = config;
        this.defaultRenderName = this.getProperty(config, PROP_DEFAULT_RENDER, DEFAULT_PAGE);
        if (this.defaultRenderName != null && this.plugins.get(this.defaultRenderName) != null) {
            this.defaultRender = (Servlet)this.plugins.get(this.defaultRenderName);
        }
        this.webManagerRoot = this.getProperty(config, PROP_MANAGER_ROOT, DEFAULT_MANAGER_ROOT);
        if (!this.webManagerRoot.startsWith("/")) {
            this.webManagerRoot = "/" + this.webManagerRoot;
        }
        if ((pluginValue = ((Dictionary)config).get(PROP_ENABLED_PLUGINS)) == null) {
            this.enabledPlugins = null;
        } else if (pluginValue.getClass().isArray()) {
            Object[] names = (Object[])pluginValue;
            this.enabledPlugins = new HashSet();
            for (int i = 0; i < names.length; ++i) {
                this.enabledPlugins.add(String.valueOf(names[i]));
            }
        } else if (pluginValue instanceof Collection) {
            this.enabledPlugins = new HashSet();
            this.enabledPlugins.addAll((Collection)pluginValue);
        }
        HttpService httpService = this.httpService;
        if (httpService != null) {
            OsgiManager osgiManager = this;
            synchronized (osgiManager) {
                this.unbindHttpService(httpService);
                this.bindHttpService(httpService);
            }
        }
    }

    private String getProperty(Dictionary config, String name, String def) {
        Object value = config.get(name);
        if (value instanceof String) {
            return (String)value;
        }
        if (value == null) {
            return def;
        }
        return String.valueOf(value);
    }

    private boolean isPluginDisabled(String pluginClass, Object plugin) {
        return this.enabledPlugins != null && !this.enabledPlugins.contains(pluginClass) && plugin instanceof AbstractWebConsolePlugin;
    }

    private Dictionary toStringConfig(Dictionary config) {
        Hashtable<String, String> stringConfig = new Hashtable<String, String>();
        Enumeration ke = config.keys();
        while (ke.hasMoreElements()) {
            Object key = ke.nextElement();
            ((Dictionary)stringConfig).put(key.toString(), String.valueOf(config.get(key)));
        }
        return stringConfig;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class BrandingServiceTracker
    extends ServiceTracker {
        private final OsgiManager osgiManager;

        BrandingServiceTracker(OsgiManager osgiManager) {
            super(osgiManager.getBundleContext(), (class$org$apache$felix$webconsole$BrandingPlugin == null ? (class$org$apache$felix$webconsole$BrandingPlugin = OsgiManager.class$("org.apache.felix.webconsole.BrandingPlugin")) : class$org$apache$felix$webconsole$BrandingPlugin).getName(), null);
            this.osgiManager = osgiManager;
        }

        public Object addingService(ServiceReference reference) {
            Object plugin = super.addingService(reference);
            if (plugin instanceof BrandingPlugin) {
                AbstractWebConsolePlugin.setBrandingPlugin((BrandingPlugin)plugin);
            }
            return plugin;
        }

        public void removedService(ServiceReference reference, Object service) {
            if (service instanceof BrandingPlugin) {
                AbstractWebConsolePlugin.setBrandingPlugin(null);
            }
            super.removedService(reference, service);
        }
    }

    private static class PluginServiceTracker
    extends ServiceTracker {
        private final OsgiManager osgiManager;

        PluginServiceTracker(OsgiManager osgiManager) {
            super(osgiManager.getBundleContext(), "javax.servlet.Servlet", null);
            this.osgiManager = osgiManager;
        }

        public Object addingService(ServiceReference reference) {
            Object label = reference.getProperty("felix.webconsole.label");
            if (label instanceof String) {
                Object operation = super.addingService(reference);
                if (operation instanceof Servlet) {
                    Object title;
                    if (!(operation instanceof AbstractWebConsolePlugin) && (title = reference.getProperty("felix.webconsole.title")) instanceof String) {
                        WebConsolePluginAdapter pluginAdapter = new WebConsolePluginAdapter((String)label, (String)title, (Servlet)operation, reference);
                        Bundle pluginBundle = reference.getBundle();
                        pluginAdapter.activate(pluginBundle.getBundleContext());
                        operation = pluginAdapter;
                    }
                    this.osgiManager.bindServlet((String)label, (Servlet)operation);
                }
                return operation;
            }
            return null;
        }

        public void removedService(ServiceReference reference, Object service) {
            Object label = reference.getProperty("felix.webconsole.label");
            if (label instanceof String) {
                this.osgiManager.unbindServlet((String)label);
                if (service instanceof WebConsolePluginAdapter) {
                    ((WebConsolePluginAdapter)((Object)service)).deactivate();
                }
            }
            super.removedService(reference, service);
        }
    }

    private static class OperationServiceTracker
    extends ServiceTracker {
        private final OsgiManager osgiManager;

        OperationServiceTracker(OsgiManager osgiManager) {
            super(osgiManager.getBundleContext(), Action.SERVICE, null);
            this.osgiManager = osgiManager;
        }

        public Object addingService(ServiceReference reference) {
            Object operation = super.addingService(reference);
            if (operation instanceof Action) {
                this.osgiManager.bindOperation((Action)operation);
            }
            return operation;
        }

        public void removedService(ServiceReference reference, Object service) {
            if (service instanceof Action) {
                this.osgiManager.bindOperation((Action)service);
            }
            super.removedService(reference, service);
        }
    }

    private static class HttpServiceTracker
    extends ServiceTracker {
        private final OsgiManager osgiManager;

        HttpServiceTracker(OsgiManager osgiManager) {
            super(osgiManager.getBundleContext(), (class$org$osgi$service$http$HttpService == null ? (class$org$osgi$service$http$HttpService = OsgiManager.class$("org.osgi.service.http.HttpService")) : class$org$osgi$service$http$HttpService).getName(), null);
            this.osgiManager = osgiManager;
        }

        public Object addingService(ServiceReference reference) {
            Object service = super.addingService(reference);
            if (service instanceof HttpService) {
                this.osgiManager.bindHttpService((HttpService)service);
            }
            return service;
        }

        public void removedService(ServiceReference reference, Object service) {
            if (service instanceof HttpService) {
                this.osgiManager.unbindHttpService((HttpService)service);
            }
            super.removedService(reference, service);
        }
    }
}

