/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.webconsole.internal.compendium;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.felix.scr.Component;
import org.apache.felix.scr.Reference;
import org.apache.felix.scr.ScrService;
import org.apache.felix.webconsole.internal.BaseWebConsolePlugin;
import org.apache.felix.webconsole.internal.Util;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONWriter;
import org.osgi.framework.Bundle;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.metatype.MetaTypeInformation;
import org.osgi.service.metatype.MetaTypeService;

public class ComponentsServlet
extends BaseWebConsolePlugin {
    private static final long serialVersionUID = 1L;
    public static final String NAME = "components";
    public static final String LABEL = "Components";
    public static final String COMPONENT_ID = "componentId";
    public static final String OPERATION = "action";
    public static final String OPERATION_ENABLE = "enable";
    public static final String OPERATION_DISABLE = "disable";
    public static final String OPERATION_CONFIGURE = "configure";
    private static final String SCR_SERVICE = (class$org$apache$felix$scr$ScrService == null ? (class$org$apache$felix$scr$ScrService = ComponentsServlet.class$("org.apache.felix.scr.ScrService")) : class$org$apache$felix$scr$ScrService).getName();
    private static final String META_TYPE_NAME = (class$org$osgi$service$metatype$MetaTypeService == null ? (class$org$osgi$service$metatype$MetaTypeService = ComponentsServlet.class$("org.osgi.service.metatype.MetaTypeService")) : class$org$osgi$service$metatype$MetaTypeService).getName();
    private static final String CONFIGURATION_ADMIN_NAME = (class$org$osgi$service$cm$ConfigurationAdmin == null ? (class$org$osgi$service$cm$ConfigurationAdmin = ComponentsServlet.class$("org.osgi.service.cm.ConfigurationAdmin")) : class$org$osgi$service$cm$ConfigurationAdmin).getName();
    static /* synthetic */ Class class$org$apache$felix$scr$ScrService;
    static /* synthetic */ Class class$org$osgi$service$metatype$MetaTypeService;
    static /* synthetic */ Class class$org$osgi$service$cm$ConfigurationAdmin;
    static /* synthetic */ Class class$org$apache$felix$webconsole$internal$compendium$ComponentsServlet;

    public String getTitle() {
        return LABEL;
    }

    public String getLabel() {
        return NAME;
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
        RequestInfo reqInfo = new RequestInfo(request);
        if (reqInfo.component == null && reqInfo.componentRequested) {
            response.sendError(404);
            return;
        }
        if (!reqInfo.componentRequested) {
            response.sendError(500);
            return;
        }
        String op = request.getParameter(OPERATION);
        if (OPERATION_ENABLE.equals(op)) {
            reqInfo.component.enable();
        } else if (OPERATION_DISABLE.equals(op)) {
            reqInfo.component.disable();
        }
        PrintWriter pw = response.getWriter();
        response.setContentType("application/json");
        response.setCharacterEncoding("UTF-8");
        this.renderResult(pw, null);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        RequestInfo reqInfo = new RequestInfo(request);
        if (reqInfo.component == null && reqInfo.componentRequested) {
            response.sendError(404);
            return;
        }
        if (reqInfo.extension.equals("json")) {
            response.setContentType("application/json");
            response.setCharacterEncoding("UTF-8");
            this.renderResult(response.getWriter(), reqInfo.component);
            return;
        }
        super.doGet(request, response);
    }

    protected void renderContent(HttpServletRequest request, HttpServletResponse response) throws IOException {
        RequestInfo reqInfo = ComponentsServlet.getRequestInfo(request);
        PrintWriter pw = response.getWriter();
        String appRoot = (String)request.getAttribute("felix.webconsole.appRoot");
        Util.startScript(pw);
        pw.println("var imgRoot = '" + appRoot + "/res/imgs';");
        pw.println("var drawDetails = " + reqInfo.componentRequested + ";");
        Util.endScript(pw);
        Util.script(pw, appRoot, "components.js");
        pw.println("<div id='plugin_content'/>");
        Util.startScript(pw);
        pw.print("renderComponents(");
        this.renderResult(pw, reqInfo.component);
        pw.println(");");
        Util.endScript(pw);
    }

    private void renderResult(PrintWriter pw, Component component) throws IOException {
        JSONWriter jw = new JSONWriter((Writer)pw);
        try {
            jw.object();
            ScrService scrService = this.getScrService();
            if (scrService == null) {
                jw.key("status");
                jw.value((Object)"Apache Felix Declarative Service required for this function");
            } else {
                Component[] components = scrService.getComponents();
                if (components == null || components.length == 0) {
                    jw.key("status");
                    jw.value((Object)"No components installed currently");
                } else {
                    TreeMap<String, Component> componentMap = new TreeMap<String, Component>();
                    for (int i = 0; i < components.length; ++i) {
                        Component c = components[i];
                        componentMap.put(c.getName(), c);
                    }
                    StringBuffer buffer = new StringBuffer();
                    buffer.append(componentMap.size());
                    buffer.append(" component");
                    if (componentMap.size() != 1) {
                        buffer.append('s');
                    }
                    buffer.append(" installed.");
                    jw.key("status");
                    jw.value((Object)buffer.toString());
                    jw.key("data");
                    jw.array();
                    if (component != null) {
                        this.component(jw, component, true);
                    } else {
                        Iterator ci = componentMap.values().iterator();
                        while (ci.hasNext()) {
                            this.component(jw, (Component)ci.next(), false);
                        }
                    }
                    jw.endArray();
                }
            }
            jw.endObject();
        }
        catch (JSONException je) {
            throw new IOException(je.toString());
        }
    }

    private void component(JSONWriter jw, Component component, boolean details) throws JSONException {
        String id = String.valueOf(component.getId());
        String name = component.getName();
        int state = component.getState();
        jw.object();
        jw.key("id");
        jw.value((Object)id);
        jw.key("name");
        jw.value((Object)name);
        jw.key("state");
        jw.value((Object)ComponentsServlet.toStateString(state));
        String pid = (String)component.getProperties().get("service.pid");
        if (pid != null) {
            jw.key("pid");
            jw.value((Object)pid);
        }
        jw.key("actions");
        jw.array();
        if (state == 1) {
            this.action(jw, true, OPERATION_ENABLE, "Enable", OPERATION_ENABLE);
        }
        if (state != 1 && state != 256) {
            this.action(jw, true, OPERATION_DISABLE, "Disable", OPERATION_DISABLE);
        }
        if (pid != null && this.isConfigurable(component.getBundle(), pid)) {
            this.action(jw, true, OPERATION_CONFIGURE, "Configure", OPERATION_CONFIGURE);
        }
        jw.endArray();
        if (details) {
            this.gatherComponentDetails(jw, component);
        }
        jw.endObject();
    }

    private void action(JSONWriter jw, boolean enabled, String op, String opLabel, String image) throws JSONException {
        jw.object();
        jw.key("enabled").value(enabled);
        jw.key("name").value((Object)opLabel);
        jw.key("link").value((Object)op);
        jw.key("image").value((Object)image);
        jw.endObject();
    }

    private void gatherComponentDetails(JSONWriter jw, Component component) throws JSONException {
        jw.key("props");
        jw.array();
        this.keyVal(jw, "Bundle", component.getBundle().getSymbolicName() + " (" + component.getBundle().getBundleId() + ")");
        this.keyVal(jw, "Default State", component.isDefaultEnabled() ? "enabled" : "disabled");
        this.keyVal(jw, "Activation", component.isImmediate() ? "immediate" : "delayed");
        this.listServices(jw, component);
        this.listReferences(jw, component);
        this.listProperties(jw, component);
        jw.endArray();
    }

    private void listServices(JSONWriter jw, Component component) {
        String[] services = component.getServices();
        if (services == null) {
            return;
        }
        this.keyVal(jw, "Service Type", component.isServiceFactory() ? "service factory" : "service");
        JSONArray buf = new JSONArray();
        for (int i = 0; i < services.length; ++i) {
            buf.put((Object)services[i]);
        }
        this.keyVal(jw, "Services", buf);
    }

    private void listReferences(JSONWriter jw, Component component) {
        Reference[] refs = component.getReferences();
        if (refs != null) {
            for (int i = 0; i < refs.length; ++i) {
                JSONArray buf = new JSONArray();
                buf.put((Object)(refs[i].isSatisfied() ? "Satisfied" : "Unsatisfied"));
                buf.put((Object)("Service Name: " + refs[i].getServiceName()));
                if (refs[i].getTarget() != null) {
                    buf.put((Object)("Target Filter: " + refs[i].getTarget()));
                }
                buf.put((Object)("Multiple: " + (refs[i].isMultiple() ? "multiple" : "single")));
                buf.put((Object)("Optional: " + (refs[i].isOptional() ? "optional" : "mandatory")));
                buf.put((Object)("Policy: " + (refs[i].isStatic() ? "static" : "dynamic")));
                ServiceReference[] boundRefs = refs[i].getServiceReferences();
                if (boundRefs != null && boundRefs.length > 0) {
                    for (int j = 0; j < boundRefs.length; ++j) {
                        StringBuffer b = new StringBuffer();
                        b.append("Bound Service ID ");
                        b.append(boundRefs[j].getProperty("service.id"));
                        String name = (String)boundRefs[j].getProperty("component.name");
                        if (name == null && (name = (String)boundRefs[j].getProperty("service.pid")) == null) {
                            name = (String)boundRefs[j].getProperty("service.description");
                        }
                        if (name != null) {
                            b.append(" (");
                            b.append(name);
                            b.append(")");
                        }
                        buf.put((Object)b.toString());
                    }
                } else {
                    buf.put((Object)"No Services bound");
                }
                this.keyVal(jw, "Reference " + refs[i].getName(), buf.toString());
            }
        }
    }

    private void listProperties(JSONWriter jw, Component component) {
        Dictionary props = component.getProperties();
        if (props != null) {
            JSONArray buf = new JSONArray();
            TreeSet keys = new TreeSet(Collections.list(props.keys()));
            Iterator ki = keys.iterator();
            while (ki.hasNext()) {
                String key = (String)ki.next();
                StringBuffer b = new StringBuffer();
                b.append(key).append(" = ");
                Object prop = props.get(key);
                if (prop.getClass().isArray()) {
                    prop = Arrays.asList((Object[])prop);
                }
                b.append(prop);
                buf.put((Object)b.toString());
            }
            this.keyVal(jw, "Properties", buf);
        }
    }

    private void keyVal(JSONWriter jw, String key, Object value) {
        if (key != null && value != null) {
            try {
                jw.object();
                jw.key("key");
                jw.value((Object)key);
                jw.key("value");
                jw.value(value);
                jw.endObject();
            }
            catch (JSONException je) {
                // empty catch block
            }
        }
    }

    static String toStateString(int state) {
        switch (state) {
            case 1: {
                return "disabled";
            }
            case 2: {
                return "enabled";
            }
            case 4: {
                return "unsatisifed";
            }
            case 8: {
                return "activating";
            }
            case 16: {
                return "active";
            }
            case 32: {
                return "registered";
            }
            case 64: {
                return "factory";
            }
            case 128: {
                return "deactivating";
            }
            case 256: {
                return "destroyed";
            }
        }
        return String.valueOf(state);
    }

    private boolean isConfigurable(Bundle providingBundle, String pid) {
        MetaTypeInformation mti;
        MetaTypeService mts;
        ConfigurationAdmin ca = this.getConfigurationAdmin();
        if (ca != null) {
            try {
                String filter = "(service.pid=" + pid + ")";
                Configuration[] configs = ca.listConfigurations(filter);
                if (configs != null && configs.length > 0) {
                    return true;
                }
            }
            catch (InvalidSyntaxException ise) {
            }
            catch (IOException ioe) {
                // empty catch block
            }
        }
        if (providingBundle != null && (mts = this.getMetaTypeService()) != null && (mti = mts.getMetaTypeInformation(providingBundle)) != null) {
            return mti.getObjectClassDefinition(pid, null) != null;
        }
        return false;
    }

    protected ConfigurationAdmin getConfigurationAdmin() {
        return (ConfigurationAdmin)this.getService(CONFIGURATION_ADMIN_NAME);
    }

    private ScrService getScrService() {
        return (ScrService)this.getService(SCR_SERVICE);
    }

    protected MetaTypeService getMetaTypeService() {
        return (MetaTypeService)this.getService(META_TYPE_NAME);
    }

    public static RequestInfo getRequestInfo(HttpServletRequest request) {
        return (RequestInfo)request.getAttribute((class$org$apache$felix$webconsole$internal$compendium$ComponentsServlet == null ? (class$org$apache$felix$webconsole$internal$compendium$ComponentsServlet = ComponentsServlet.class$("org.apache.felix.webconsole.internal.compendium.ComponentsServlet")) : class$org$apache$felix$webconsole$internal$compendium$ComponentsServlet).getName());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private final class RequestInfo {
        public final String extension;
        public final Component component;
        public final boolean componentRequested;

        protected long getComponentId(String componentIdPar) {
            try {
                return Long.parseLong(componentIdPar);
            }
            catch (NumberFormatException numberFormatException) {
                return -1L;
            }
        }

        protected RequestInfo(HttpServletRequest request) {
            String info = request.getPathInfo();
            info = info.substring(ComponentsServlet.this.getLabel().length() + 1);
            if (info.endsWith(".json")) {
                this.extension = "json";
                info = info.substring(0, info.length() - 5);
            } else {
                this.extension = "html";
            }
            long componentId = this.getComponentId(info.substring(info.lastIndexOf(47) + 1));
            if (componentId == -1L) {
                this.componentRequested = false;
                this.component = null;
            } else {
                this.componentRequested = true;
                ScrService scrService = ComponentsServlet.this.getScrService();
                this.component = scrService != null ? scrService.getComponent(componentId) : null;
            }
            request.setAttribute((class$org$apache$felix$webconsole$internal$compendium$ComponentsServlet == null ? (class$org$apache$felix$webconsole$internal$compendium$ComponentsServlet = ComponentsServlet.class$("org.apache.felix.webconsole.internal.compendium.ComponentsServlet")) : class$org$apache$felix$webconsole$internal$compendium$ComponentsServlet).getName(), (Object)this);
        }
    }
}

