/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.webconsole.internal.core;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.TreeMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.felix.bundlerepository.R4Attribute;
import org.apache.felix.bundlerepository.R4Export;
import org.apache.felix.bundlerepository.R4Import;
import org.apache.felix.bundlerepository.R4Package;
import org.apache.felix.webconsole.internal.BaseWebConsolePlugin;
import org.apache.felix.webconsole.internal.Util;
import org.apache.felix.webconsole.internal.obr.DeployerThread;
import org.apache.felix.webconsole.internal.servlet.OsgiManager;
import org.json.JSONException;
import org.json.JSONWriter;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.Version;
import org.osgi.service.obr.Repository;
import org.osgi.service.obr.RepositoryAdmin;
import org.osgi.service.obr.Resolver;
import org.osgi.service.obr.Resource;
import org.osgi.service.packageadmin.ExportedPackage;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.service.startlevel.StartLevel;

public class BundlesServlet
extends BaseWebConsolePlugin {
    public static final String NAME = "bundles";
    public static final String LABEL = "Bundles";
    public static final String BUNDLE_ID = "bundleId";
    private static final String REPOSITORY_ADMIN_NAME = (class$org$osgi$service$obr$RepositoryAdmin == null ? (class$org$osgi$service$obr$RepositoryAdmin = BundlesServlet.class$("org.osgi.service.obr.RepositoryAdmin")) : class$org$osgi$service$obr$RepositoryAdmin).getName();
    private String[] bootPkgs;
    private boolean[] bootPkgWildcards;
    static /* synthetic */ Class class$org$osgi$service$obr$RepositoryAdmin;

    public void activate(BundleContext bundleContext) {
        super.activate(bundleContext);
        String bootDelegation = bundleContext.getProperty("org.osgi.framework.bootdelegation");
        bootDelegation = bootDelegation == null ? "java.*" : bootDelegation + ",java.*";
        StringTokenizer st = new StringTokenizer(bootDelegation, " ,");
        this.bootPkgs = new String[st.countTokens()];
        this.bootPkgWildcards = new boolean[this.bootPkgs.length];
        for (int i = 0; i < this.bootPkgs.length; ++i) {
            bootDelegation = st.nextToken();
            if (bootDelegation.endsWith("*")) {
                this.bootPkgWildcards[i] = true;
                bootDelegation = bootDelegation.substring(0, bootDelegation.length() - 1);
            }
            this.bootPkgs[i] = bootDelegation;
        }
    }

    public String getLabel() {
        return NAME;
    }

    public String getTitle() {
        return LABEL;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String info = request.getPathInfo();
        if (info.endsWith(".json")) {
            Bundle bundle;
            info = info.substring(0, info.length() - 5);
            if (!this.getLabel().equals(info.substring(1)) && (bundle = this.getBundle(info)) != null) {
                response.setContentType("text/javascript");
                response.setCharacterEncoding("UTF-8");
                PrintWriter pw = response.getWriter();
                JSONWriter jw = new JSONWriter((Writer)pw);
                try {
                    this.performAction(jw, bundle);
                }
                catch (JSONException je) {
                    throw new IOException(je.toString());
                }
            }
            return;
        }
        super.doGet(request, response);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String action = req.getParameter("action");
        if ("refreshPackages".equals(action)) {
            this.getPackageAdmin().refreshPackages(null);
        }
        boolean success = false;
        Bundle bundle = this.getBundle(req.getPathInfo());
        long bundleId = -1L;
        if (bundle != null) {
            bundleId = bundle.getBundleId();
            if (action == null) {
                success = true;
            } else if ("start".equals(action)) {
                success = true;
                try {
                    bundle.start();
                }
                catch (BundleException be) {
                    this.getLog().log(1, "Cannot start", be);
                }
            } else if ("stop".equals(action)) {
                success = true;
                try {
                    bundle.stop();
                }
                catch (BundleException be) {
                    this.getLog().log(1, "Cannot stop", be);
                }
            } else if ("update".equals(action)) {
                this.update(bundle);
                success = true;
            } else if ("uninstall".equals(action)) {
                success = true;
                try {
                    bundle.uninstall();
                    bundle = null;
                }
                catch (BundleException be) {
                    this.getLog().log(1, "Cannot uninstall", be);
                }
            }
        }
        if ("refreshPackages".equals(action)) {
            success = true;
            this.getPackageAdmin().refreshPackages(null);
            bundle = null;
            bundleId = -1L;
        }
        if (success) {
            resp.setStatus(200);
            JSONWriter jw = new JSONWriter((Writer)resp.getWriter());
            try {
                if (bundle != null) {
                    this.bundleInfo(jw, bundle, true);
                }
                if (bundleId >= 0L) {
                    jw.object();
                    jw.key(BUNDLE_ID);
                    jw.value(bundleId);
                    jw.endObject();
                }
                jw.object();
                jw.key("reload");
                jw.value(true);
                jw.endObject();
            }
            catch (JSONException je) {
                throw new IOException(je.toString());
            }
        } else {
            super.doPost(req, resp);
        }
    }

    private Bundle getBundle(String pathInfo) {
        long bundleId;
        pathInfo = pathInfo.substring(pathInfo.lastIndexOf(47) + 1);
        try {
            bundleId = Long.parseLong(pathInfo);
        }
        catch (NumberFormatException nfe) {
            bundleId = -1L;
        }
        if (bundleId >= 0L) {
            return this.getBundleContext().getBundle(bundleId);
        }
        return null;
    }

    protected void renderContent(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        PrintWriter pw = response.getWriter();
        String appRoot = (String)request.getAttribute(OsgiManager.ATTR_APP_ROOT);
        pw.println("<script src='" + appRoot + "/res/ui/datatable.js' language='JavaScript'></script>");
        pw.println("<script src='" + appRoot + "/res/ui/bundles.js' language='JavaScript'></script>");
        Util.startScript(pw);
        pw.println("var bundleListData = ");
        JSONWriter jw = new JSONWriter((Writer)pw);
        try {
            boolean details;
            Bundle[] bundleArray;
            jw.object();
            jw.key("startLevel");
            jw.value((long)this.getStartLevel().getInitialBundleStartLevel());
            jw.key("numActions");
            jw.value(4L);
            Bundle bundle = this.getBundle(request.getPathInfo());
            if (bundle != null) {
                Bundle[] bundleArray2 = new Bundle[1];
                bundleArray = bundleArray2;
                bundleArray2[0] = bundle;
            } else {
                bundleArray = this.getBundles();
            }
            Bundle[] bundles = bundleArray;
            boolean bl = details = bundle != null;
            if (bundles != null && bundles.length > 0) {
                Util.sort(bundles);
                jw.key("data");
                jw.array();
                for (int i = 0; i < bundles.length; ++i) {
                    this.bundleInfo(jw, bundles[i], details);
                }
                jw.endArray();
            } else {
                jw.key("error");
                jw.value((Object)"No Bundles installed currently");
            }
            jw.endObject();
        }
        catch (JSONException je) {
            throw new IOException(je.toString());
        }
        pw.println(";");
        pw.println("renderBundle( bundleListData );");
        Util.endScript(pw);
    }

    private void bundleInfo(JSONWriter jw, Bundle bundle, boolean details) throws JSONException {
        jw.object();
        jw.key("id");
        jw.value(bundle.getBundleId());
        jw.key("name");
        jw.value((Object)Util.getName(bundle));
        jw.key("state");
        jw.value((Object)this.toStateString(bundle.getState()));
        jw.key("actions");
        jw.array();
        if (bundle.getBundleId() == 0L) {
            jw.value(false);
            jw.value(false);
            jw.value(false);
            jw.value(false);
        } else {
            this.action(jw, this.hasStart(bundle), "start", "Start");
            this.action(jw, this.hasStop(bundle), "stop", "Stop");
            this.action(jw, this.hasUpdate(bundle), "update", "Update");
            this.action(jw, this.hasUninstall(bundle), "uninstall", "Uninstall");
        }
        jw.endArray();
        if (details) {
            this.bundleDetails(jw, bundle);
        }
        jw.endObject();
    }

    protected Bundle[] getBundles() {
        return this.getBundleContext().getBundles();
    }

    private String toStateString(int bundleState) {
        switch (bundleState) {
            case 2: {
                return "Installed";
            }
            case 4: {
                return "Resolved";
            }
            case 8: {
                return "Starting";
            }
            case 32: {
                return "Active";
            }
            case 16: {
                return "Stopping";
            }
            case 1: {
                return "Uninstalled";
            }
        }
        return "Unknown: " + bundleState;
    }

    private void action(JSONWriter jw, boolean enabled, String op, String opLabel) throws JSONException {
        jw.object();
        jw.key("enabled");
        jw.value(enabled);
        jw.key("name");
        jw.value((Object)opLabel);
        jw.key("link");
        jw.value((Object)op);
        jw.endObject();
    }

    private boolean hasStart(Bundle bundle) {
        return bundle.getState() == 2 || bundle.getState() == 4;
    }

    private boolean hasStop(Bundle bundle) {
        return bundle.getState() == 32;
    }

    private boolean hasUpdate(Bundle bundle) {
        if (bundle.getSymbolicName() == null) {
            return false;
        }
        Object isObject = this.getService(REPOSITORY_ADMIN_NAME);
        if (isObject == null) {
            return false;
        }
        Version bundleVersion = Version.parseVersion((String)((String)bundle.getHeaders().get("Bundle-Version")));
        RepositoryAdmin repoAdmin = (RepositoryAdmin)isObject;
        Repository[] repositories = repoAdmin.listRepositories();
        for (int i = 0; i < repositories.length; ++i) {
            Resource[] resources = repositories[i].getResources();
            for (int j = 0; resources != null && j < resources.length; ++j) {
                Resource res = resources[j];
                if (!bundle.getSymbolicName().equals(res.getSymbolicName()) || res.getVersion().compareTo((Object)bundleVersion) <= 0) continue;
                return true;
            }
        }
        return false;
    }

    private boolean hasUninstall(Bundle bundle) {
        return bundle.getState() == 2 || bundle.getState() == 4 || bundle.getState() == 32;
    }

    private void performAction(JSONWriter jw, Bundle bundle) throws JSONException {
        jw.object();
        jw.key(BUNDLE_ID);
        jw.value(bundle.getBundleId());
        this.bundleDetails(jw, bundle);
        jw.endObject();
    }

    private void bundleDetails(JSONWriter jw, Bundle bundle) throws JSONException {
        Dictionary headers = bundle.getHeaders();
        jw.key("props");
        jw.array();
        this.keyVal(jw, "Symbolic Name", bundle.getSymbolicName());
        this.keyVal(jw, "Version", headers.get("Bundle-Version"));
        this.keyVal(jw, "Location", bundle.getLocation());
        this.keyVal(jw, "Last Modification", new Date(bundle.getLastModified()));
        String docUrl = (String)headers.get("Bundle-DocURL");
        if (docUrl != null) {
            docUrl = "<a href=\"" + docUrl + "\" target=\"_blank\">" + docUrl + "</a>";
            this.keyVal(jw, "Bundle Documentation", docUrl);
        }
        this.keyVal(jw, "Vendor", headers.get("Bundle-Vendor"));
        this.keyVal(jw, "Copyright", headers.get("Bundle-Copyright"));
        this.keyVal(jw, "Description", headers.get("Bundle-Description"));
        this.keyVal(jw, "Start Level", this.getStartLevel(bundle));
        this.keyVal(jw, "Bundle Classpath", headers.get("Bundle-ClassPath"));
        if (bundle.getState() == 2) {
            this.listImportExportsUnresolved(jw, bundle);
        } else {
            this.listImportExport(jw, bundle);
        }
        this.listServices(jw, bundle);
        jw.endArray();
    }

    private Integer getStartLevel(Bundle bundle) {
        StartLevel sl = this.getStartLevel();
        return sl != null ? new Integer(sl.getBundleStartLevel(bundle)) : null;
    }

    private void listImportExport(JSONWriter jw, Bundle bundle) throws JSONException {
        StringBuffer val;
        PackageAdmin packageAdmin = this.getPackageAdmin();
        if (packageAdmin == null) {
            return;
        }
        TreeMap<String, Bundle> usingBundles = new TreeMap<String, Bundle>();
        ExportedPackage[] exports = packageAdmin.getExportedPackages(bundle);
        if (exports != null && exports.length > 0) {
            Arrays.sort(exports, new Comparator(){

                public int compare(ExportedPackage p1, ExportedPackage p2) {
                    return p1.getName().compareTo(p2.getName());
                }

                public int compare(Object o1, Object o2) {
                    return this.compare((ExportedPackage)o1, (ExportedPackage)o2);
                }
            });
            val = new StringBuffer();
            for (int j = 0; j < exports.length; ++j) {
                ExportedPackage export = exports[j];
                this.printExport(val, export.getName(), export.getVersion());
                Bundle[] ubList = export.getImportingBundles();
                if (ubList == null) continue;
                for (int i = 0; i < ubList.length; ++i) {
                    Bundle ub = ubList[i];
                    usingBundles.put(ub.getSymbolicName(), ub);
                }
            }
            this.keyVal(jw, "Exported Packages", val.toString());
        } else {
            this.keyVal(jw, "Exported Packages", "None");
        }
        exports = packageAdmin.getExportedPackages((Bundle)null);
        if (exports != null && exports.length > 0) {
            ArrayList<ExportedPackage> imports = new ArrayList<ExportedPackage>();
            block2: for (int i = 0; i < exports.length; ++i) {
                ExportedPackage ep = exports[i];
                Bundle[] importers = ep.getImportingBundles();
                for (int j = 0; importers != null && j < importers.length; ++j) {
                    if (importers[j].getBundleId() != bundle.getBundleId()) continue;
                    imports.add(ep);
                    continue block2;
                }
            }
            StringBuffer val2 = new StringBuffer();
            if (imports.size() > 0) {
                ExportedPackage[] packages = imports.toArray(new ExportedPackage[imports.size()]);
                Arrays.sort(packages, new Comparator(){

                    public int compare(ExportedPackage p1, ExportedPackage p2) {
                        return p1.getName().compareTo(p2.getName());
                    }

                    public int compare(Object o1, Object o2) {
                        return this.compare((ExportedPackage)o1, (ExportedPackage)o2);
                    }
                });
                for (int i = 0; i < packages.length; ++i) {
                    ExportedPackage ep = packages[i];
                    this.printImport(val2, ep.getName(), ep.getVersion(), false, ep);
                }
            } else {
                val2.append("None");
            }
            this.keyVal(jw, "Imported Packages", val2.toString());
        }
        if (!usingBundles.isEmpty()) {
            val = new StringBuffer();
            Iterator ui = usingBundles.values().iterator();
            while (ui.hasNext()) {
                Bundle usingBundle = (Bundle)ui.next();
                val.append(this.getBundleDescriptor(usingBundle));
                val.append("<br />");
            }
            this.keyVal(jw, "Importing Bundles", val.toString());
        }
    }

    private void listImportExportsUnresolved(JSONWriter jw, Bundle bundle) throws JSONException {
        int i;
        R4Package[] pkgs;
        Dictionary dict = bundle.getHeaders();
        String target = (String)dict.get("Export-Package");
        if (target != null) {
            pkgs = R4Package.parseImportOrExportHeader((String)target);
            if (pkgs != null && pkgs.length > 0) {
                Arrays.sort(pkgs, new Comparator(){

                    public int compare(R4Package p1, R4Package p2) {
                        return p1.getName().compareTo(p2.getName());
                    }

                    public int compare(Object o1, Object o2) {
                        return this.compare((R4Package)o1, (R4Package)o2);
                    }
                });
                StringBuffer val = new StringBuffer();
                for (i = 0; i < pkgs.length; ++i) {
                    R4Export export = new R4Export(pkgs[i]);
                    this.printExport(val, export.getName(), export.getVersion());
                }
                this.keyVal(jw, "Exported Packages", val.toString());
            } else {
                this.keyVal(jw, "Exported Packages", "None");
            }
        }
        if ((target = (String)dict.get("Import-Package")) != null && (pkgs = R4Package.parseImportOrExportHeader((String)target)) != null && pkgs.length > 0) {
            ExportedPackage[] exports;
            TreeMap<String, R4Import> imports = new TreeMap<String, R4Import>();
            for (i = 0; i < pkgs.length; ++i) {
                R4Package pkg = pkgs[i];
                imports.put(pkg.getName(), new R4Import(pkg));
            }
            HashMap<String, ExportedPackage> candidates = new HashMap<String, ExportedPackage>();
            PackageAdmin packageAdmin = this.getPackageAdmin();
            if (packageAdmin != null && (exports = packageAdmin.getExportedPackages((Bundle)null)) != null && exports.length > 0) {
                for (int i2 = 0; i2 < exports.length; ++i2) {
                    ExportedPackage ep = exports[i2];
                    R4Import imp = (R4Import)imports.get(ep.getName());
                    if (imp == null || !imp.isSatisfied(this.toR4Export(ep))) continue;
                    candidates.put(ep.getName(), ep);
                }
            }
            StringBuffer val = new StringBuffer();
            if (imports.size() > 0) {
                Iterator ii = imports.values().iterator();
                while (ii.hasNext()) {
                    String path;
                    R4Import r4Import = (R4Import)ii.next();
                    ExportedPackage ep = (ExportedPackage)candidates.get(r4Import.getName());
                    if (ep == null && bundle.getResource(path = r4Import.getName().replace('.', '/')) != null) continue;
                    this.printImport(val, r4Import.getName(), r4Import.getVersion(), r4Import.isOptional(), ep);
                }
            } else {
                val.append("None");
            }
            this.keyVal(jw, "Imported Packages", val.toString());
        }
    }

    private void listServices(JSONWriter jw, Bundle bundle) throws JSONException {
        ServiceReference[] refs = bundle.getRegisteredServices();
        if (refs == null || refs.length == 0) {
            return;
        }
        for (int i = 0; i < refs.length; ++i) {
            String key = "Service ID " + refs[i].getProperty("service.id");
            StringBuffer val = new StringBuffer();
            this.appendProperty(val, refs[i], "objectClass", "Types");
            this.appendProperty(val, refs[i], "service.pid", "PID");
            this.appendProperty(val, refs[i], "service.factoryPid", "Factory PID");
            this.appendProperty(val, refs[i], "component.name", "Component Name");
            this.appendProperty(val, refs[i], "component.id", "Component ID");
            this.appendProperty(val, refs[i], "component.factory", "Component Factory");
            this.appendProperty(val, refs[i], "service.description", "Description");
            this.appendProperty(val, refs[i], "service.vendor", "Vendor");
            this.keyVal(jw, key, val.toString());
        }
    }

    private void appendProperty(StringBuffer dest, ServiceReference ref, String name, String label) {
        Object value = ref.getProperty(name);
        if (value instanceof Object[]) {
            Object[] values = (Object[])value;
            dest.append(label).append(": ");
            for (int j = 0; j < values.length; ++j) {
                if (j > 0) {
                    dest.append(", ");
                }
                dest.append(values[j]);
            }
            dest.append("<br />");
        } else if (value != null) {
            dest.append(label).append(": ").append(value).append("<br />");
        }
    }

    private void keyVal(JSONWriter jw, String key, Object value) throws JSONException {
        if (key != null && value != null) {
            jw.object();
            jw.key("key");
            jw.value((Object)key);
            jw.key("value");
            jw.value(value);
            jw.endObject();
        }
    }

    private void printExport(StringBuffer val, String name, Version version) {
        boolean bootDel = this.isBootDelegated(name);
        if (bootDel) {
            val.append("<span style=\"color: red\">!! ");
        }
        val.append(name);
        val.append(",version=");
        val.append(version);
        if (bootDel) {
            val.append(" -- Overwritten by Boot Delegation</span>");
        }
        val.append("<br />");
    }

    private void printImport(StringBuffer val, String name, Version version, boolean optional, ExportedPackage export) {
        boolean isSpan;
        boolean bootDel = this.isBootDelegated(name);
        boolean bl = isSpan = bootDel || export == null;
        if (isSpan) {
            val.append("<span style=\"color: red\">!! ");
        }
        val.append(name);
        val.append(",version=").append(version);
        val.append(" from ");
        if (export != null) {
            val.append(this.getBundleDescriptor(export.getExportingBundle()));
            if (bootDel) {
                val.append(" -- Overwritten by Boot Delegation");
            }
        } else {
            val.append(" -- Cannot be resolved");
            if (optional) {
                val.append(" but is not required");
            }
            if (bootDel) {
                val.append(" and overwritten by Boot Delegation");
            }
        }
        if (isSpan) {
            val.append("</span>");
        }
        val.append("<br />");
    }

    private boolean isBootDelegated(String pkgName) {
        if (pkgName.length() > 0) {
            for (int i = 0; i < this.bootPkgs.length; ++i) {
                if ((!this.bootPkgWildcards[i] || !pkgName.startsWith(this.bootPkgs[i]) && !this.bootPkgs[i].regionMatches(0, pkgName, 0, pkgName.length())) && (this.bootPkgWildcards[i] || !this.bootPkgs[i].equals(pkgName))) continue;
                return true;
            }
        }
        return false;
    }

    private R4Export toR4Export(ExportedPackage export) {
        R4Attribute version = new R4Attribute("version", export.getVersion().toString(), false);
        return new R4Export(export.getName(), null, new R4Attribute[]{version});
    }

    private String getBundleDescriptor(Bundle bundle) {
        StringBuffer val = new StringBuffer();
        if (bundle.getSymbolicName() != null) {
            val.append(bundle.getSymbolicName());
            val.append(" (").append(bundle.getBundleId());
            val.append(")");
        } else if (bundle.getLocation() != null) {
            val.append(bundle.getLocation());
            val.append(" (").append(bundle.getBundleId());
            val.append(")");
        } else {
            val.append(bundle.getBundleId());
        }
        return val.toString();
    }

    private void update(Bundle bundle) {
        RepositoryAdmin repoAdmin = (RepositoryAdmin)this.getService(REPOSITORY_ADMIN_NAME);
        if (repoAdmin != null && bundle.getSymbolicName() != null) {
            Version bundleVersion = Version.parseVersion((String)((String)bundle.getHeaders().get("Bundle-Version")));
            String filter = "(&(symbolicname=" + bundle.getSymbolicName() + ")(version>=" + bundleVersion + "))";
            Resource[] cand = repoAdmin.discoverResources(filter);
            Version base = bundleVersion;
            int idx = -1;
            for (int i = 0; cand != null && i < cand.length; ++i) {
                if (cand[i].getVersion().compareTo((Object)base) <= 0) continue;
                base = cand[i].getVersion();
                idx = i;
            }
            if (idx >= 0) {
                Resolver resolver = repoAdmin.resolver();
                resolver.add(cand[idx]);
                DeployerThread dt = new DeployerThread(resolver, this.getLog(), bundle.getState() == 32, "Update " + bundle.getSymbolicName());
                dt.start();
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

