/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.webconsole.internal.servlet;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.service.http.HttpContext;
import org.osgi.service.http.HttpService;

final class OsgiManagerHttpContext
implements HttpContext {
    private static final String HEADER_WWW_AUTHENTICATE = "WWW-Authenticate";
    private static final String HEADER_AUTHORIZATION = "Authorization";
    private static final String AUTHENTICATION_SCHEME_BASIC = "Basic";
    private static final String base64Table = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";
    private static final char base64Pad = '=';
    String realm;
    String userId;
    String user;
    private final HttpContext base;

    OsgiManagerHttpContext(HttpService httpService, String realm, String userId, String password) {
        this.base = httpService.createDefaultHttpContext();
        this.realm = realm;
        this.userId = userId;
        this.user = OsgiManagerHttpContext.encode(userId, password);
    }

    public String getMimeType(String name) {
        return this.base.getMimeType(name);
    }

    public URL getResource(String name) {
        URL url = this.base.getResource(name);
        if (url == null && name.endsWith("/")) {
            return this.base.getResource(name.substring(0, name.length() - 1));
        }
        return url;
    }

    public boolean handleSecurity(HttpServletRequest request, HttpServletResponse response) {
        int blank;
        if (this.user == null) {
            return true;
        }
        String authHeader = request.getHeader(HEADER_AUTHORIZATION);
        if (authHeader != null && authHeader.length() > 0 && (blank = (authHeader = authHeader.trim()).indexOf(32)) > 0) {
            String authType = authHeader.substring(0, blank);
            String authInfo = authHeader.substring(blank).trim();
            if (authType.equalsIgnoreCase(AUTHENTICATION_SCHEME_BASIC) && this.user.equals(authInfo)) {
                request.setAttribute("org.osgi.service.http.authentication.type", (Object)"");
                request.setAttribute("org.osgi.service.http.authentication.remote.user", (Object)this.userId);
                return true;
            }
        }
        response.setHeader(HEADER_WWW_AUTHENTICATE, "Basic realm=\"" + this.realm + "\"");
        try {
            response.sendError(401);
        }
        catch (IOException ioe) {
            response.setStatus(401);
        }
        return false;
    }

    public static String encode(String user, String password) {
        byte[] src;
        if (user == null || user.length() == 0) {
            return null;
        }
        String srcString = user + ":";
        if (password != null && password.length() > 0) {
            srcString = srcString + password;
        }
        try {
            src = srcString.getBytes("ISO-8859-1");
        }
        catch (UnsupportedEncodingException uee) {
            src = srcString.getBytes();
        }
        int srcsize = src.length;
        int tbllen = base64Table.length();
        StringBuffer result = new StringBuffer(srcsize);
        int tblpos = 0;
        int bitpos = 0;
        int bitsread = -1;
        int inpos = 0;
        byte pos = 0;
        while (inpos <= srcsize) {
            if (bitsread < 0) {
                if (inpos >= srcsize) break;
                pos = src[inpos++];
                bitsread = 7;
            }
            tblpos = 0;
            bitpos = tbllen / 2;
            while (bitpos > 0) {
                if (bitsread < 0) {
                    pos = inpos < srcsize ? src[inpos] : (byte)0;
                    ++inpos;
                    bitsread = 7;
                }
                if ((1 << bitsread & pos) != 0) {
                    tblpos += bitpos;
                }
                bitpos /= 2;
                --bitsread;
            }
            result.append(base64Table.charAt(tblpos));
        }
        while (bitsread != -1) {
            bitpos = tbllen / 2;
            while (bitpos > 0) {
                if (bitsread < 0) {
                    bitsread = 7;
                }
                bitpos /= 2;
                --bitsread;
            }
            result.append('=');
        }
        return result.toString();
    }
}

