/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.webconsole.internal.obr;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.felix.webconsole.Render;
import org.apache.felix.webconsole.internal.obr.AbstractObrPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Version;

public abstract class BundleRepositoryRender
extends AbstractObrPlugin
implements Render {
    public static final String NAME = "bundlerepo";
    public static final String LABEL = "OSGi Repository";
    public static final String PARAM_REPO_ID = "repositoryId";
    public static final String PARAM_REPO_URL = "repositoryURL";
    private static final String REPOSITORY_PROPERTY = "obr.repository.url";
    private String[] repoURLs;

    public void setBundleContext(BundleContext bundleContext) {
        super.setBundleContext(bundleContext);
        String urlStr = bundleContext.getProperty(REPOSITORY_PROPERTY);
        ArrayList<String> urlList = new ArrayList<String>();
        if (urlStr != null) {
            StringTokenizer st = new StringTokenizer(urlStr);
            while (st.hasMoreTokens()) {
                urlList.add(st.nextToken());
            }
        }
        this.repoURLs = urlList.toArray(new String[urlList.size()]);
    }

    public String getName() {
        return NAME;
    }

    public String getLabel() {
        return LABEL;
    }

    private void header(PrintWriter pw) {
        pw.println("<table class='content' cellpadding='0' cellspacing='0' width='100%'>");
        pw.println("<tr class='content'>");
        pw.println("<th class='content container' colspan='4'>Bundle Repositories</th>");
        pw.println("</tr>");
        pw.println("<tr class='content'>");
        pw.println("<th class='content'>Name</th>");
        pw.println("<th class='content'>URL</th>");
        pw.println("<th class='content'>Last Modification Time</th>");
        pw.println("<th class='content'>&nbsp;</th>");
        pw.println("</tr>");
    }

    private void footer(PrintWriter pw) {
        pw.println("</table>");
    }

    private void resourcesHeader(PrintWriter pw, boolean doForm) {
        if (doForm) {
            pw.println("<form method='post'>");
            pw.println("<input type='hidden' name='action' value='installFromOBR'>");
        }
        pw.println("<table class='content' cellpadding='0' cellspacing='0' width='100%'>");
        pw.println("<tr class='content'>");
        pw.println("<th class='content container' colspan='3'>Available Resources</th>");
        pw.println("</tr>");
        pw.println("<tr class='content'>");
        pw.println("<th class='content'>Deploy</th>");
        pw.println("<th class='content'>Name</th>");
        pw.println("<th class='content'>Version</th>");
        pw.println("</tr>");
    }

    private void resourcesButtons(PrintWriter pw) {
        pw.println("<tr class='content'>");
        pw.println("<td class='content'>&nbsp;</td>");
        pw.println("<td class='content' colspan='2'>");
        pw.println("<input class='submit' style='width:auto' type='submit' name='deploy' value='Deploy Selected'>");
        pw.println("&nbsp;&nbsp;&nbsp;");
        pw.println("<input class='submit' style='width:auto' type='submit' name='deploystart' value='Deploy and Start Selected'>");
        pw.println("</td></tr>");
    }

    private void resourcesFooter(PrintWriter pw, boolean doForm) {
        if (doForm) {
            this.resourcesButtons(pw);
        }
        pw.println("</table></form>");
    }

    private Map getBundles() {
        HashMap<String, Version> bundles = new HashMap<String, Version>();
        Bundle[] installed = this.getBundleContext().getBundles();
        for (int i = 0; i < installed.length; ++i) {
            String ver = (String)installed[i].getHeaders().get("Bundle-Version");
            Version bundleVersion = Version.parseVersion((String)ver);
            if (installed[i].getSymbolicName() == null) continue;
            bundles.put(installed[i].getSymbolicName(), bundleVersion);
        }
        return bundles;
    }
}

