/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.webconsole.internal.compendium;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Dictionary;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.felix.webconsole.Render;
import org.apache.felix.webconsole.internal.compendium.ConfigManagerBase;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.metatype.ObjectClassDefinition;

public class ConfigManager
extends ConfigManagerBase
implements Render {
    public static final String NAME = "configMgr";
    public static final String LABEL = "Configuration";
    public static final String PID = "pid";
    static /* synthetic */ Class class$org$osgi$service$cm$ManagedServiceFactory;

    public String getLabel() {
        return LABEL;
    }

    public String getName() {
        return NAME;
    }

    public void render(HttpServletRequest request, HttpServletResponse response) throws IOException {
        boolean optionalMetaType = false;
        PrintWriter pw = response.getWriter();
        pw.println("<script type='text/javascript' src='res/ui/configmanager.js'></script>");
        pw.println("<table class='content' cellpadding='0' cellspacing='0' width='100%'>");
        pw.println("<tr class='content' id='configField'>");
        pw.println("<td class='content'>Configurations</th>");
        pw.println("<td class='content'>");
        this.listConfigurations(pw, optionalMetaType, this.getLocale(request));
        pw.println("</td>");
        pw.println("</tr>");
        pw.println("</table>");
    }

    private void listConfigurations(PrintWriter pw, boolean optionalMetaType, Locale loc) {
        ConfigurationAdmin ca = this.getConfigurationAdmin();
        if (ca == null) {
            pw.print("Configuration Admin Service not available");
            return;
        }
        String locale = loc != null ? loc.toString() : null;
        try {
            ObjectClassDefinition ocd;
            String pid;
            Map metaDataPids = this.getMetadataPids();
            TreeMap<String, String> options = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
            ServiceReference[] refs = this.getBundleContext().getServiceReferences((class$org$osgi$service$cm$ManagedServiceFactory == null ? (class$org$osgi$service$cm$ManagedServiceFactory = ConfigManager.class$("org.osgi.service.cm.ManagedServiceFactory")) : class$org$osgi$service$cm$ManagedServiceFactory).getName(), null);
            for (int i = 0; refs != null && i < refs.length; ++i) {
                String name;
                Object factoryPid = refs[i].getProperty("service.pid");
                if (!(factoryPid instanceof String)) continue;
                pid = (String)factoryPid;
                ocd = this.getObjectClassDefinition(refs[i].getBundle(), pid, locale);
                if (ocd != null) {
                    name = ocd.getName() + " (";
                    name = name + pid + ")";
                } else {
                    name = pid;
                }
                if (ocd == null && !optionalMetaType) continue;
                options.put("factoryPid=" + pid, name);
            }
            Configuration[] cfgs = ca.listConfigurations(null);
            for (int i = 0; cfgs != null && i < cfgs.length; ++i) {
                String name;
                pid = cfgs[i].getPid();
                if (options.containsKey("pid=" + pid) || options.containsKey("factoryPid=" + pid)) continue;
                Dictionary props = cfgs[i].getProperties();
                ocd = this.getObjectClassDefinition(cfgs[i], locale);
                if (ocd != null) {
                    name = ocd.getName() + " (";
                    name = name + pid + ")";
                    metaDataPids.remove(pid);
                } else {
                    name = pid;
                }
                if (ocd != null || optionalMetaType) {
                    options.put("pid=" + pid, name);
                }
                if (cfgs[i].getFactoryPid() == null) continue;
                pid = cfgs[i].getFactoryPid();
                if (options.containsValue("factoryPid=" + pid)) continue;
                String existing = (String)options.remove("pid=" + pid);
                if (existing != null) {
                    options.put("factoryPid=" + pid, existing);
                    continue;
                }
                Bundle bundle = this.getBundle(cfgs[i].getBundleLocation());
                ocd = this.getObjectClassDefinition(bundle, pid, locale);
                if (ocd != null) {
                    options.put("factoryPid=" + pid, ocd.getName());
                    continue;
                }
                if (!optionalMetaType) continue;
                options.put("factoryPid=" + pid, pid);
            }
            if (!metaDataPids.isEmpty()) {
                Iterator mdpi = metaDataPids.entrySet().iterator();
                while (mdpi.hasNext()) {
                    Map.Entry mdp = mdpi.next();
                    ObjectClassDefinition ocd2 = this.getObjectClassDefinition((Bundle)mdp.getValue(), (String)mdp.getKey(), locale);
                    options.put("pid=" + mdp.getKey(), ocd2.getName() + " (" + mdp.getKey() + ")");
                }
            }
            pw.println("<form method='post' name='configSelection' onSubmit='configure(); return false;'");
            pw.println("<input type='hidden' name='action' value='setStartLevel'>");
            pw.println("<select class='select' name='pid' onChange='configure();'>");
            Iterator ei = options.entrySet().iterator();
            while (ei.hasNext()) {
                Map.Entry entry = ei.next();
                pw.print("<option value='" + entry.getKey() + "'>");
                pw.print(entry.getValue());
                pw.println("</option>");
            }
            pw.println("</select>");
            pw.println("&nbsp;&nbsp;");
            pw.println("<input class='submit' type='submit' value='Configure' />");
            pw.println("</form>");
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

