/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.composite.service.instantiator;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.Handler;
import org.apache.felix.ipojo.architecture.HandlerDescription;
import org.apache.felix.ipojo.composite.CompositeHandler;
import org.apache.felix.ipojo.composite.service.instantiator.ServiceImporter;
import org.apache.felix.ipojo.composite.service.instantiator.SvcInstance;
import org.apache.felix.ipojo.metadata.Attribute;
import org.apache.felix.ipojo.metadata.Element;
import org.osgi.framework.ServiceReference;

public class ServiceInstantiatorDescription
extends HandlerDescription {
    private List m_instances;
    private List m_imports;

    public ServiceInstantiatorDescription(CompositeHandler handler, List insts, List imps) {
        super((Handler)handler);
        this.m_instances = insts;
        this.m_imports = imps;
    }

    public Element getHandlerInfo() {
        int i;
        Element services = super.getHandlerInfo();
        for (i = 0; i < this.m_imports.size(); ++i) {
            ServiceImporter imp = (ServiceImporter)((Object)this.m_imports.get(i));
            Element impo = new Element("Requires", "");
            impo.addAttribute(new Attribute("Specification", imp.getSpecification().getName()));
            if (imp.getFilter() != null) {
                impo.addAttribute(new Attribute("Filter", imp.getFilter()));
            }
            if (imp.getState() == 1) {
                impo.addAttribute(new Attribute("State", "resolved"));
                for (int j = 0; j < imp.getProviders().size(); ++j) {
                    Element prov = new Element("Provider", "");
                    prov.addAttribute(new Attribute("name", (String)imp.getProviders().get(j)));
                    impo.addElement(prov);
                }
            } else {
                impo.addAttribute(new Attribute("State", "unresolved"));
            }
            services.addElement(impo);
        }
        for (i = 0; i < this.m_instances.size(); ++i) {
            SvcInstance inst = (SvcInstance)((Object)this.m_instances.get(i));
            Element service = new Element("Service", "");
            service.addAttribute(new Attribute("Specification", inst.getServiceSpecification()));
            String state = "unresolved";
            if (inst.getState() == 1) {
                state = "resolved";
            }
            service.addAttribute(new Attribute("State", state));
            Map map = inst.getMatchingFactories();
            Set keys = map.keySet();
            for (ServiceReference ref : keys) {
                Object object = map.get(ref);
                if (object == null) continue;
                Element fact = new Element("Factory", "");
                fact.addAttribute(new Attribute("Name", ((ComponentInstance)object).getFactory().getName()));
                service.addElement(fact);
            }
            services.addElement(service);
        }
        return services;
    }
}

