/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.manipulator.spi;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.felix.ipojo.manipulator.metadata.annotation.model.AnnotationType;
import org.apache.felix.ipojo.manipulator.metadata.annotation.model.literal.AnnotationPlayback;
import org.apache.felix.ipojo.manipulator.metadata.annotation.registry.Binding;
import org.apache.felix.ipojo.manipulator.metadata.annotation.visitor.generic.GenericVisitorFactory;
import org.apache.felix.ipojo.manipulator.metadata.annotation.visitor.ignore.NullBinding;
import org.apache.felix.ipojo.manipulator.metadata.annotation.visitor.stereotype.StereotypeVisitorFactory;
import org.apache.felix.ipojo.manipulator.metadata.annotation.visitor.util.Elements;
import org.apache.felix.ipojo.manipulator.spi.AnnotationLiteral;
import org.apache.felix.ipojo.manipulator.spi.AnnotationVisitorFactory;
import org.apache.felix.ipojo.manipulator.spi.Module;
import org.apache.felix.ipojo.manipulator.spi.Predicate;
import org.apache.felix.ipojo.manipulator.spi.helper.Predicates;
import org.apache.felix.ipojo.metadata.Element;
import org.objectweb.asm.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbsBindingModule
implements Module {
    private final List<Binding> bindings = new ArrayList<Binding>();
    private boolean loaded = false;

    @Override
    public synchronized void load() {
        if (!this.loaded) {
            this.configure();
            this.loaded = true;
        }
    }

    protected abstract void configure();

    @Override
    public Iterator<Binding> iterator() {
        return this.bindings.iterator();
    }

    protected AnnotationBindingBuilder bind(Class<? extends Annotation> annotationType) {
        return new AnnotationBindingBuilder(this.bindings, annotationType);
    }

    protected StereotypeBindingBuilder bindStereotype(Class<? extends Annotation> annotationType) {
        return new StereotypeBindingBuilder(this.bindings, annotationType);
    }

    protected HandlerBindingBuilder bindHandlerBinding(Class<? extends Annotation> annotationType) {
        return new HandlerBindingBuilder(this.bindings, annotationType);
    }

    protected void bindIgnore(Class<? extends Annotation> annotationType) {
        this.bindings.add(new NullBinding(Type.getType(annotationType)));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class HandlerBindingBuilder {
        private final Binding m_binding = new Binding();

        public HandlerBindingBuilder(List<Binding> bindings, Class<? extends Annotation> annotationType) {
            Type type = Type.getType(annotationType);
            this.m_binding.setAnnotationType(type);
            this.m_binding.setPredicate(Predicates.onlySupportedElements(annotationType));
            Element e = Elements.buildElement(type);
            this.m_binding.setFactory(new GenericVisitorFactory(e.getName(), e.getNameSpace()));
            bindings.add(this.m_binding);
        }

        public void to(String namespace, String name) {
            this.m_binding.setFactory(new GenericVisitorFactory(name, namespace));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class StereotypeBindingBuilder {
        private final AnnotationType m_annotationType;

        public StereotypeBindingBuilder(List<Binding> bindings, Class<? extends Annotation> type) {
            this.m_annotationType = new AnnotationType(Type.getType(type));
            Binding binding = new Binding();
            binding.setAnnotationType(this.m_annotationType.getType());
            binding.setPredicate(Predicates.onlySupportedElements(type));
            binding.setFactory(new StereotypeVisitorFactory(this.m_annotationType));
            bindings.add(binding);
        }

        public StereotypeBindingBuilder with(AnnotationLiteral<?> literal) {
            this.m_annotationType.getPlaybacks().add(new AnnotationPlayback(literal));
            return this;
        }
    }

    public class ConditionalBindingBuilder {
        private AnnotationBindingBuilder parent;
        private Predicate predicate;
        private AnnotationVisitorFactory factory;

        public ConditionalBindingBuilder(AnnotationBindingBuilder parent, Predicate predicate) {
            this.parent = parent;
            this.predicate = predicate;
        }

        public AnnotationBindingBuilder to(AnnotationVisitorFactory factory) {
            this.factory = factory;
            AbsBindingModule.this.bindings.add(this.build());
            return this.parent;
        }

        private Binding build() {
            Binding binding = this.parent.build();
            binding.setPredicate(this.predicate);
            binding.setFactory(this.factory);
            return binding;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class AnnotationBindingBuilder {
        private Class<? extends Annotation> annotationType;
        private AnnotationVisitorFactory factory;
        private List<Binding> registry;

        public AnnotationBindingBuilder(List<Binding> registry, Class<? extends Annotation> annotationType) {
            this.registry = registry;
            this.annotationType = annotationType;
        }

        public ConditionalBindingBuilder when(Predicate predicate) {
            return new ConditionalBindingBuilder(this, predicate);
        }

        public void to(AnnotationVisitorFactory factory) {
            this.factory = factory;
            this.registry.add(this.build());
        }

        private Binding build() {
            Binding binding = new Binding();
            binding.setAnnotationType(Type.getType(this.annotationType));
            binding.setPredicate(Predicates.onlySupportedElements(this.annotationType));
            binding.setFactory(this.factory);
            return binding;
        }
    }
}

