/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.manipulator.reporter;

import java.io.PrintStream;
import org.apache.felix.ipojo.manipulator.reporter.EmptyReporter;

public class SystemReporter
extends EmptyReporter {
    private boolean enableTrace = false;

    public void setEnableTrace(boolean enableTrace) {
        this.enableTrace = enableTrace;
    }

    private void log(PrintStream stream, Level level, String formatted, Throwable throwable) {
        stream.println(level.append(formatted));
        if (throwable != null) {
            throwable.printStackTrace(stream);
        }
    }

    public void trace(String message, Object ... args) {
        if (this.enableTrace) {
            String formatted = String.format(message, this.getMessageArguments(args));
            this.log(System.out, Level.TRACE, formatted, this.getThrowable(new Object[0]));
        }
    }

    public void info(String message, Object ... args) {
        String formatted = String.format(message, this.getMessageArguments(args));
        this.log(System.out, Level.INFO, formatted, this.getThrowable(new Object[0]));
    }

    public void warn(String message, Object ... args) {
        String formatted = String.format(message, this.getMessageArguments(args));
        Throwable throwable = this.getThrowable(new Object[0]);
        this.log(System.out, Level.WARN, formatted, throwable);
        if (throwable != null) {
            formatted = formatted + " ";
            formatted = formatted + throwable.getMessage();
        }
        this.getWarnings().add(formatted);
    }

    public void error(String message, Object ... args) {
        String formatted = String.format(message, this.getMessageArguments(args));
        Throwable throwable = this.getThrowable(new Object[0]);
        this.log(System.out, Level.ERROR, formatted, throwable);
        if (throwable != null) {
            formatted = formatted + " ";
            formatted = formatted + throwable.getMessage();
        }
        this.getErrors().add(formatted);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Level {
        TRACE("#"),
        INFO("I"),
        WARN("W"),
        ERROR("E");

        private String value;

        private Level(String value) {
            this.value = value;
        }

        public String append(String message) {
            return this.value + " " + message;
        }
    }
}

