/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.manipulator.metadata.annotation.visitor.util;

import java.io.IOException;
import java.lang.annotation.ElementType;
import java.util.ArrayList;
import java.util.List;
import java.util.ServiceLoader;
import org.apache.felix.ipojo.manipulator.Reporter;
import org.apache.felix.ipojo.manipulator.ResourceStore;
import org.apache.felix.ipojo.manipulator.metadata.annotation.registry.AnnotationRegistry;
import org.apache.felix.ipojo.manipulator.metadata.annotation.registry.Binding;
import org.apache.felix.ipojo.manipulator.metadata.annotation.registry.BindingRegistry;
import org.apache.felix.ipojo.manipulator.metadata.annotation.stereotype.StereotypeParser;
import org.apache.felix.ipojo.manipulator.metadata.annotation.visitor.generic.FieldGenericVisitor;
import org.apache.felix.ipojo.manipulator.metadata.annotation.visitor.generic.MethodGenericVisitor;
import org.apache.felix.ipojo.manipulator.metadata.annotation.visitor.generic.ParameterGenericVisitor;
import org.apache.felix.ipojo.manipulator.metadata.annotation.visitor.generic.TypeGenericVisitor;
import org.apache.felix.ipojo.manipulator.metadata.annotation.visitor.stereotype.FieldStereotypeVisitor;
import org.apache.felix.ipojo.manipulator.metadata.annotation.visitor.stereotype.MethodStereotypeVisitor;
import org.apache.felix.ipojo.manipulator.metadata.annotation.visitor.stereotype.ParameterStereotypeVisitor;
import org.apache.felix.ipojo.manipulator.metadata.annotation.visitor.stereotype.TypeStereotypeVisitor;
import org.apache.felix.ipojo.manipulator.metadata.annotation.visitor.util.Elements;
import org.apache.felix.ipojo.manipulator.spi.AnnotationVisitorFactory;
import org.apache.felix.ipojo.manipulator.spi.BindingContext;
import org.apache.felix.ipojo.manipulator.spi.Module;
import org.apache.felix.ipojo.manipulator.spi.Predicate;
import org.apache.felix.ipojo.manipulator.spi.helper.Predicates;
import org.apache.felix.ipojo.manipulator.util.Strings;
import org.apache.felix.ipojo.metadata.Element;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.MethodNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Bindings {
    private static Binding newGenericTypeBinding() {
        Binding binding = new Binding();
        binding.setPredicate(Predicates.and(Predicates.on(ElementType.TYPE), Bindings.customAnnotationPattern()));
        binding.setFactory(new AnnotationVisitorFactory(){

            public AnnotationVisitor newAnnotationVisitor(BindingContext context) {
                Element element = Elements.buildElement(context.getAnnotationType());
                return new TypeGenericVisitor(context.getWorkbench(), element);
            }
        });
        return binding;
    }

    private static Predicate customAnnotationPattern() {
        return Predicates.pattern("(.*\\.ipojo\\..*)|(.*\\.handler\\..*)").matches();
    }

    private static Binding newGenericFieldBinding() {
        Binding binding = new Binding();
        binding.setPredicate(Predicates.and(Predicates.on(ElementType.FIELD), Bindings.customAnnotationPattern()));
        binding.setFactory(new AnnotationVisitorFactory(){

            public AnnotationVisitor newAnnotationVisitor(BindingContext context) {
                Element element = Elements.buildElement(context.getAnnotationType());
                return new FieldGenericVisitor(context.getWorkbench(), element, (FieldNode)context.getNode());
            }
        });
        return binding;
    }

    private static Binding newGenericMethodBinding() {
        Binding binding = new Binding();
        binding.setPredicate(Predicates.and(Predicates.on(ElementType.METHOD), Bindings.customAnnotationPattern()));
        binding.setFactory(new AnnotationVisitorFactory(){

            public AnnotationVisitor newAnnotationVisitor(BindingContext context) {
                Element element = Elements.buildElement(context.getAnnotationType());
                return new MethodGenericVisitor(context.getWorkbench(), element, (MethodNode)context.getNode());
            }
        });
        return binding;
    }

    private static Binding newGenericParameterBinding() {
        Binding binding = new Binding();
        binding.setPredicate(Predicates.and(Predicates.on(ElementType.PARAMETER), Bindings.customAnnotationPattern()));
        binding.setFactory(new AnnotationVisitorFactory(){

            public AnnotationVisitor newAnnotationVisitor(BindingContext context) {
                Element element = Elements.buildElement(context.getAnnotationType());
                return new ParameterGenericVisitor(context.getWorkbench(), element, (MethodNode)context.getNode(), context.getParameterIndex());
            }
        });
        return binding;
    }

    public static BindingRegistry newBindingRegistry(Reporter reporter, ResourceStore store) {
        AnnotationRegistry ar = new AnnotationRegistry();
        BindingRegistry registry = new BindingRegistry(reporter);
        ServiceLoader<Module> loader = ServiceLoader.load(Module.class, Bindings.classloader());
        for (Module module : loader) {
            module.configure();
            registry.addBindings(module);
        }
        registry.getDefaultBindings().addAll(Bindings.newDefaultBindings(store, ar));
        return registry;
    }

    public static List<Binding> newDefaultBindings(ResourceStore store, AnnotationRegistry ar) {
        ArrayList<Binding> bindings = new ArrayList<Binding>();
        bindings.add(Bindings.newStereotypeTypeBinding(store, ar));
        bindings.add(Bindings.newStereotypeFieldBinding(store, ar));
        bindings.add(Bindings.newStereotypeMethodBinding(store, ar));
        bindings.add(Bindings.newStereotypeParameterBinding(store, ar));
        bindings.add(Bindings.newGenericTypeBinding());
        bindings.add(Bindings.newGenericFieldBinding());
        bindings.add(Bindings.newGenericMethodBinding());
        bindings.add(Bindings.newGenericParameterBinding());
        return bindings;
    }

    private static Binding newStereotypeParameterBinding(ResourceStore store, final AnnotationRegistry registry) {
        Binding binding = new Binding();
        binding.setPredicate(Predicates.and(Predicates.on(ElementType.PARAMETER), Bindings.stereotype(store, registry)));
        binding.setFactory(new AnnotationVisitorFactory(){

            public AnnotationVisitor newAnnotationVisitor(BindingContext context) {
                return new ParameterStereotypeVisitor((MethodVisitor)context.getVisitor(), context.getParameterIndex(), registry.getRecorders(context.getAnnotationType()));
            }
        });
        return binding;
    }

    private static Binding newStereotypeMethodBinding(ResourceStore store, final AnnotationRegistry registry) {
        Binding binding = new Binding();
        binding.setPredicate(Predicates.and(Predicates.on(ElementType.METHOD), Bindings.stereotype(store, registry)));
        binding.setFactory(new AnnotationVisitorFactory(){

            public AnnotationVisitor newAnnotationVisitor(BindingContext context) {
                return new MethodStereotypeVisitor((MethodVisitor)context.getVisitor(), registry.getRecorders(context.getAnnotationType()));
            }
        });
        return binding;
    }

    private static Binding newStereotypeFieldBinding(ResourceStore store, final AnnotationRegistry registry) {
        Binding binding = new Binding();
        binding.setPredicate(Predicates.and(Predicates.on(ElementType.FIELD), Bindings.stereotype(store, registry)));
        binding.setFactory(new AnnotationVisitorFactory(){

            public AnnotationVisitor newAnnotationVisitor(BindingContext context) {
                return new FieldStereotypeVisitor((FieldVisitor)context.getVisitor(), registry.getRecorders(context.getAnnotationType()));
            }
        });
        return binding;
    }

    private static Binding newStereotypeTypeBinding(ResourceStore store, final AnnotationRegistry registry) {
        Binding binding = new Binding();
        binding.setPredicate(Predicates.and(Predicates.on(ElementType.TYPE), Bindings.stereotype(store, registry)));
        binding.setFactory(new AnnotationVisitorFactory(){

            public AnnotationVisitor newAnnotationVisitor(BindingContext context) {
                return new TypeStereotypeVisitor((ClassVisitor)context.getVisitor(), registry.getRecorders(context.getAnnotationType()));
            }
        });
        return binding;
    }

    private static Predicate stereotype(final ResourceStore store, final AnnotationRegistry registry) {
        return new Predicate(){

            public boolean matches(BindingContext context) {
                Type type = context.getAnnotationType();
                if (registry.isUnknown(type)) {
                    try {
                        byte[] bytes = store.read(Strings.asResourcePath(context.getAnnotationType().getClassName()));
                        StereotypeParser parser = new StereotypeParser();
                        parser.read(bytes);
                        if (parser.isStereotype()) {
                            registry.addStereotype(type, parser.getRecorders());
                            return true;
                        }
                        registry.addUnbound(type);
                        return false;
                    }
                    catch (IOException e) {
                        registry.addUnbound(type);
                        return false;
                    }
                }
                return registry.isStereotype(type);
            }
        };
    }

    private static ClassLoader classloader() {
        return Bindings.class.getClassLoader();
    }
}

