/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.composite.service.instantiator;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.ConfigurationException;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.apache.felix.ipojo.PolicyServiceContext;
import org.apache.felix.ipojo.architecture.HandlerDescription;
import org.apache.felix.ipojo.composite.CompositeHandler;
import org.apache.felix.ipojo.composite.instance.InstanceHandler;
import org.apache.felix.ipojo.composite.service.instantiator.ServiceImporter;
import org.apache.felix.ipojo.composite.service.instantiator.ServiceInstantiatorDescription;
import org.apache.felix.ipojo.composite.service.instantiator.SvcInstance;
import org.apache.felix.ipojo.composite.util.SourceManager;
import org.apache.felix.ipojo.metadata.Element;
import org.apache.felix.ipojo.parser.ParseException;
import org.apache.felix.ipojo.util.DependencyModel;
import org.apache.felix.ipojo.util.DependencyStateListener;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;

public class ServiceDependencyHandler
extends CompositeHandler
implements DependencyStateListener,
Pojo {
    private InstanceManager __IM;
    private boolean __Fm_instances;
    private List m_instances;
    private boolean __Fm_importers;
    private List m_importers;
    private boolean __Fm_isStarted;
    private boolean m_isStarted;
    private boolean __Fm_description;
    private ServiceInstantiatorDescription m_description;
    private boolean __Fm_sources;
    private List m_sources;
    private boolean __McreateServiceInstance$org_apache_felix_ipojo_metadata_Element$java_util_Dictionary;
    private boolean __McreateServiceImport$org_apache_felix_ipojo_metadata_Element$java_util_Dictionary;
    private boolean __Mconfigure$org_apache_felix_ipojo_metadata_Element$java_util_Dictionary;
    private boolean __Mstart;
    private boolean __MisHandlerValid;
    private boolean __Mstop;
    private boolean __MstateChanged$int;
    private boolean __Mvalidate$org_apache_felix_ipojo_util_DependencyModel;
    private boolean __Minvalidate$org_apache_felix_ipojo_util_DependencyModel;
    private boolean __MgetDescription;
    private boolean __MgetInstances;
    private boolean __MgetRequirements;

    List __getm_instances() {
        if (!this.__Fm_instances) {
            return this.m_instances;
        }
        return (List)this.__IM.onGet((Object)this, "m_instances");
    }

    void __setm_instances(List list) {
        if (!this.__Fm_instances) {
            this.m_instances = list;
            return;
        }
        this.__IM.onSet((Object)this, "m_instances", (Object)list);
    }

    List __getm_importers() {
        if (!this.__Fm_importers) {
            return this.m_importers;
        }
        return (List)this.__IM.onGet((Object)this, "m_importers");
    }

    void __setm_importers(List list) {
        if (!this.__Fm_importers) {
            this.m_importers = list;
            return;
        }
        this.__IM.onSet((Object)this, "m_importers", (Object)list);
    }

    boolean __getm_isStarted() {
        if (!this.__Fm_isStarted) {
            return this.m_isStarted;
        }
        Object object = this.__IM.onGet((Object)this, "m_isStarted");
        Boolean bl = (Boolean)object;
        return bl;
    }

    void __setm_isStarted(boolean bl) {
        if (!this.__Fm_isStarted) {
            this.m_isStarted = bl;
            return;
        }
        Boolean bl2 = new Boolean(bl);
        this.__IM.onSet((Object)this, "m_isStarted", (Object)bl2);
    }

    ServiceInstantiatorDescription __getm_description() {
        if (!this.__Fm_description) {
            return this.m_description;
        }
        return (ServiceInstantiatorDescription)((Object)this.__IM.onGet((Object)this, "m_description"));
    }

    void __setm_description(ServiceInstantiatorDescription serviceInstantiatorDescription) {
        if (!this.__Fm_description) {
            this.m_description = serviceInstantiatorDescription;
            return;
        }
        this.__IM.onSet((Object)this, "m_description", (Object)serviceInstantiatorDescription);
    }

    List __getm_sources() {
        if (!this.__Fm_sources) {
            return this.m_sources;
        }
        return (List)this.__IM.onGet((Object)this, "m_sources");
    }

    void __setm_sources(List list) {
        if (!this.__Fm_sources) {
            this.m_sources = list;
            return;
        }
        this.__IM.onSet((Object)this, "m_sources", (Object)list);
    }

    public ServiceDependencyHandler() {
        this(null);
    }

    private ServiceDependencyHandler(InstanceManager _manager) {
        this._setInstanceManager(_manager);
        this.__setm_instances(new ArrayList());
        this.__setm_importers(new ArrayList());
    }

    private void createServiceInstance(Element service, Dictionary conf) throws ConfigurationException {
        if (!this.__McreateServiceInstance$org_apache_felix_ipojo_metadata_Element$java_util_Dictionary) {
            this.__M_createServiceInstance(service, conf);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "createServiceInstance$org_apache_felix_ipojo_metadata_Element$java_util_Dictionary", new Object[]{service, conf});
            this.__M_createServiceInstance(service, conf);
            this.__IM.onExit((Object)this, "createServiceInstance$org_apache_felix_ipojo_metadata_Element$java_util_Dictionary", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "createServiceInstance$org_apache_felix_ipojo_metadata_Element$java_util_Dictionary", throwable);
            throw throwable;
        }
    }

    private void __M_createServiceInstance(Element service, Dictionary conf) throws ConfigurationException {
        Filter fil;
        Properties toAppend = new Properties();
        Enumeration keys = conf.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            if (key.equals("instance.name") || key.equals("component")) continue;
            toAppend.put(key, conf.get(key));
        }
        String spec = service.getAttribute("specification");
        if (spec == null) {
            throw new ConfigurationException("Malformed service : the specification attribute is mandatory");
        }
        String filter = "(&(!(factory.name=" + this.getCompositeManager().getFactory().getComponentDescription().getName() + "))(factory.state=1))";
        String givenFilter = service.getAttribute("filter");
        if (givenFilter != null) {
            filter = "(&" + filter + givenFilter + ")";
        }
        try {
            fil = this.getCompositeManager().getGlobalContext().createFilter(filter);
        }
        catch (InvalidSyntaxException e) {
            throw new ConfigurationException("Malformed filter " + filter, (Throwable)e);
        }
        Properties prop = new Properties();
        Element[] props = service.getElements("property");
        for (int k = 0; props != null && k < props.length; ++k) {
            try {
                InstanceHandler.parseProperty(props[k], prop);
                continue;
            }
            catch (ParseException e) {
                throw new ConfigurationException("An instance configuration is invalid", (Throwable)e);
            }
        }
        Properties instanceConfiguration = new Properties();
        instanceConfiguration.putAll((Map<?, ?>)prop);
        instanceConfiguration.putAll((Map<?, ?>)toAppend);
        String aggregate = service.getAttribute("aggregate");
        boolean agg = aggregate != null && aggregate.equalsIgnoreCase("true");
        String optional = service.getAttribute("optional");
        boolean opt = optional != null && optional.equalsIgnoreCase("true");
        int policy = DependencyModel.getPolicy((Element)service);
        Comparator cmp = DependencyModel.getComparator((Element)service, (BundleContext)this.getCompositeManager().getGlobalContext());
        SvcInstance inst = new SvcInstance(this, spec, instanceConfiguration, agg, opt, fil, cmp, policy);
        this.__getm_instances().add(inst);
        String sources = service.getAttribute("context-source");
        if (sources != null) {
            SourceManager source = new SourceManager(sources, filter, inst, this.getCompositeManager());
            if (this.__getm_sources() == null) {
                this.__setm_sources(new ArrayList(1));
            }
            this.__getm_sources().add(source);
        }
    }

    private void createServiceImport(Element imp, Dictionary confFilter) throws ConfigurationException {
        if (!this.__McreateServiceImport$org_apache_felix_ipojo_metadata_Element$java_util_Dictionary) {
            this.__M_createServiceImport(imp, confFilter);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "createServiceImport$org_apache_felix_ipojo_metadata_Element$java_util_Dictionary", new Object[]{imp, confFilter});
            this.__M_createServiceImport(imp, confFilter);
            this.__IM.onExit((Object)this, "createServiceImport$org_apache_felix_ipojo_metadata_Element$java_util_Dictionary", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "createServiceImport$org_apache_felix_ipojo_metadata_Element$java_util_Dictionary", throwable);
            throw throwable;
        }
    }

    private void __M_createServiceImport(Element imp, Dictionary confFilter) throws ConfigurationException {
        String original;
        boolean optional = false;
        boolean aggregate = false;
        String specification = imp.getAttribute("specification");
        if (specification == null) {
            this.error("Malformed import: the specification attribute is mandatory");
            throw new ConfigurationException("Malformed import : the specification attribute is mandatory");
        }
        String opt = imp.getAttribute("optional");
        optional = opt != null && opt.equalsIgnoreCase("true");
        String agg = imp.getAttribute("aggregate");
        aggregate = agg != null && agg.equalsIgnoreCase("true");
        String filter = original = "(&(objectClass=" + specification + ")(!(instance.name=" + this.getCompositeManager().getInstanceName() + ")))";
        String givenFilter = imp.getAttribute("filter");
        if (givenFilter != null) {
            filter = "(&" + filter + givenFilter + ")";
        }
        String identitity = imp.getAttribute("id");
        String scope = imp.getAttribute("scope");
        BundleContext context = this.getCompositeManager().getGlobalContext();
        if (scope != null) {
            if (scope.equalsIgnoreCase("global")) {
                context = new PolicyServiceContext(this.getCompositeManager().getGlobalContext(), this.getCompositeManager().getParentServiceContext(), 2);
            } else if (scope.equalsIgnoreCase("composite")) {
                context = new PolicyServiceContext(this.getCompositeManager().getGlobalContext(), this.getCompositeManager().getParentServiceContext(), 0);
            } else if (scope.equalsIgnoreCase("composite+global")) {
                context = new PolicyServiceContext(this.getCompositeManager().getGlobalContext(), this.getCompositeManager().getParentServiceContext(), 1);
            }
        }
        if (confFilter != null && identitity != null && confFilter.get(identitity) != null) {
            filter = "(&" + original + (String)confFilter.get(identitity) + ")";
        }
        Filter fil = null;
        if (filter != null) {
            try {
                fil = this.getCompositeManager().getGlobalContext().createFilter(filter);
            }
            catch (InvalidSyntaxException e) {
                throw new ConfigurationException("A required filter " + filter + " is malformed", (Throwable)e);
            }
        }
        Comparator cmp = DependencyModel.getComparator((Element)imp, (BundleContext)this.getCompositeManager().getGlobalContext());
        Class spec = DependencyModel.loadSpecification((String)specification, (BundleContext)this.getCompositeManager().getGlobalContext());
        int policy = DependencyModel.getPolicy((Element)imp);
        ServiceImporter importer = new ServiceImporter(spec, fil, aggregate, optional, cmp, policy, context, identitity, this);
        this.__getm_importers().add(importer);
        String sources = imp.getAttribute("context-source");
        if (sources != null) {
            SourceManager source = new SourceManager(sources, filter, importer, this.getCompositeManager());
            if (this.__getm_sources() == null) {
                this.__setm_sources(new ArrayList(1));
            }
            this.__getm_sources().add(source);
        }
    }

    public void configure(Element metadata, Dictionary conf) throws ConfigurationException {
        if (!this.__Mconfigure$org_apache_felix_ipojo_metadata_Element$java_util_Dictionary) {
            this.__M_configure(metadata, conf);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "configure$org_apache_felix_ipojo_metadata_Element$java_util_Dictionary", new Object[]{metadata, conf});
            this.__M_configure(metadata, conf);
            this.__IM.onExit((Object)this, "configure$org_apache_felix_ipojo_metadata_Element$java_util_Dictionary", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "configure$org_apache_felix_ipojo_metadata_Element$java_util_Dictionary", throwable);
            throw throwable;
        }
    }

    private void __M_configure(Element metadata, Dictionary conf) throws ConfigurationException {
        Element[] services = metadata.getElements("subservice");
        Dictionary confFilter = null;
        if (conf.get("requires.filters") != null) {
            confFilter = (Dictionary)conf.get("requires.filters");
        }
        for (int i = 0; i < services.length; ++i) {
            String action = services[i].getAttribute("action");
            if (action == null) {
                throw new ConfigurationException("The action attribute must be set to 'instantiate' or 'import'");
            }
            if ("instantiate".equalsIgnoreCase(action)) {
                this.createServiceInstance(services[i], conf);
                continue;
            }
            if ("import".equalsIgnoreCase(action)) {
                this.createServiceImport(services[i], confFilter);
                continue;
            }
            throw new ConfigurationException("Unknown action : " + action);
        }
        this.__setm_description(new ServiceInstantiatorDescription(this, this.__getm_instances(), this.__getm_importers()));
    }

    public void start() {
        if (!this.__Mstart) {
            this.__M_start();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "start", new Object[0]);
            this.__M_start();
            this.__IM.onExit((Object)this, "start", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "start", throwable);
            throw throwable;
        }
    }

    private void __M_start() {
        int i;
        for (i = 0; this.__getm_sources() != null && i < this.__getm_sources().size(); ++i) {
            SourceManager source = (SourceManager)this.__getm_sources().get(i);
            source.start();
        }
        for (i = 0; i < this.__getm_importers().size(); ++i) {
            ServiceImporter imp = (ServiceImporter)((Object)this.__getm_importers().get(i));
            imp.start();
        }
        for (i = 0; i < this.__getm_instances().size(); ++i) {
            SvcInstance inst = (SvcInstance)((Object)this.__getm_instances().get(i));
            inst.start();
        }
        this.isHandlerValid();
        this.__setm_isStarted(true);
    }

    private void isHandlerValid() {
        if (!this.__MisHandlerValid) {
            this.__M_isHandlerValid();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "isHandlerValid", new Object[0]);
            this.__M_isHandlerValid();
            this.__IM.onExit((Object)this, "isHandlerValid", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "isHandlerValid", throwable);
            throw throwable;
        }
    }

    private void __M_isHandlerValid() {
        int i;
        for (i = 0; i < this.__getm_importers().size(); ++i) {
            ServiceImporter imp = (ServiceImporter)((Object)this.__getm_importers().get(i));
            if (imp.getState() == 1) continue;
            this.setValidity(false);
            return;
        }
        for (i = 0; i < this.__getm_instances().size(); ++i) {
            SvcInstance inst = (SvcInstance)((Object)this.__getm_instances().get(i));
            if (inst.getState() == 1) continue;
            this.setValidity(false);
            return;
        }
        this.setValidity(true);
    }

    public void stop() {
        if (!this.__Mstop) {
            this.__M_stop();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "stop", new Object[0]);
            this.__M_stop();
            this.__IM.onExit((Object)this, "stop", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "stop", throwable);
            throw throwable;
        }
    }

    private void __M_stop() {
        int i;
        for (i = 0; this.__getm_sources() != null && i < this.__getm_sources().size(); ++i) {
            SourceManager source = (SourceManager)this.__getm_sources().get(i);
            source.stop();
        }
        for (i = 0; i < this.__getm_instances().size(); ++i) {
            SvcInstance inst = (SvcInstance)((Object)this.__getm_instances().get(i));
            inst.stop();
        }
        for (i = 0; i < this.__getm_importers().size(); ++i) {
            ServiceImporter imp = (ServiceImporter)((Object)this.__getm_importers().get(i));
            imp.stop();
        }
        this.__setm_isStarted(false);
    }

    public void stateChanged(int newState) {
        if (!this.__MstateChanged$int) {
            this.__M_stateChanged(newState);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "stateChanged$int", new Object[]{new Integer(newState)});
            this.__M_stateChanged(newState);
            this.__IM.onExit((Object)this, "stateChanged$int", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "stateChanged$int", throwable);
            throw throwable;
        }
    }

    private void __M_stateChanged(int newState) {
        if (this.__getm_isStarted() && newState == 2) {
            DependencyModel imp;
            int i;
            for (i = 0; i < this.__getm_importers().size(); ++i) {
                imp = (ServiceImporter)((Object)this.__getm_importers().get(i));
                if (imp.getBindingPolicy() != 1) continue;
                imp.freeze();
            }
            for (i = 0; i < this.__getm_instances().size(); ++i) {
                imp = (SvcInstance)((Object)this.__getm_instances().get(i));
                if (imp.getBindingPolicy() != 1) continue;
                imp.freeze();
            }
        }
    }

    public void validate(DependencyModel dep) {
        if (!this.__Mvalidate$org_apache_felix_ipojo_util_DependencyModel) {
            this.__M_validate(dep);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "validate$org_apache_felix_ipojo_util_DependencyModel", new Object[]{dep});
            this.__M_validate(dep);
            this.__IM.onExit((Object)this, "validate$org_apache_felix_ipojo_util_DependencyModel", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "validate$org_apache_felix_ipojo_util_DependencyModel", throwable);
            throw throwable;
        }
    }

    private void __M_validate(DependencyModel dep) {
        if (!this.getValidity()) {
            this.isHandlerValid();
        }
    }

    public void invalidate(DependencyModel dep) {
        if (!this.__Minvalidate$org_apache_felix_ipojo_util_DependencyModel) {
            this.__M_invalidate(dep);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "invalidate$org_apache_felix_ipojo_util_DependencyModel", new Object[]{dep});
            this.__M_invalidate(dep);
            this.__IM.onExit((Object)this, "invalidate$org_apache_felix_ipojo_util_DependencyModel", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "invalidate$org_apache_felix_ipojo_util_DependencyModel", throwable);
            throw throwable;
        }
    }

    private void __M_invalidate(DependencyModel dep) {
        if (this.getValidity()) {
            this.isHandlerValid();
        }
    }

    public HandlerDescription getDescription() {
        HandlerDescription handlerDescription;
        if (!this.__MgetDescription) {
            return this.__M_getDescription();
        }
        try {
            this.__IM.onEntry((Object)this, "getDescription", new Object[0]);
            handlerDescription = this.__M_getDescription();
            this.__IM.onExit((Object)this, "getDescription", (Object)handlerDescription);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getDescription", throwable);
            throw throwable;
        }
        return handlerDescription;
    }

    private HandlerDescription __M_getDescription() {
        return this.__getm_description();
    }

    public List getInstances() {
        List list;
        if (!this.__MgetInstances) {
            return this.__M_getInstances();
        }
        try {
            this.__IM.onEntry((Object)this, "getInstances", new Object[0]);
            list = this.__M_getInstances();
            this.__IM.onExit((Object)this, "getInstances", (Object)list);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getInstances", throwable);
            throw throwable;
        }
        return list;
    }

    private List __M_getInstances() {
        return this.__getm_instances();
    }

    public List getRequirements() {
        List list;
        if (!this.__MgetRequirements) {
            return this.__M_getRequirements();
        }
        try {
            this.__IM.onEntry((Object)this, "getRequirements", new Object[0]);
            list = this.__M_getRequirements();
            this.__IM.onExit((Object)this, "getRequirements", (Object)list);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getRequirements", throwable);
            throw throwable;
        }
        return list;
    }

    private List __M_getRequirements() {
        return this.__getm_importers();
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null) {
            if (set.contains("m_description")) {
                this.__Fm_description = true;
            }
            if (set.contains("m_importers")) {
                this.__Fm_importers = true;
            }
            if (set.contains("m_instances")) {
                this.__Fm_instances = true;
            }
            if (set.contains("m_isStarted")) {
                this.__Fm_isStarted = true;
            }
            if (set.contains("m_sources")) {
                this.__Fm_sources = true;
            }
        }
        if ((set = this.__IM.getRegistredMethods()) != null) {
            if (set.contains("createServiceInstance$org_apache_felix_ipojo_metadata_Element$java_util_Dictionary")) {
                this.__McreateServiceInstance$org_apache_felix_ipojo_metadata_Element$java_util_Dictionary = true;
            }
            if (set.contains("createServiceImport$org_apache_felix_ipojo_metadata_Element$java_util_Dictionary")) {
                this.__McreateServiceImport$org_apache_felix_ipojo_metadata_Element$java_util_Dictionary = true;
            }
            if (set.contains("configure$org_apache_felix_ipojo_metadata_Element$java_util_Dictionary")) {
                this.__Mconfigure$org_apache_felix_ipojo_metadata_Element$java_util_Dictionary = true;
            }
            if (set.contains("start")) {
                this.__Mstart = true;
            }
            if (set.contains("isHandlerValid")) {
                this.__MisHandlerValid = true;
            }
            if (set.contains("stop")) {
                this.__Mstop = true;
            }
            if (set.contains("stateChanged$int")) {
                this.__MstateChanged$int = true;
            }
            if (set.contains("validate$org_apache_felix_ipojo_util_DependencyModel")) {
                this.__Mvalidate$org_apache_felix_ipojo_util_DependencyModel = true;
            }
            if (set.contains("invalidate$org_apache_felix_ipojo_util_DependencyModel")) {
                this.__Minvalidate$org_apache_felix_ipojo_util_DependencyModel = true;
            }
            if (set.contains("getDescription")) {
                this.__MgetDescription = true;
            }
            if (set.contains("getInstances")) {
                this.__MgetInstances = true;
            }
            if (set.contains("getRequirements")) {
                this.__MgetRequirements = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }
}

