/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.manipulation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.felix.ipojo.manipulation.MethodDescriptor;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.EmptyVisitor;

public class ClassChecker
extends EmptyVisitor
implements ClassVisitor,
Opcodes {
    private boolean m_isAlreadyManipulated = false;
    private List m_itfs = new ArrayList();
    private Map m_fields = new HashMap();
    private List m_methods = new ArrayList();
    private String m_superClass;
    private String m_className;
    private List m_inners = new ArrayList();
    private boolean m_supportAnnotation = false;

    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        if (access == 2 && name.equals("__IM") && desc.equals("Lorg/apache/felix/ipojo/InstanceManager;")) {
            this.m_isAlreadyManipulated = true;
        } else {
            if (name.startsWith("class$")) {
                return null;
            }
            if ((access & 8) == 8) {
                return null;
            }
        }
        Type type = Type.getType(desc);
        if (type.getSort() == 9) {
            if (type.getInternalName().startsWith("L")) {
                String internalType = type.getInternalName().substring(1);
                String nameType = internalType.replace('/', '.');
                this.m_fields.put(name, nameType + "[]");
            } else {
                String nameType = type.getClassName().substring(0, type.getClassName().length() - 2);
                this.m_fields.put(name, nameType + "[]");
            }
        } else {
            this.m_fields.put(name, type.getClassName());
        }
        return null;
    }

    public void visitInnerClass(String name, String outerName, String innerName, int access) {
        if (this.m_className.equals(outerName) || outerName == null) {
            this.m_inners.add(name);
        }
    }

    public boolean isalreadyManipulated() {
        return this.m_isAlreadyManipulated;
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        boolean bl = this.m_supportAnnotation = version > 48 && version < 196653;
        if (!superName.equals("java/lang/Object")) {
            this.m_superClass = superName.replace('/', '.');
        }
        for (int i = 0; i < interfaces.length; ++i) {
            if (interfaces[i].equals("org/apache/felix/ipojo/Pojo")) continue;
            this.m_itfs.add(interfaces[i].replace('/', '.'));
        }
        this.m_className = name;
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        if (!name.equals("<clinit>")) {
            if (name.equals("<init>")) {
                MethodDescriptor md = new MethodDescriptor("$init", desc);
                this.m_methods.add(md);
                if (this.m_supportAnnotation) {
                    return new AnnotationCollector(md);
                }
            } else if (!(name.startsWith("_get") || name.startsWith("_set") || name.equals("_setComponentManager") || name.equals("getComponentInstance"))) {
                MethodDescriptor md = new MethodDescriptor(name, desc);
                this.m_methods.add(md);
                if (this.m_supportAnnotation) {
                    return new AnnotationCollector(md);
                }
            }
        }
        return null;
    }

    public List getInterfaces() {
        return this.m_itfs;
    }

    public Map getFields() {
        return this.m_fields;
    }

    public List getMethods() {
        return this.m_methods;
    }

    public String getSuperClass() {
        return this.m_superClass;
    }

    public List getInnerClasses() {
        return this.m_inners;
    }

    public final class EnumAttribute {
        private String m_name;
        private String m_desc;
        private String m_value;

        private EnumAttribute(String name, String desc, String value) {
            this.m_name = name;
            this.m_value = value;
            this.m_desc = desc;
        }

        public void visit(AnnotationVisitor visitor) {
            visitor.visitEnum(this.m_name, this.m_desc, this.m_value);
        }
    }

    public final class SimpleAttribute {
        private String m_name;
        private Object m_value;

        private SimpleAttribute(String name, Object object) {
            this.m_name = name;
            this.m_value = object;
        }

        public void visit(AnnotationVisitor visitor) {
            visitor.visit(this.m_name, this.m_value);
        }
    }

    public class ArrayAttribute
    implements AnnotationVisitor {
        private String m_name;
        private List m_content = new ArrayList();

        public ArrayAttribute(String name) {
            this.m_name = name;
        }

        public void visit(String arg0, Object arg1) {
            this.m_content.add(arg1);
        }

        public AnnotationVisitor visitAnnotation(String arg0, String arg1) {
            AnnotationDescriptor ad = new AnnotationDescriptor(null, arg1);
            this.m_content.add(ad);
            return ad;
        }

        public AnnotationVisitor visitArray(String arg0) {
            ArrayAttribute aa = new ArrayAttribute(null);
            this.m_content.add(aa);
            return aa;
        }

        public void visitEnd() {
        }

        public void visitEnum(String arg0, String arg1, String arg2) {
            EnumAttribute ea = new EnumAttribute(null, arg1, arg2);
            this.m_content.add(ea);
        }

        public void visit(AnnotationVisitor av) {
            AnnotationVisitor content = av.visitArray(this.m_name);
            for (int i = 0; i < this.m_content.size(); ++i) {
                Object component = this.m_content.get(i);
                if (component instanceof AnnotationDescriptor) {
                    ((AnnotationDescriptor)component).visit(content);
                    continue;
                }
                if (component instanceof EnumAttribute) {
                    ((EnumAttribute)component).visit(content);
                    continue;
                }
                if (component instanceof ArrayAttribute) {
                    ((ArrayAttribute)component).visit(content);
                    continue;
                }
                content.visit(null, component);
            }
            content.visitEnd();
        }
    }

    public class AnnotationDescriptor
    implements AnnotationVisitor {
        private String m_name;
        private boolean m_visible;
        private String m_desc;
        private List m_simples = new ArrayList(0);
        private List m_enums = new ArrayList(0);
        private List m_nested = new ArrayList(0);
        private List m_arrays = new ArrayList(0);

        public AnnotationDescriptor(String name, boolean visible) {
            this.m_name = name;
            this.m_visible = visible;
        }

        public AnnotationDescriptor(String name, String desc) {
            this.m_name = name;
            this.m_visible = true;
            this.m_desc = desc;
        }

        public void visit(String arg0, Object arg1) {
            this.m_simples.add(new SimpleAttribute(arg0, arg1));
        }

        public AnnotationVisitor visitAnnotation(String arg0, String arg1) {
            AnnotationDescriptor ad = new AnnotationDescriptor(arg0, arg1);
            this.m_nested.add(ad);
            return ad;
        }

        public AnnotationVisitor visitArray(String arg0) {
            ArrayAttribute aa = new ArrayAttribute(arg0);
            this.m_arrays.add(aa);
            return aa;
        }

        public void visitEnd() {
        }

        public void visitEnum(String arg0, String arg1, String arg2) {
            this.m_enums.add(new EnumAttribute(arg0, arg1, arg2));
        }

        public void visit(MethodVisitor mv) {
            int i;
            AnnotationVisitor av = mv.visitAnnotation(this.m_name, this.m_visible);
            for (i = 0; i < this.m_simples.size(); ++i) {
                ((SimpleAttribute)this.m_simples.get(i)).visit(av);
            }
            for (i = 0; i < this.m_enums.size(); ++i) {
                ((EnumAttribute)this.m_enums.get(i)).visit(av);
            }
            for (i = 0; i < this.m_nested.size(); ++i) {
                ((AnnotationDescriptor)this.m_nested.get(i)).visit(av);
            }
            for (i = 0; i < this.m_arrays.size(); ++i) {
                ((ArrayAttribute)this.m_arrays.get(i)).visit(av);
            }
            av.visitEnd();
        }

        public void visit(AnnotationVisitor mv) {
            int i;
            AnnotationVisitor av = mv.visitAnnotation(this.m_name, this.m_desc);
            for (i = 0; i < this.m_simples.size(); ++i) {
                ((SimpleAttribute)this.m_simples.get(i)).visit(av);
            }
            for (i = 0; i < this.m_enums.size(); ++i) {
                ((EnumAttribute)this.m_enums.get(i)).visit(av);
            }
            for (i = 0; i < this.m_nested.size(); ++i) {
                ((AnnotationDescriptor)this.m_nested.get(i)).visit(av);
            }
            for (i = 0; i < this.m_arrays.size(); ++i) {
                ((ArrayAttribute)this.m_arrays.get(i)).visit(av);
            }
            av.visitEnd();
        }
    }

    private final class AnnotationCollector
    extends EmptyVisitor {
        private MethodDescriptor m_method;

        private AnnotationCollector(MethodDescriptor md) {
            this.m_method = md;
        }

        public AnnotationVisitor visitAnnotation(String name, boolean visible) {
            if (visible) {
                AnnotationDescriptor ann = new AnnotationDescriptor(name, visible);
                this.m_method.addAnnotation(ann);
                return ann;
            }
            return null;
        }
    }
}

