/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.composite.service.provides;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Dictionary;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.ConfigurationException;
import org.apache.felix.ipojo.Factory;
import org.apache.felix.ipojo.HandlerManager;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.MissingHandlerException;
import org.apache.felix.ipojo.Pojo;
import org.apache.felix.ipojo.PolicyServiceContext;
import org.apache.felix.ipojo.UnacceptableConfiguration;
import org.apache.felix.ipojo.architecture.ComponentTypeDescription;
import org.apache.felix.ipojo.architecture.HandlerDescription;
import org.apache.felix.ipojo.composite.CompositeHandler;
import org.apache.felix.ipojo.composite.instance.InstanceHandler;
import org.apache.felix.ipojo.composite.service.instantiator.ServiceDependencyHandler;
import org.apache.felix.ipojo.composite.service.instantiator.ServiceImporter;
import org.apache.felix.ipojo.composite.service.instantiator.SvcInstance;
import org.apache.felix.ipojo.composite.service.provides.CompositionException;
import org.apache.felix.ipojo.composite.service.provides.ProvidedService;
import org.apache.felix.ipojo.composite.service.provides.ProvidedServiceHandlerDescription;
import org.apache.felix.ipojo.composite.service.provides.ServiceExporter;
import org.apache.felix.ipojo.composite.service.provides.SpecificationMetadata;
import org.apache.felix.ipojo.metadata.Element;
import org.apache.felix.ipojo.parser.ManifestMetadataParser;
import org.apache.felix.ipojo.parser.ParseException;
import org.apache.felix.ipojo.util.DependencyModel;
import org.apache.felix.ipojo.util.DependencyStateListener;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public class ProvidedServiceHandler
extends CompositeHandler
implements DependencyStateListener,
Pojo {
    private InstanceManager __IM;
    private boolean __Fm_context;
    private BundleContext m_context;
    private boolean __Fm_services;
    private List m_services;
    private boolean __Fm_exporters;
    private List m_exporters;
    private boolean __Fm_managedServices;
    private List m_managedServices;
    private boolean __Fm_types;
    private List m_types;
    static /* synthetic */ Class class$org$apache$felix$ipojo$Factory;
    private boolean __MinitializeComponentFactory$org_apache_felix_ipojo_architecture_ComponentTypeDescription$org_apache_felix_ipojo_metadata_Element;
    private boolean __Mconfigure$org_apache_felix_ipojo_metadata_Element$java_util_Dictionary;
    private boolean __Mstart;
    private boolean __Mstop;
    private boolean __MisHandlerValid;
    private boolean __MstateChanged$int;
    private boolean __Minvalidate$org_apache_felix_ipojo_util_DependencyModel;
    private boolean __Mvalidate$org_apache_felix_ipojo_util_DependencyModel;
    private boolean __MgetSpecifications;
    private boolean __McomputeAvailableServices;
    private boolean __McheckServiceSpecification$org_apache_felix_ipojo_composite_service_provides_ProvidedService;
    private boolean __MgetAttachedRequirement$org_apache_felix_ipojo_metadata_Element;
    private boolean __McheckRequirement$org_apache_felix_ipojo_composite_service_instantiator_ServiceImporter$org_apache_felix_ipojo_metadata_Element;
    private boolean __MgetDescription;
    private boolean __McomputeAvailableTypes;
    private boolean __MgetInstanceType;

    private BundleContext __getm_context() {
        if (!this.__Fm_context) {
            return this.m_context;
        }
        return (BundleContext)this.__IM.onGet((Object)this, "m_context");
    }

    private void __setm_context(BundleContext bundleContext) {
        if (!this.__Fm_context) {
            this.m_context = bundleContext;
            return;
        }
        this.__IM.onSet((Object)this, "m_context", (Object)bundleContext);
    }

    private List __getm_services() {
        if (!this.__Fm_services) {
            return this.m_services;
        }
        return (List)this.__IM.onGet((Object)this, "m_services");
    }

    private void __setm_services(List list) {
        if (!this.__Fm_services) {
            this.m_services = list;
            return;
        }
        this.__IM.onSet((Object)this, "m_services", (Object)list);
    }

    private List __getm_exporters() {
        if (!this.__Fm_exporters) {
            return this.m_exporters;
        }
        return (List)this.__IM.onGet((Object)this, "m_exporters");
    }

    private void __setm_exporters(List list) {
        if (!this.__Fm_exporters) {
            this.m_exporters = list;
            return;
        }
        this.__IM.onSet((Object)this, "m_exporters", (Object)list);
    }

    private List __getm_managedServices() {
        if (!this.__Fm_managedServices) {
            return this.m_managedServices;
        }
        return (List)this.__IM.onGet((Object)this, "m_managedServices");
    }

    private void __setm_managedServices(List list) {
        if (!this.__Fm_managedServices) {
            this.m_managedServices = list;
            return;
        }
        this.__IM.onSet((Object)this, "m_managedServices", (Object)list);
    }

    private List __getm_types() {
        if (!this.__Fm_types) {
            return this.m_types;
        }
        return (List)this.__IM.onGet((Object)this, "m_types");
    }

    private void __setm_types(List list) {
        if (!this.__Fm_types) {
            this.m_types = list;
            return;
        }
        this.__IM.onSet((Object)this, "m_types", (Object)list);
    }

    public ProvidedServiceHandler() {
        this(null);
    }

    private ProvidedServiceHandler(InstanceManager _manager) {
        this._setInstanceManager(_manager);
        this.__setm_services(new ArrayList());
        this.__setm_exporters(new ArrayList());
        this.__setm_managedServices(new ArrayList());
    }

    public void initializeComponentFactory(ComponentTypeDescription componentTypeDescription, Element element) throws ConfigurationException {
        if (!this.__MinitializeComponentFactory$org_apache_felix_ipojo_architecture_ComponentTypeDescription$org_apache_felix_ipojo_metadata_Element) {
            this.__initializeComponentFactory(componentTypeDescription, element);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "initializeComponentFactory$org_apache_felix_ipojo_architecture_ComponentTypeDescription$org_apache_felix_ipojo_metadata_Element", new Object[]{componentTypeDescription, element});
            this.__initializeComponentFactory(componentTypeDescription, element);
            this.__IM.onExit((Object)this, "initializeComponentFactory$org_apache_felix_ipojo_architecture_ComponentTypeDescription$org_apache_felix_ipojo_metadata_Element", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "initializeComponentFactory$org_apache_felix_ipojo_architecture_ComponentTypeDescription$org_apache_felix_ipojo_metadata_Element", throwable);
            throw throwable;
        }
    }

    private void __initializeComponentFactory(ComponentTypeDescription desc, Element metadata) throws ConfigurationException {
        Element[] provides = metadata.getElements("provides");
        for (int i = 0; i < provides.length; ++i) {
            String spec;
            String action = provides[i].getAttribute("action");
            if (action == null) {
                throw new ConfigurationException("Invalid composition service providing : no specified action");
            }
            if (action.equalsIgnoreCase("implement")) {
                spec = provides[i].getAttribute("specification");
                if (spec == null) {
                    throw new ConfigurationException("Malformed provides : the specification attribute is mandatory");
                }
                desc.addProvidedServiceSpecification(spec);
                continue;
            }
            if (action.equalsIgnoreCase("export")) {
                spec = provides[i].getAttribute("specification");
                if (spec == null) {
                    throw new ConfigurationException("Malformed exports - Missing the specification attribute");
                }
                desc.addProvidedServiceSpecification(spec);
                continue;
            }
            throw new ConfigurationException("Invalid composition service providing : unknown action " + action);
        }
    }

    public void configure(Element element, Dictionary dictionary) throws ConfigurationException {
        if (!this.__Mconfigure$org_apache_felix_ipojo_metadata_Element$java_util_Dictionary) {
            this.__configure(element, dictionary);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "configure$org_apache_felix_ipojo_metadata_Element$java_util_Dictionary", new Object[]{element, dictionary});
            this.__configure(element, dictionary);
            this.__IM.onExit((Object)this, "configure$org_apache_felix_ipojo_metadata_Element$java_util_Dictionary", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "configure$org_apache_felix_ipojo_metadata_Element$java_util_Dictionary", throwable);
            throw throwable;
        }
    }

    private void __configure(Element metadata, Dictionary configuration) throws ConfigurationException {
        this.__setm_context(this.getCompositeManager().getContext());
        Element[] provides = metadata.getElements("provides", "");
        for (int i = 0; i < provides.length; ++i) {
            String action = provides[i].getAttribute("action");
            if (action.equalsIgnoreCase("implement")) {
                ProvidedService svc = new ProvidedService(this, provides[i], Integer.toString(i));
                this.__getm_managedServices().add(svc);
                continue;
            }
            if (!action.equalsIgnoreCase("export")) continue;
            boolean optional = false;
            boolean aggregate = false;
            String specification = provides[i].getAttribute("specification");
            String filter = "(objectClass=" + specification + ")";
            String opt = provides[i].getAttribute("optional");
            optional = opt != null && opt.equalsIgnoreCase("true");
            String agg = provides[i].getAttribute("aggregate");
            aggregate = agg != null && agg.equalsIgnoreCase("true");
            String givenFilter = provides[i].getAttribute("filter");
            if (givenFilter != null) {
                filter = "(&" + filter + givenFilter + ")";
            }
            Filter fil = null;
            try {
                fil = this.__getm_context().createFilter(filter);
            }
            catch (InvalidSyntaxException e) {
                throw new ConfigurationException("An exporter filter is invalid " + filter + " : " + e.getMessage());
            }
            Comparator cmp = DependencyModel.getComparator((Element)provides[i], (BundleContext)this.__getm_context());
            int policy = DependencyModel.getPolicy((Element)provides[i]);
            Class spec = DependencyModel.loadSpecification((String)specification, (BundleContext)this.__getm_context());
            ServiceExporter imp = new ServiceExporter(spec, fil, aggregate, optional, cmp, policy, this.getCompositeManager().getServiceContext(), this.__getm_context(), this, this.getCompositeManager());
            this.__getm_exporters().add(imp);
        }
    }

    public void start() {
        if (!this.__Mstart) {
            this.__start();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "start", new Object[0]);
            this.__start();
            this.__IM.onExit((Object)this, "start", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "start", throwable);
            throw throwable;
        }
    }

    private void __start() {
        int i;
        this.computeAvailableServices();
        this.computeAvailableTypes();
        for (i = 0; i < this.__getm_managedServices().size(); ++i) {
            ProvidedService svc = (ProvidedService)this.__getm_managedServices().get(i);
            try {
                this.checkServiceSpecification(svc);
                svc.start();
                continue;
            }
            catch (CompositionException e) {
                this.error("Cannot start the provided service handler", e);
                this.setValidity(false);
                return;
            }
        }
        for (i = 0; i < this.__getm_exporters().size(); ++i) {
            ServiceExporter exp = (ServiceExporter)((Object)this.__getm_exporters().get(i));
            exp.start();
        }
        this.isHandlerValid();
    }

    public void stop() {
        if (!this.__Mstop) {
            this.__stop();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "stop", new Object[0]);
            this.__stop();
            this.__IM.onExit((Object)this, "stop", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "stop", throwable);
            throw throwable;
        }
    }

    private void __stop() {
        int i;
        for (i = 0; i < this.__getm_managedServices().size(); ++i) {
            ProvidedService svc = (ProvidedService)this.__getm_managedServices().get(i);
            svc.stop();
        }
        for (i = 0; i < this.__getm_exporters().size(); ++i) {
            ServiceExporter exp = (ServiceExporter)((Object)this.__getm_exporters().get(i));
            exp.stop();
        }
    }

    private void isHandlerValid() {
        if (!this.__MisHandlerValid) {
            this.__isHandlerValid();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "isHandlerValid", new Object[0]);
            this.__isHandlerValid();
            this.__IM.onExit((Object)this, "isHandlerValid", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "isHandlerValid", throwable);
            throw throwable;
        }
    }

    private void __isHandlerValid() {
        for (int i = 0; i < this.__getm_exporters().size(); ++i) {
            ServiceExporter exp = (ServiceExporter)((Object)this.__getm_exporters().get(i));
            if (exp.getState() == 1) continue;
            this.setValidity(false);
            return;
        }
        this.setValidity(true);
    }

    public void stateChanged(int n) {
        if (!this.__MstateChanged$int) {
            this.__stateChanged(n);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "stateChanged$int", new Object[]{new Integer(n)});
            this.__stateChanged(n);
            this.__IM.onExit((Object)this, "stateChanged$int", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "stateChanged$int", throwable);
            throw throwable;
        }
    }

    private void __stateChanged(int state) {
        if (state == 1) {
            for (int i = 0; i < this.__getm_managedServices().size(); ++i) {
                ProvidedService svc = (ProvidedService)this.__getm_managedServices().get(i);
                svc.unregister();
            }
            return;
        }
        if (state == 2) {
            for (int i = 0; i < this.__getm_managedServices().size(); ++i) {
                ProvidedService svc = (ProvidedService)this.__getm_managedServices().get(i);
                svc.register();
            }
            return;
        }
    }

    public void invalidate(DependencyModel dependencyModel) {
        if (!this.__Minvalidate$org_apache_felix_ipojo_util_DependencyModel) {
            this.__invalidate(dependencyModel);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "invalidate$org_apache_felix_ipojo_util_DependencyModel", new Object[]{dependencyModel});
            this.__invalidate(dependencyModel);
            this.__IM.onExit((Object)this, "invalidate$org_apache_felix_ipojo_util_DependencyModel", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "invalidate$org_apache_felix_ipojo_util_DependencyModel", throwable);
            throw throwable;
        }
    }

    private void __invalidate(DependencyModel exporter) {
        if (this.getValidity()) {
            this.setValidity(false);
        }
    }

    public void validate(DependencyModel dependencyModel) {
        if (!this.__Mvalidate$org_apache_felix_ipojo_util_DependencyModel) {
            this.__validate(dependencyModel);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "validate$org_apache_felix_ipojo_util_DependencyModel", new Object[]{dependencyModel});
            this.__validate(dependencyModel);
            this.__IM.onExit((Object)this, "validate$org_apache_felix_ipojo_util_DependencyModel", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "validate$org_apache_felix_ipojo_util_DependencyModel", throwable);
            throw throwable;
        }
    }

    private void __validate(DependencyModel exporter) {
        if (!this.getValidity()) {
            this.isHandlerValid();
        }
    }

    protected List getSpecifications() {
        List list;
        if (!this.__MgetSpecifications) {
            return this.__getSpecifications();
        }
        try {
            this.__IM.onEntry((Object)this, "getSpecifications", new Object[0]);
            list = this.__getSpecifications();
            this.__IM.onExit((Object)this, "getSpecifications", (Object)list);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getSpecifications", throwable);
            throw throwable;
        }
        return list;
    }

    private List __getSpecifications() {
        return this.__getm_services();
    }

    private void computeAvailableServices() {
        if (!this.__McomputeAvailableServices) {
            this.__computeAvailableServices();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "computeAvailableServices", new Object[0]);
            this.__computeAvailableServices();
            this.__IM.onExit((Object)this, "computeAvailableServices", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "computeAvailableServices", throwable);
            throw throwable;
        }
    }

    private void __computeAvailableServices() {
        SpecificationMetadata specMeta;
        boolean opt;
        boolean agg;
        String itf;
        int i;
        ServiceDependencyHandler handler = (ServiceDependencyHandler)this.getHandler("org.apache.felix.ipojo:subservice");
        for (i = 0; handler != null && i < handler.getInstances().size(); ++i) {
            SvcInstance svc = (SvcInstance)((Object)handler.getInstances().get(i));
            itf = svc.getServiceSpecification();
            agg = svc.isAggregate();
            opt = svc.isOptional();
            specMeta = new SpecificationMetadata(itf, this.__getm_context(), agg, opt, this);
            this.__getm_services().add(specMeta);
        }
        for (i = 0; handler != null && i < handler.getRequirements().size(); ++i) {
            ServiceImporter imp = (ServiceImporter)((Object)handler.getRequirements().get(i));
            itf = imp.getSpecification().getName();
            agg = imp.isAggregate();
            opt = imp.isOptional();
            specMeta = new SpecificationMetadata(itf, this.__getm_context(), agg, opt, this);
            this.__getm_services().add(specMeta);
        }
    }

    private void checkServiceSpecification(ProvidedService providedService) throws CompositionException {
        if (!this.__McheckServiceSpecification$org_apache_felix_ipojo_composite_service_provides_ProvidedService) {
            this.__checkServiceSpecification(providedService);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "checkServiceSpecification$org_apache_felix_ipojo_composite_service_provides_ProvidedService", new Object[]{providedService});
            this.__checkServiceSpecification(providedService);
            this.__IM.onExit((Object)this, "checkServiceSpecification$org_apache_felix_ipojo_composite_service_provides_ProvidedService", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "checkServiceSpecification$org_apache_felix_ipojo_composite_service_provides_ProvidedService", throwable);
            throw throwable;
        }
    }

    private void __checkServiceSpecification(ProvidedService svc) throws CompositionException {
        block9: {
            try {
                Class spec = this.__getm_context().getBundle().loadClass(svc.getSpecification());
                Field specField = spec.getField("specification");
                Object object = specField.get(null);
                if (object instanceof String) {
                    Element specification = ManifestMetadataParser.parse((String)((String)object));
                    Element[] reqs = specification.getElements("requires");
                    for (int j = 0; reqs != null && j < reqs.length; ++j) {
                        ServiceImporter imp = this.getAttachedRequirement(reqs[j]);
                        if (imp != null) {
                            imp.setServiceLevelDependency();
                        }
                        this.checkRequirement(imp, reqs[j]);
                    }
                    break block9;
                }
                this.error("[" + this.getCompositeManager().getInstanceName() + "] The specification field of the service specification " + svc.getSpecification() + " need to be a String");
                throw new CompositionException("Service Specification checking failed : The specification field of the service specification " + svc.getSpecification() + " need to be a String");
            }
            catch (NoSuchFieldException e) {
                return;
            }
            catch (ClassNotFoundException e) {
                this.error("[" + this.getCompositeManager().getInstanceName() + "] The service specification " + svc.getSpecification() + " cannot be load");
                throw new CompositionException("The service specification " + svc.getSpecification() + " cannot be load : " + e.getMessage());
            }
            catch (IllegalArgumentException e) {
                this.error("[" + this.getCompositeManager().getInstanceName() + "] The field 'specification' of the service specification " + svc.getSpecification() + " is not accessible : " + e.getMessage());
                throw new CompositionException("The field 'specification' of the service specification " + svc.getSpecification() + " is not accessible : " + e.getMessage());
            }
            catch (IllegalAccessException e) {
                this.error("[" + this.getCompositeManager().getInstanceName() + "] The field 'specification' of the service specification " + svc.getSpecification() + " is not accessible : " + e.getMessage());
                throw new CompositionException("The field 'specification' of the service specification " + svc.getSpecification() + " is not accessible : " + e.getMessage());
            }
            catch (ParseException e) {
                this.error("[" + this.getCompositeManager().getInstanceName() + "] The field 'specification' of the service specification " + svc.getSpecification() + " does not contain a valid String : " + e.getMessage());
                throw new CompositionException("The field 'specification' of the service specification " + svc.getSpecification() + " does not contain a valid String : " + e.getMessage());
            }
        }
    }

    private ServiceImporter getAttachedRequirement(Element element) {
        ServiceImporter serviceImporter;
        if (!this.__MgetAttachedRequirement$org_apache_felix_ipojo_metadata_Element) {
            return this.__getAttachedRequirement(element);
        }
        try {
            this.__IM.onEntry((Object)this, "getAttachedRequirement$org_apache_felix_ipojo_metadata_Element", new Object[]{element});
            serviceImporter = this.__getAttachedRequirement(element);
            this.__IM.onExit((Object)this, "getAttachedRequirement$org_apache_felix_ipojo_metadata_Element", (Object)serviceImporter);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getAttachedRequirement$org_apache_felix_ipojo_metadata_Element", throwable);
            throw throwable;
        }
        return serviceImporter;
    }

    private ServiceImporter __getAttachedRequirement(Element element) {
        ServiceDependencyHandler handler = (ServiceDependencyHandler)this.getHandler("org.apache.felix.ipojo:subservice");
        if (handler == null) {
            return null;
        }
        String identity = element.getAttribute("id");
        if (identity != null) {
            for (int i = 0; i < handler.getRequirements().size(); ++i) {
                ServiceImporter imp = (ServiceImporter)((Object)handler.getRequirements().get(i));
                if (!imp.getId().equals(identity)) continue;
                return imp;
            }
        }
        String requirement = element.getAttribute("specification");
        for (int i = 0; i < handler.getRequirements().size(); ++i) {
            ServiceImporter imp = (ServiceImporter)((Object)handler.getRequirements().get(i));
            if (!imp.getId().equals(requirement) && !imp.getSpecification().getName().equals(requirement)) continue;
            return imp;
        }
        return null;
    }

    private void checkRequirement(ServiceImporter serviceImporter, Element element) throws CompositionException {
        if (!this.__McheckRequirement$org_apache_felix_ipojo_composite_service_instantiator_ServiceImporter$org_apache_felix_ipojo_metadata_Element) {
            this.__checkRequirement(serviceImporter, element);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "checkRequirement$org_apache_felix_ipojo_composite_service_instantiator_ServiceImporter$org_apache_felix_ipojo_metadata_Element", new Object[]{serviceImporter, element});
            this.__checkRequirement(serviceImporter, element);
            this.__IM.onExit((Object)this, "checkRequirement$org_apache_felix_ipojo_composite_service_instantiator_ServiceImporter$org_apache_felix_ipojo_metadata_Element", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "checkRequirement$org_apache_felix_ipojo_composite_service_instantiator_ServiceImporter$org_apache_felix_ipojo_metadata_Element", throwable);
            throw throwable;
        }
    }

    private void __checkRequirement(ServiceImporter imp, Element elem) throws CompositionException {
        String filter2;
        boolean agg;
        String optional = elem.getAttribute("optional");
        boolean opt = optional != null && optional.equalsIgnoreCase("true");
        String aggregate = elem.getAttribute("aggregate");
        boolean bl = agg = aggregate != null && aggregate.equalsIgnoreCase("true");
        if (imp == null) {
            ServiceDependencyHandler handler = (ServiceDependencyHandler)this.getHandler("org.apache.felix.ipojo:subservice");
            if (handler == null) {
                HandlerManager handlerManager = null;
                try {
                    ServiceReference[] refs = this.__getm_context().getServiceReferences((class$org$apache$felix$ipojo$Factory == null ? (class$org$apache$felix$ipojo$Factory = ProvidedServiceHandler.class$("org.apache.felix.ipojo.Factory")) : class$org$apache$felix$ipojo$Factory).getName(), "(&(handler.name=subservice)(handler.namespace=org.apache.felix.ipojo)(handler.type=composite))");
                    Factory factory = (Factory)this.__getm_context().getService(refs[0]);
                    handlerManager = (HandlerManager)factory.createComponentInstance(null, this.getCompositeManager().getServiceContext());
                }
                catch (InvalidSyntaxException e) {
                }
                catch (UnacceptableConfiguration e) {
                }
                catch (MissingHandlerException e) {
                }
                catch (ConfigurationException e) {
                    // empty catch block
                }
                try {
                    handlerManager.init((ComponentInstance)this.getCompositeManager(), new Element("composite", ""), (Dictionary)new Properties());
                }
                catch (ConfigurationException e) {
                    this.error("Internal error : cannot configure the Import Handler : " + e.getMessage());
                    throw new CompositionException("Internal error : cannot configure the Import Handler : " + e.getMessage());
                }
                handler = (ServiceDependencyHandler)handlerManager.getHandler();
                this.getCompositeManager().addCompositeHandler(handlerManager);
            }
            String spec = elem.getAttribute("specification");
            String filter = "(&(objectClass=" + spec + ")(!(instance.name=" + this.getCompositeManager().getInstanceName() + ")))";
            String givenFilter = elem.getAttribute("filter");
            if (givenFilter != null) {
                filter = "(&" + filter + givenFilter + ")";
            }
            PolicyServiceContext context = new PolicyServiceContext(this.getCompositeManager().getGlobalContext(), this.getCompositeManager().getParentServiceContext(), 2);
            Filter fil = null;
            try {
                fil = this.getCompositeManager().getGlobalContext().createFilter(filter);
            }
            catch (InvalidSyntaxException e) {
                throw new CompositionException("A required filter " + filter + " is malformed : " + e.getMessage());
            }
            Class specToImport = null;
            try {
                specToImport = this.getCompositeManager().getGlobalContext().getBundle().loadClass(spec);
            }
            catch (ClassNotFoundException e) {
                throw new CompositionException("A required specification cannot be loaded : " + spec);
            }
            ServiceImporter importer = new ServiceImporter(specToImport, fil, agg, opt, null, 0, (BundleContext)context, null, handler);
            handler.getRequirements().add(importer);
            SpecificationMetadata specMeta = new SpecificationMetadata(spec, this.__getm_context(), agg, opt, this);
            this.__getm_services().add(specMeta);
            return;
        }
        if (imp.isAggregate() && !agg) {
            this.error("[" + this.getCompositeManager().getInstanceName() + "] The requirement " + elem.getAttribute("specification") + " is aggregate in the implementation and is declared as a simple service-level requirement");
            throw new CompositionException("The requirement " + elem.getAttribute("specification") + " is aggregate in the implementation and is declared as a simple service-level requirement");
        }
        String filter = elem.getAttribute("filter");
        if (!(filter == null || (filter2 = imp.getFilter()) != null && filter2.equalsIgnoreCase(filter))) {
            this.error("[" + this.getCompositeManager().getInstanceName() + "] The specification requirement " + elem.getAttribute("specification") + " as not the same filter as declared in the service-level requirement");
            throw new CompositionException("The specification requirement " + elem.getAttribute("specification") + " as not the same filter as declared in the service-level requirement");
        }
    }

    public HandlerDescription getDescription() {
        HandlerDescription handlerDescription;
        if (!this.__MgetDescription) {
            return this.__getDescription();
        }
        try {
            this.__IM.onEntry((Object)this, "getDescription", new Object[0]);
            handlerDescription = this.__getDescription();
            this.__IM.onExit((Object)this, "getDescription", (Object)handlerDescription);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getDescription", throwable);
            throw throwable;
        }
        return handlerDescription;
    }

    private HandlerDescription __getDescription() {
        return new ProvidedServiceHandlerDescription(this, this.__getm_managedServices(), this.__getm_exporters());
    }

    private void computeAvailableTypes() {
        if (!this.__McomputeAvailableTypes) {
            this.__computeAvailableTypes();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "computeAvailableTypes", new Object[0]);
            this.__computeAvailableTypes();
            this.__IM.onExit((Object)this, "computeAvailableTypes", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "computeAvailableTypes", throwable);
            throw throwable;
        }
    }

    private void __computeAvailableTypes() {
        InstanceHandler handler = (InstanceHandler)this.getHandler("org.apache.felix.ipojo:instance");
        if (handler == null) {
            this.__setm_types(new ArrayList());
        } else {
            this.__setm_types(handler.getUsedType());
        }
    }

    public List getInstanceType() {
        List list;
        if (!this.__MgetInstanceType) {
            return this.__getInstanceType();
        }
        try {
            this.__IM.onEntry((Object)this, "getInstanceType", new Object[0]);
            list = this.__getInstanceType();
            this.__IM.onExit((Object)this, "getInstanceType", (Object)list);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getInstanceType", throwable);
            throw throwable;
        }
        return list;
    }

    private List __getInstanceType() {
        return this.__getm_types();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null) {
            if (set.contains("m_managedServices")) {
                this.__Fm_managedServices = true;
            }
            if (set.contains("m_context")) {
                this.__Fm_context = true;
            }
            if (set.contains("m_services")) {
                this.__Fm_services = true;
            }
            if (set.contains("m_exporters")) {
                this.__Fm_exporters = true;
            }
            if (set.contains("m_types")) {
                this.__Fm_types = true;
            }
        }
        if ((set = this.__IM.getRegistredMethods()) != null) {
            if (set.contains("initializeComponentFactory$org_apache_felix_ipojo_architecture_ComponentTypeDescription$org_apache_felix_ipojo_metadata_Element")) {
                this.__MinitializeComponentFactory$org_apache_felix_ipojo_architecture_ComponentTypeDescription$org_apache_felix_ipojo_metadata_Element = true;
            }
            if (set.contains("configure$org_apache_felix_ipojo_metadata_Element$java_util_Dictionary")) {
                this.__Mconfigure$org_apache_felix_ipojo_metadata_Element$java_util_Dictionary = true;
            }
            if (set.contains("start")) {
                this.__Mstart = true;
            }
            if (set.contains("stop")) {
                this.__Mstop = true;
            }
            if (set.contains("isHandlerValid")) {
                this.__MisHandlerValid = true;
            }
            if (set.contains("stateChanged$int")) {
                this.__MstateChanged$int = true;
            }
            if (set.contains("invalidate$org_apache_felix_ipojo_util_DependencyModel")) {
                this.__Minvalidate$org_apache_felix_ipojo_util_DependencyModel = true;
            }
            if (set.contains("validate$org_apache_felix_ipojo_util_DependencyModel")) {
                this.__Mvalidate$org_apache_felix_ipojo_util_DependencyModel = true;
            }
            if (set.contains("getSpecifications")) {
                this.__MgetSpecifications = true;
            }
            if (set.contains("computeAvailableServices")) {
                this.__McomputeAvailableServices = true;
            }
            if (set.contains("checkServiceSpecification$org_apache_felix_ipojo_composite_service_provides_ProvidedService")) {
                this.__McheckServiceSpecification$org_apache_felix_ipojo_composite_service_provides_ProvidedService = true;
            }
            if (set.contains("getAttachedRequirement$org_apache_felix_ipojo_metadata_Element")) {
                this.__MgetAttachedRequirement$org_apache_felix_ipojo_metadata_Element = true;
            }
            if (set.contains("checkRequirement$org_apache_felix_ipojo_composite_service_instantiator_ServiceImporter$org_apache_felix_ipojo_metadata_Element")) {
                this.__McheckRequirement$org_apache_felix_ipojo_composite_service_instantiator_ServiceImporter$org_apache_felix_ipojo_metadata_Element = true;
            }
            if (set.contains("getDescription")) {
                this.__MgetDescription = true;
            }
            if (set.contains("computeAvailableTypes")) {
                this.__McomputeAvailableTypes = true;
            }
            if (set.contains("getInstanceType")) {
                this.__MgetInstanceType = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }
}

