/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.eventadmin.impl.handler;

import java.util.ArrayList;
import java.util.List;
import org.apache.felix.eventadmin.impl.handler.BlackList;
import org.apache.felix.eventadmin.impl.handler.Filters;
import org.apache.felix.eventadmin.impl.handler.HandlerTasks;
import org.apache.felix.eventadmin.impl.handler.TopicHandlerFilters;
import org.apache.felix.eventadmin.impl.security.PermissionsUtil;
import org.apache.felix.eventadmin.impl.tasks.HandlerTaskImpl;
import org.apache.felix.eventadmin.impl.util.LogWrapper;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class BlacklistingHandlerTasks
implements HandlerTasks {
    private final BlackList m_blackList;
    private final BundleContext m_context;
    private final TopicHandlerFilters m_topicHandlerFilters;
    private final Filters m_filters;
    private final EventHandler m_nullEventHandler = new EventHandler(){

        public void handleEvent(Event event) {
        }
    };
    static /* synthetic */ Class class$org$osgi$service$event$EventHandler;

    public BlacklistingHandlerTasks(BundleContext context, BlackList blackList, TopicHandlerFilters topicHandlerFilters, Filters filters) {
        this.checkNull(context, "Context");
        this.checkNull(blackList, "BlackList");
        this.checkNull(topicHandlerFilters, "TopicHandlerFilters");
        this.checkNull(filters, "Filters");
        this.m_context = context;
        this.m_blackList = blackList;
        this.m_topicHandlerFilters = topicHandlerFilters;
        this.m_filters = filters;
    }

    public List createHandlerTasks(Event event) {
        ServiceReference[] handlerRefs = null;
        try {
            handlerRefs = this.m_context.getServiceReferences((class$org$osgi$service$event$EventHandler == null ? (class$org$osgi$service$event$EventHandler = BlacklistingHandlerTasks.class$("org.osgi.service.event.EventHandler")) : class$org$osgi$service$event$EventHandler).getName(), this.m_topicHandlerFilters.createFilterForTopic(event.getTopic()));
        }
        catch (InvalidSyntaxException e) {
            LogWrapper.getLogger().log(2, "Invalid EVENT_TOPIC [" + event.getTopic() + "]", e);
        }
        if (null == handlerRefs || handlerRefs.length == 0) {
            return null;
        }
        ArrayList<HandlerTaskImpl> result = new ArrayList<HandlerTaskImpl>();
        for (int i = 0; i < handlerRefs.length; ++i) {
            ServiceReference ref = handlerRefs[i];
            Bundle serviceBundle = ref.getBundle();
            if (serviceBundle == null || this.m_blackList.contains(ref) || !serviceBundle.hasPermission(PermissionsUtil.createSubscribePermission(event.getTopic()))) continue;
            try {
                if (!event.matches(this.m_filters.createFilter((String)ref.getProperty("event.filter")))) continue;
                result.add(new HandlerTaskImpl(ref, event, this));
                continue;
            }
            catch (InvalidSyntaxException e) {
                LogWrapper.getLogger().log(ref, 2, "Invalid EVENT_FILTER - Blacklisting ServiceReference [" + ref + " | Bundle(" + serviceBundle + ")]", e);
                this.m_blackList.add(ref);
            }
        }
        return result;
    }

    public void blackList(ServiceReference handlerRef) {
        this.m_blackList.add(handlerRef);
        LogWrapper.getLogger().log(2, "Blacklisting ServiceReference [" + handlerRef + " | Bundle(" + handlerRef.getBundle() + ")] due to timeout!");
    }

    public EventHandler getEventHandler(ServiceReference handlerRef) {
        Object result = this.m_blackList.contains(handlerRef) ? null : this.m_context.getService(handlerRef);
        return (EventHandler)(null != result ? result : this.m_nullEventHandler);
    }

    public void ungetEventHandler(EventHandler handler, ServiceReference handlerRef) {
        if (this.m_nullEventHandler != handler && !this.m_blackList.contains(handlerRef) && null != handlerRef.getBundle()) {
            this.m_context.ungetService(handlerRef);
        }
    }

    private void checkNull(Object object, String name) {
        if (null == object) {
            throw new NullPointerException(name + " may not be null");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

