/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.eventadmin.impl.tasks;

import EDU.oswego.cs.dl.util.concurrent.TimeoutException;
import java.util.Iterator;
import java.util.List;
import org.apache.felix.eventadmin.impl.dispatch.DefaultThreadPool;
import org.apache.felix.eventadmin.impl.tasks.DeliverTask;
import org.apache.felix.eventadmin.impl.tasks.HandlerTask;
import org.apache.felix.eventadmin.impl.tasks.Rendezvous;
import org.apache.felix.eventadmin.impl.tasks.SyncThread;

public class SyncDeliverTasks
implements DeliverTask {
    final DefaultThreadPool m_pool;
    long m_timeout;
    private Matcher[] m_ignoreTimeoutMatcher;

    public SyncDeliverTasks(DefaultThreadPool pool, long timeout, String[] ignoreTimeout) {
        this.m_pool = pool;
        this.update(timeout, ignoreTimeout);
    }

    public void update(long timeout, String[] ignoreTimeout) {
        this.m_timeout = timeout;
        if (ignoreTimeout == null || ignoreTimeout.length == 0) {
            this.m_ignoreTimeoutMatcher = null;
        } else {
            Matcher[] ignoreTimeoutMatcher = new Matcher[ignoreTimeout.length];
            for (int i = 0; i < ignoreTimeout.length; ++i) {
                String value = ignoreTimeout[i];
                if (value != null) {
                    value = value.trim();
                }
                if (value == null || value.length() <= 0) continue;
                ignoreTimeoutMatcher[i] = value.endsWith(".") ? new PackageMatcher(value.substring(0, value.length() - 1)) : (value.endsWith("*") ? new SubPackageMatcher(value.substring(0, value.length() - 1)) : new ClassMatcher(value));
            }
            this.m_ignoreTimeoutMatcher = ignoreTimeoutMatcher;
        }
    }

    private boolean useTimeout(HandlerTask task) {
        if (this.m_timeout > 0L) {
            Matcher[] ignoreTimeoutMatcher = this.m_ignoreTimeoutMatcher;
            if (ignoreTimeoutMatcher != null) {
                String className = task.getHandlerClassName();
                for (int i = 0; i < ignoreTimeoutMatcher.length; ++i) {
                    if (ignoreTimeoutMatcher[i] == null || !ignoreTimeoutMatcher[i].match(className)) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public void execute(List tasks) {
        Thread sleepingThread = Thread.currentThread();
        SyncThread syncThread = sleepingThread instanceof SyncThread ? (SyncThread)sleepingThread : null;
        final Rendezvous cascadingBarrier = new Rendezvous();
        if (syncThread != null) {
            if (syncThread.isTopMostHandler()) {
                syncThread.getTimerBarrier().waitForRendezvous();
            }
            syncThread.innerEventHandlingStart();
        }
        Iterator i = tasks.iterator();
        while (i.hasNext()) {
            boolean finished;
            final HandlerTask task = (HandlerTask)i.next();
            if (!this.useTimeout(task)) {
                task.execute();
                continue;
            }
            final Rendezvous startBarrier = new Rendezvous();
            final Rendezvous timerBarrier = new Rendezvous();
            this.m_pool.executeTask(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    SyncThread myThread = (SyncThread)Thread.currentThread();
                    myThread.init(timerBarrier, cascadingBarrier);
                    try {
                        startBarrier.waitForRendezvous();
                        task.execute();
                        timerBarrier.waitForRendezvous();
                    }
                    catch (IllegalStateException illegalStateException) {
                    }
                    finally {
                        myThread.cleanup();
                    }
                }
            });
            startBarrier.waitForRendezvous();
            long sleepTime = this.m_timeout;
            do {
                finished = true;
                long startTime = System.currentTimeMillis();
                try {
                    timerBarrier.waitAttemptForRendezvous(sleepTime);
                    if (task.finished()) continue;
                    sleepTime = this.m_timeout - (System.currentTimeMillis() - startTime);
                    cascadingBarrier.waitForRendezvous();
                    finished = task.finished();
                }
                catch (TimeoutException ie) {
                    task.blackListHandler();
                }
            } while (!finished);
        }
        if (syncThread != null) {
            syncThread.innerEventHandlingStopped();
            if (syncThread.isTopMostHandler() && !syncThread.getTimerBarrier().isTimedOut()) {
                syncThread.getCascadingBarrier().waitForRendezvous();
            }
        }
    }

    private static final class ClassMatcher
    implements Matcher {
        private final String m_className;

        public ClassMatcher(String name) {
            this.m_className = name;
        }

        public boolean match(String className) {
            return this.m_className.equals(className);
        }
    }

    private static final class SubPackageMatcher
    implements Matcher {
        private final String m_packageName;

        public SubPackageMatcher(String name) {
            this.m_packageName = name + '.';
        }

        public boolean match(String className) {
            int pos = className.lastIndexOf(46);
            return pos > -1 && className.substring(0, pos + 1).startsWith(this.m_packageName);
        }
    }

    private static final class PackageMatcher
    implements Matcher {
        private final String m_packageName;

        public PackageMatcher(String name) {
            this.m_packageName = name;
        }

        public boolean match(String className) {
            int pos = className.lastIndexOf(46);
            return pos > -1 && className.substring(0, pos).equals(this.m_packageName);
        }
    }

    private static interface Matcher {
        public boolean match(String var1);
    }
}

