/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.dm.impl;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;

public class InvocationUtil {
    private static final Map<Key, Method> m_methodCache;

    static {
        int size = 2048;
        m_methodCache = new LRUMap(Math.max(size, 64));
    }

    public static Object invokeCallbackMethod(Object instance, String methodName, Class<?>[][] signatures, Object[][] parameters) throws NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Class<?> currentClazz = instance.getClass();
        while (currentClazz != null && currentClazz != Object.class) {
            try {
                return InvocationUtil.invokeMethod(instance, currentClazz, methodName, signatures, parameters, false);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                currentClazz = currentClazz.getSuperclass();
            }
        }
        throw new NoSuchMethodException(methodName);
    }

    public static Object invokeMethod(Object object, Class<?> clazz, String name, Class<?>[][] signatures, Object[][] parameters, boolean isSuper) throws NoSuchMethodException, InvocationTargetException, IllegalArgumentException, IllegalAccessException {
        if (object == null) {
            throw new IllegalArgumentException("Instance cannot be null");
        }
        if (clazz == null) {
            throw new IllegalArgumentException("Class cannot be null");
        }
        if (Proxy.isProxyClass(clazz)) {
            object = Proxy.getInvocationHandler(object);
            clazz = object.getClass();
        }
        Method m = null;
        int i = 0;
        while (i < signatures.length) {
            Class<?>[] signature = signatures[i];
            m = InvocationUtil.getDeclaredMethod(clazz, name, signature, isSuper);
            if (m != null) {
                return m.invoke(object, parameters[i]);
            }
            ++i;
        }
        throw new NoSuchMethodException(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Method getDeclaredMethod(Class<?> clazz, String name, Class<?>[] signature, boolean isSuper) {
        Key key = new Key(clazz, name, signature);
        Method m = null;
        Map<Key, Method> map = m_methodCache;
        synchronized (map) {
            m = m_methodCache.get(key);
            if (m != null) {
                return m;
            }
            if (m_methodCache.containsKey(key)) {
                return null;
            }
        }
        try {
            m = clazz.getDeclaredMethod(name, signature);
            if (!isSuper || !Modifier.isPrivate(m.getModifiers())) {
                m.setAccessible(true);
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        map = m_methodCache;
        synchronized (map) {
            m_methodCache.put(key, m);
            return m;
        }
    }

    public static class Key {
        private final Class<?> m_clazz;
        private final String m_name;
        private final Class<?>[] m_signature;

        public Key(Class<?> clazz, String name, Class<?>[] signature) {
            this.m_clazz = clazz;
            this.m_name = name;
            this.m_signature = signature;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.m_clazz == null ? 0 : this.m_clazz.hashCode());
            result = 31 * result + (this.m_name == null ? 0 : this.m_name.hashCode());
            result = 31 * result + Arrays.hashCode(this.m_signature);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Key other = (Key)obj;
            if (this.m_clazz == null ? other.m_clazz != null : !this.m_clazz.equals(other.m_clazz)) {
                return false;
            }
            if (this.m_name == null ? other.m_name != null : !this.m_name.equals(other.m_name)) {
                return false;
            }
            return Arrays.equals(this.m_signature, other.m_signature);
        }
    }

    public static class LRUMap
    extends LinkedHashMap<Key, Method> {
        private final int m_size;

        public LRUMap(int size) {
            this.m_size = size;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<Key, Method> eldest) {
            return this.size() > this.m_size;
        }
    }
}

