/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.dm.impl;

import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceReference;

public class ServiceUtil {
    public static final Dictionary<String, Object> EMPTY_PROPERTIES = new Hashtable<String, Object>();

    public static int getRanking(ServiceReference ref) {
        return ServiceUtil.getRankingAsInteger(ref);
    }

    public static Integer getRankingAsInteger(ServiceReference ref) {
        Integer rank = (Integer)ref.getProperty("service.ranking");
        if (rank != null) {
            return rank;
        }
        return new Integer(0);
    }

    public static long getServiceId(ServiceReference ref) {
        return ServiceUtil.getServiceIdAsLong(ref);
    }

    public static Long getServiceIdAsLong(ServiceReference ref) {
        return ServiceUtil.getServiceIdObject(ref);
    }

    public static Long getServiceIdObject(ServiceReference ref) {
        Long aid = (Long)ref.getProperty("org.apache.felix.dependencymanager.aspect");
        if (aid != null) {
            return aid;
        }
        Long sid = (Long)ref.getProperty("service.id");
        if (sid != null) {
            return sid;
        }
        throw new IllegalArgumentException("Invalid service reference, no service ID found");
    }

    public static boolean isAspect(ServiceReference ref) {
        Long aid = (Long)ref.getProperty("org.apache.felix.dependencymanager.aspect");
        return aid != null;
    }

    public static String toString(ServiceReference ref) {
        if (ref == null) {
            return "ServiceReference[null]";
        }
        StringBuffer buf = new StringBuffer();
        Bundle bundle = ref.getBundle();
        if (bundle != null) {
            buf.append("ServiceReference[");
            buf.append(bundle.getBundleId());
            buf.append("]{");
        } else {
            buf.append("ServiceReference[unregistered]{");
        }
        buf.append(ServiceUtil.propertiesToString(ref, null));
        buf.append("}");
        return buf.toString();
    }

    public static String propertiesToString(ServiceReference ref, List<String> exclude) {
        StringBuffer buf = new StringBuffer();
        String[] keys = ref.getPropertyKeys();
        for (int i = 0; i < keys.length; ++i) {
            if (i > 0) {
                buf.append(',');
            }
            buf.append(keys[i]);
            buf.append('=');
            Object val = ref.getProperty(keys[i]);
            if (exclude != null && exclude.contains(val)) continue;
            if (val instanceof String[]) {
                String[] valArray = (String[])val;
                StringBuffer valBuf = new StringBuffer();
                valBuf.append('{');
                for (int j = 0; j < valArray.length; ++j) {
                    if (valBuf.length() > 1) {
                        valBuf.append(',');
                    }
                    valBuf.append(valArray[j].toString());
                }
                valBuf.append('}');
                buf.append(valBuf);
                continue;
            }
            buf.append(val.toString());
        }
        return buf.toString();
    }

    public static Dictionary<String, Object> propertiesToDictionary(final ServiceReference ref) {
        return new Dictionary<String, Object>(){
            private Dictionary<String, Object> m_wrapper;

            @Override
            public int size() {
                return this.getWrapper().size();
            }

            @Override
            public boolean isEmpty() {
                return this.getWrapper().isEmpty();
            }

            @Override
            public Enumeration<String> keys() {
                return this.getWrapper().keys();
            }

            @Override
            public Enumeration<Object> elements() {
                return this.getWrapper().elements();
            }

            @Override
            public Object get(Object key) {
                return ref.getProperty(key.toString());
            }

            @Override
            public Object put(String key, Object value) {
                throw new UnsupportedOperationException("Unmodified Dictionary.");
            }

            @Override
            public Object remove(Object key) {
                throw new UnsupportedOperationException("Unmodified Dictionary.");
            }

            public String toString() {
                return this.getWrapper().toString();
            }

            private synchronized Dictionary<String, Object> getWrapper() {
                if (this.m_wrapper == null) {
                    String[] keys;
                    this.m_wrapper = new Hashtable<String, Object>();
                    for (String key : keys = ref.getPropertyKeys()) {
                        this.m_wrapper.put(key, ref.getProperty(key));
                    }
                }
                return this.m_wrapper;
            }
        };
    }
}

