/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.dm.impl;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import org.apache.felix.dm.Component;
import org.apache.felix.dm.ComponentDeclaration;
import org.apache.felix.dm.ComponentExecutorFactory;
import org.apache.felix.dm.context.ComponentContext;
import org.apache.felix.dm.impl.SerialExecutor;
import org.osgi.framework.BundleContext;

public class ComponentScheduler {
    private static final ComponentScheduler m_instance = new ComponentScheduler();
    private static final String PARALLEL = "org.apache.felix.dependencymanager.parallel";
    private volatile ComponentExecutorFactory m_componentExecutorFactory;
    private final Executor m_serial = new SerialExecutor(null);
    private ConcurrentMap<Component, Component> m_pending = new ConcurrentHashMap<Component, Component>();

    public static ComponentScheduler instance() {
        return m_instance;
    }

    protected void bind(ComponentExecutorFactory componentExecutorFactory) {
        this.m_componentExecutorFactory = componentExecutorFactory;
        this.m_serial.execute(new Runnable(){

            @Override
            public void run() {
                for (Component c : ComponentScheduler.this.m_pending.keySet()) {
                    ComponentScheduler.this.createComponentExecutor(ComponentScheduler.this.m_componentExecutorFactory, c);
                    ((ComponentContext)c).start();
                }
                ComponentScheduler.this.m_pending.clear();
            }
        });
    }

    protected void unbind(ComponentExecutorFactory threadPool) {
        this.m_componentExecutorFactory = null;
    }

    public void add(final Component c) {
        if (this.mayStartNow(c)) {
            ((ComponentContext)c).start();
        } else {
            this.m_serial.execute(new Runnable(){

                @Override
                public void run() {
                    ComponentExecutorFactory execFactory = ComponentScheduler.this.m_componentExecutorFactory;
                    if (execFactory == null) {
                        ComponentScheduler.this.m_pending.put(c, c);
                    } else {
                        ComponentScheduler.this.createComponentExecutor(execFactory, c);
                        ((ComponentContext)c).start();
                    }
                }
            });
        }
    }

    public void remove(Component c) {
        this.m_pending.remove(c);
        ((ComponentContext)c).stop();
    }

    private boolean mayStartNow(Component c) {
        ComponentExecutorFactory execFactory = this.m_componentExecutorFactory;
        BundleContext ctx = c.getDependencyManager().getBundleContext();
        String parallel = ctx.getProperty(PARALLEL);
        if (execFactory == null) {
            return parallel == null || !this.requiresThreadPool(c, parallel);
        }
        if (parallel == null || this.requiresThreadPool(c, parallel)) {
            this.createComponentExecutor(execFactory, c);
        }
        return true;
    }

    private boolean requiresThreadPool(Component c, String parallel) {
        ComponentDeclaration decl = c.getComponentDeclaration();
        if (ComponentScheduler.class.getName().equals(decl.getName())) {
            return false;
        }
        for (String prefix : parallel.trim().split(",")) {
            boolean not = (prefix = prefix.trim()).startsWith("!");
            if (not) {
                prefix = prefix.substring(1).trim();
            }
            if (!"*".equals(prefix) && !c.getComponentDeclaration().getClassName().startsWith(prefix)) continue;
            return !not;
        }
        return false;
    }

    private void createComponentExecutor(ComponentExecutorFactory execFactory, Component c) {
        Executor exec = execFactory.getExecutorFor(c);
        if (exec != null) {
            ((ComponentContext)c).setThreadPool(exec);
        }
    }
}

