/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.dm.impl.index;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import org.apache.felix.dm.FilterIndex;
import org.apache.felix.dm.impl.ServiceUtil;
import org.apache.felix.dm.impl.index.AbstractFactoryFilterIndex;
import org.apache.felix.dm.tracker.ServiceTracker;
import org.apache.felix.dm.tracker.ServiceTrackerCustomizer;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;

public class AspectFilterIndex
extends AbstractFactoryFilterIndex
implements FilterIndex,
ServiceTrackerCustomizer {
    private static final String FILTER_START = "(&(objectClass=";
    private static final String FILTER_SUBSTRING_0 = ")(&(|(!(service.ranking=*))(service.ranking<=";
    private static final String FILTER_SUBSTRING_1 = "))(|(service.id=";
    private static final String FILTER_SUBSTRING_2 = ")(org.apache.felix.dependencymanager.aspect=";
    private static final String FILTER_END = "))))";
    private final Object m_lock = new Object();
    private ServiceTracker m_tracker;
    private BundleContext m_context;
    private final Map<Long, Map<String, SortedMap<Integer, List<ServiceListener>>>> m_sidToObjectClassToRankingToListenersMap = new HashMap<Long, Map<String, SortedMap<Integer, List<ServiceListener>>>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open(BundleContext context) {
        Object object = this.m_lock;
        synchronized (object) {
            if (this.m_context != null) {
                throw new IllegalStateException("Filter already open.");
            }
            try {
                this.m_tracker = new ServiceTracker(context, context.createFilter("(objectClass=*)"), (ServiceTrackerCustomizer)this);
            }
            catch (InvalidSyntaxException e) {
                throw new Error();
            }
            this.m_context = context;
        }
        this.m_tracker.open(true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        ServiceTracker tracker;
        Object object = this.m_lock;
        synchronized (object) {
            if (this.m_context == null) {
                throw new IllegalStateException("Filter already closed.");
            }
            tracker = this.m_tracker;
            this.m_tracker = null;
            this.m_context = null;
        }
        tracker.close();
    }

    @Override
    public boolean isApplicable(String clazz, String filter) {
        return this.getFilterData(clazz, filter) != null;
    }

    private AbstractFactoryFilterIndex.FilterData getFilterData(String clazz, String filter) {
        if (filter != null && filter.startsWith(FILTER_START) && filter.endsWith(FILTER_END)) {
            long sid2;
            int i0 = filter.indexOf(FILTER_SUBSTRING_0);
            if (i0 == -1) {
                return null;
            }
            int i1 = filter.indexOf(FILTER_SUBSTRING_1);
            if (i1 == -1 || i1 <= i0) {
                return null;
            }
            int i2 = filter.indexOf(FILTER_SUBSTRING_2);
            if (i2 == -1 || i2 <= i1) {
                return null;
            }
            long sid = Long.parseLong(filter.substring(i1 + FILTER_SUBSTRING_1.length(), i2));
            if (sid != (sid2 = Long.parseLong(filter.substring(i2 + FILTER_SUBSTRING_2.length(), filter.length() - FILTER_END.length())))) {
                return null;
            }
            AbstractFactoryFilterIndex.FilterData result = new AbstractFactoryFilterIndex.FilterData();
            result.m_objectClass = filter.substring(FILTER_START.length(), i0);
            result.m_serviceId = sid;
            result.m_ranking = Integer.parseInt(filter.substring(i0 + FILTER_SUBSTRING_0.length(), i1));
            return result;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ServiceReference> getAllServiceReferences(String clazz, String filter) {
        ArrayList<ServiceReference> result = new ArrayList<ServiceReference>();
        AbstractFactoryFilterIndex.FilterData data = this.getFilterData(clazz, filter);
        if (data != null) {
            SortedSet list = null;
            Map map = this.m_sidToServiceReferencesMap;
            synchronized (map) {
                list = (SortedSet)this.m_sidToServiceReferencesMap.get(data.m_serviceId);
                if (list != null) {
                    for (ServiceReference reference : list) {
                        if (!this.referenceMatchesObjectClass(reference, data.m_objectClass) || ServiceUtil.getRanking(reference) > data.m_ranking) continue;
                        result.add(reference);
                    }
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void serviceChanged(ServiceEvent event) {
        ArrayList list = new ArrayList();
        ServiceReference reference = event.getServiceReference();
        Long sidObject = ServiceUtil.getServiceIdObject(reference);
        int ranking = ServiceUtil.getRanking(reference);
        String[] objectClasses = (String[])reference.getProperty("objectClass");
        Map<Long, Map<String, SortedMap<Integer, List<ServiceListener>>>> map = this.m_sidToObjectClassToRankingToListenersMap;
        synchronized (map) {
            for (int i = 0; i < objectClasses.length; ++i) {
                SortedMap<Integer, List<ServiceListener>> rankingToListenersMap;
                String objectClass = objectClasses[i];
                Map<String, SortedMap<Integer, List<ServiceListener>>> objectClassToRankingToListenersMap = this.m_sidToObjectClassToRankingToListenersMap.get(sidObject);
                if (objectClassToRankingToListenersMap == null || (rankingToListenersMap = objectClassToRankingToListenersMap.get(objectClass)) == null) continue;
                for (Map.Entry<Integer, List<ServiceListener>> entry : rankingToListenersMap.entrySet()) {
                    if (ranking > entry.getKey()) continue;
                    list.addAll(entry.getValue());
                }
            }
        }
        for (ServiceListener listener : list) {
            listener.serviceChanged(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addServiceListener(ServiceListener listener, String filter) {
        AbstractFactoryFilterIndex.FilterData data = this.getFilterData(null, filter);
        if (data != null) {
            Long sidObject = data.m_serviceId;
            Map<Long, Map<String, SortedMap<Integer, List<ServiceListener>>>> map = this.m_sidToObjectClassToRankingToListenersMap;
            synchronized (map) {
                ArrayList<ServiceListener> listeners;
                SortedMap<Integer, List<ServiceListener>> rankingToListenersMap;
                Map<String, SortedMap<Integer, List<ServiceListener>>> objectClassToRankingToListenersMap = this.m_sidToObjectClassToRankingToListenersMap.get(sidObject);
                if (objectClassToRankingToListenersMap == null) {
                    objectClassToRankingToListenersMap = new TreeMap<String, SortedMap<Integer, List<ServiceListener>>>();
                    this.m_sidToObjectClassToRankingToListenersMap.put(sidObject, objectClassToRankingToListenersMap);
                }
                if ((rankingToListenersMap = objectClassToRankingToListenersMap.get(data.m_objectClass)) == null) {
                    rankingToListenersMap = new TreeMap<Integer, List<ServiceListener>>();
                    objectClassToRankingToListenersMap.put(data.m_objectClass, rankingToListenersMap);
                }
                if ((listeners = (ArrayList<ServiceListener>)rankingToListenersMap.get(data.m_ranking)) == null) {
                    listeners = new ArrayList<ServiceListener>();
                    rankingToListenersMap.put(data.m_ranking, listeners);
                }
                listeners.add(listener);
                this.m_listenerToFilterMap.put(listener, filter);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeServiceListener(ServiceListener listener) {
        Map<Long, Map<String, SortedMap<Integer, List<ServiceListener>>>> map = this.m_sidToObjectClassToRankingToListenersMap;
        synchronized (map) {
            SortedMap<Integer, List<ServiceListener>> rankingToListenersMap;
            Long sidObject;
            Map<String, SortedMap<Integer, List<ServiceListener>>> objectClassToRankingToListenersMap;
            AbstractFactoryFilterIndex.FilterData data;
            String filter = (String)this.m_listenerToFilterMap.remove(listener);
            if (filter != null && (data = this.getFilterData(null, filter)) != null && (objectClassToRankingToListenersMap = this.m_sidToObjectClassToRankingToListenersMap.get(sidObject = Long.valueOf(data.m_serviceId))) != null && (rankingToListenersMap = objectClassToRankingToListenersMap.get(data.m_objectClass)) != null) {
                List listeners = (List)rankingToListenersMap.get(data.m_ranking);
                if (listeners != null) {
                    listeners.remove(listener);
                }
                if (listeners != null && listeners.isEmpty()) {
                    rankingToListenersMap.remove(data.m_ranking);
                }
                if (rankingToListenersMap.isEmpty()) {
                    objectClassToRankingToListenersMap.remove(data.m_objectClass);
                }
                if (objectClassToRankingToListenersMap.isEmpty()) {
                    this.m_sidToObjectClassToRankingToListenersMap.remove(sidObject);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object addingService(ServiceReference reference) {
        BundleContext context;
        Object object = this.m_lock;
        synchronized (object) {
            context = this.m_context;
        }
        if (context != null) {
            return context.getService(reference);
        }
        throw new IllegalStateException("No valid bundle context.");
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("AspectFilterIndex[");
        sb.append("S2R2L: " + this.m_sidToObjectClassToRankingToListenersMap.size());
        sb.append(", S2SR: " + this.m_sidToServiceReferencesMap.size());
        sb.append(", L2F: " + this.m_listenerToFilterMap.size());
        sb.append("]");
        return sb.toString();
    }
}

