/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.dm.impl;

import java.lang.reflect.InvocationTargetException;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.felix.dm.Component;
import org.apache.felix.dm.ComponentStateListener;
import org.apache.felix.dm.DependencyManager;
import org.apache.felix.dm.Logger;
import org.apache.felix.dm.PropertyMetaData;
import org.apache.felix.dm.context.DependencyContext;
import org.apache.felix.dm.impl.AbstractDecorator;
import org.apache.felix.dm.impl.ComponentImpl;
import org.apache.felix.dm.impl.FilterComponent;
import org.apache.felix.dm.impl.InvocationUtil;
import org.apache.felix.dm.impl.metatype.MetaTypeProviderImpl;
import org.osgi.framework.BundleContext;
import org.osgi.service.cm.ManagedServiceFactory;
import org.osgi.service.metatype.MetaTypeProvider;
import org.osgi.service.metatype.ObjectClassDefinition;

public class FactoryConfigurationAdapterImpl
extends FilterComponent {
    protected final String m_factoryPid;
    protected final Logger m_logger;

    public FactoryConfigurationAdapterImpl(DependencyManager dm, String factoryPid, String update, boolean propagate, Object updateCallbackInstance) {
        super(dm.createComponent());
        this.m_factoryPid = factoryPid;
        this.m_logger = this.m_component.getLogger();
        Hashtable<String, String> props = new Hashtable<String, String>();
        props.put("service.pid", factoryPid);
        this.m_component.setInterface(ManagedServiceFactory.class.getName(), props).setImplementation(new AdapterImpl(update, propagate, updateCallbackInstance)).setCallbacks("init", null, "stop", null);
    }

    public FactoryConfigurationAdapterImpl(DependencyManager dm, String factoryPid, String update, boolean propagate, Object updateCallbackInstance, BundleContext bctx, Logger logger, String heading, String description, String localization, PropertyMetaData[] properyMetaData) {
        super(dm.createComponent());
        this.m_factoryPid = factoryPid;
        this.m_logger = logger;
        Hashtable<String, String> props = new Hashtable<String, String>();
        props.put("service.pid", factoryPid);
        this.m_component.setInterface(ManagedServiceFactory.class.getName(), props).setImplementation(new MetaTypeAdapterImpl(update, propagate, updateCallbackInstance, bctx, logger, heading, description, localization, properyMetaData)).setCallbacks("init", null, "stop", null);
    }

    @Override
    public String getName() {
        return "Adapter for factory pid " + this.m_factoryPid;
    }

    class MetaTypeAdapterImpl
    extends AdapterImpl
    implements MetaTypeProvider {
        private final MetaTypeProviderImpl m_metaType;

        public MetaTypeAdapterImpl(String updateMethod, boolean propagate, Object updateCallbackInstance, BundleContext bctx, Logger logger, String heading, String description, String localization, PropertyMetaData[] properyMetaData) {
            super(updateMethod, propagate, updateCallbackInstance);
            this.m_metaType = new MetaTypeProviderImpl(FactoryConfigurationAdapterImpl.this.m_factoryPid, bctx, logger, null, this);
            this.m_metaType.setName(heading);
            this.m_metaType.setDescription(description);
            if (localization != null) {
                this.m_metaType.setLocalization(localization);
            }
            for (int i = 0; i < properyMetaData.length; ++i) {
                this.m_metaType.add(properyMetaData[i]);
            }
        }

        public String[] getLocales() {
            return this.m_metaType.getLocales();
        }

        public ObjectClassDefinition getObjectClassDefinition(String id, String locale) {
            return this.m_metaType.getObjectClassDefinition(id, locale);
        }
    }

    public class AdapterImpl
    extends AbstractDecorator
    implements ManagedServiceFactory {
        protected final String m_update;
        protected final boolean m_propagate;
        protected final Object m_updateCallbackInstance;

        public AdapterImpl(String updateMethod, boolean propagate, Object updateCallbackObject) {
            this.m_update = updateMethod;
            this.m_propagate = propagate;
            this.m_updateCallbackInstance = updateCallbackObject;
        }

        public String getName() {
            return FactoryConfigurationAdapterImpl.this.m_factoryPid;
        }

        @Override
        public Component createService(Object[] properties) {
            Dictionary settings = (Dictionary)properties[0];
            Component newService = this.m_manager.createComponent();
            Dictionary<String, Object> serviceProperties = this.getServiceProperties(settings);
            newService.setInterface(FactoryConfigurationAdapterImpl.this.m_serviceInterfaces, serviceProperties);
            newService.setImplementation(FactoryConfigurationAdapterImpl.this.m_serviceImpl);
            newService.setComposition(FactoryConfigurationAdapterImpl.this.m_compositionInstance, FactoryConfigurationAdapterImpl.this.m_compositionMethod);
            newService.setCallbacks(FactoryConfigurationAdapterImpl.this.m_callbackObject, FactoryConfigurationAdapterImpl.this.m_init, FactoryConfigurationAdapterImpl.this.m_start, FactoryConfigurationAdapterImpl.this.m_stop, FactoryConfigurationAdapterImpl.this.m_destroy);
            this.configureAutoConfigState(newService, FactoryConfigurationAdapterImpl.this.m_component);
            for (DependencyContext dc : FactoryConfigurationAdapterImpl.this.m_component.getDependencies()) {
                newService.add(dc.createCopy());
            }
            for (int i = 0; i < FactoryConfigurationAdapterImpl.this.m_stateListeners.size(); ++i) {
                newService.add((ComponentStateListener)FactoryConfigurationAdapterImpl.this.m_stateListeners.get(i));
            }
            ((ComponentImpl)newService).instantiateComponent();
            try {
                for (Object instance : this.getCompositionInstances(newService)) {
                    InvocationUtil.invokeCallbackMethod(instance, this.m_update, new Class[][]{{Dictionary.class}, {Component.class, Dictionary.class}, new Class[0]}, new Object[][]{{settings}, {newService, settings}, new Object[0]});
                }
            }
            catch (Throwable t) {
                this.handleException(t);
            }
            return newService;
        }

        @Override
        public void updateService(Object[] properties) {
            Dictionary cmSettings = (Dictionary)properties[0];
            Component service = (Component)properties[1];
            Object[] instances = this.getUpdateCallbackInstances(service);
            try {
                for (Object instance : instances) {
                    InvocationUtil.invokeCallbackMethod(instance, this.m_update, new Class[][]{{Dictionary.class}, {Component.class, Dictionary.class}, new Class[0]}, new Object[][]{{cmSettings}, {service, cmSettings}, new Object[0]});
                }
                if (FactoryConfigurationAdapterImpl.this.m_serviceInterfaces != null && this.m_propagate) {
                    Dictionary<String, Object> serviceProperties = this.getServiceProperties(cmSettings);
                    service.setServiceProperties(serviceProperties);
                }
            }
            catch (Throwable t) {
                this.handleException(t);
            }
        }

        private Object[] getUpdateCallbackInstances(Component comp) {
            if (this.m_updateCallbackInstance == null) {
                return comp.getInstances();
            }
            return new Object[]{this.m_updateCallbackInstance};
        }

        private Object[] getCompositionInstances(Component component) {
            if (this.m_updateCallbackInstance != null) {
                return new Object[]{this.m_updateCallbackInstance};
            }
            return component.getInstances();
        }

        private Dictionary<String, Object> getServiceProperties(Dictionary<String, ?> settings) {
            Object val;
            String key;
            Enumeration<Object> keys;
            Hashtable<String, Object> props = new Hashtable<String, Object>();
            if (FactoryConfigurationAdapterImpl.this.m_serviceProperties != null) {
                keys = FactoryConfigurationAdapterImpl.this.m_serviceProperties.keys();
                while (keys.hasMoreElements()) {
                    key = (String)keys.nextElement();
                    val = FactoryConfigurationAdapterImpl.this.m_serviceProperties.get(key);
                    ((Dictionary)props).put(key, val);
                }
            }
            if (this.m_propagate) {
                keys = settings.keys();
                while (keys.hasMoreElements()) {
                    key = (String)keys.nextElement();
                    if (key.toString().startsWith(".")) continue;
                    val = settings.get(key);
                    ((Dictionary)props).put(key, val);
                }
            }
            return props;
        }

        private void handleException(Throwable t) {
            FactoryConfigurationAdapterImpl.this.m_logger.log(1, "Got exception while handling configuration update for factory pid " + FactoryConfigurationAdapterImpl.this.m_factoryPid, t);
            if (t instanceof InvocationTargetException) {
                throw new RuntimeException(((InvocationTargetException)t).getTargetException());
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new RuntimeException(t);
        }
    }
}

