/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.dm.diagnostics;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

class DependencyGraphNode {
    private List<DependencyGraphNode> m_successors = new ArrayList<DependencyGraphNode>();
    private List<DependencyGraphNode> m_predecessors = new ArrayList<DependencyGraphNode>();
    private DependencyGraphNodeState m_state = DependencyGraphNodeState.UNDISCOVERED;

    DependencyGraphNode() {
    }

    public void addSuccessor(DependencyGraphNode successor) {
        this.m_successors.add(successor);
        successor.addPredecessor(this);
    }

    private void addPredecessor(DependencyGraphNode predecessor) {
        this.m_predecessors.add(predecessor);
    }

    public List<DependencyGraphNode> getSuccessors() {
        return Collections.unmodifiableList(this.m_successors);
    }

    public List<DependencyGraphNode> getPredecessors() {
        return Collections.unmodifiableList(this.m_predecessors);
    }

    void setState(DependencyGraphNodeState state) {
        this.m_state = state;
    }

    boolean isDiscovered() {
        return this.m_state == DependencyGraphNodeState.DISCOVERED;
    }

    boolean isUndiscovered() {
        return this.m_state == DependencyGraphNodeState.UNDISCOVERED;
    }

    boolean isProcessed() {
        return this.m_state == DependencyGraphNodeState.PROCESSED;
    }

    public static enum DependencyGraphNodeState {
        UNDISCOVERED,
        DISCOVERED,
        PROCESSED;

    }
}

