/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.dependencymanager;

import java.util.Dictionary;
import java.util.Properties;
import org.apache.felix.dependencymanager.Dependency;
import org.apache.felix.dependencymanager.Logger;
import org.apache.felix.dependencymanager.Service;
import org.apache.felix.dependencymanager.ServiceComponentDependency;
import org.apache.felix.dependencymanager.ServiceImpl;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedService;

public class ConfigurationDependency
implements Dependency,
ManagedService,
ServiceComponentDependency {
    private BundleContext m_context;
    private String m_pid;
    private ServiceRegistration m_registration;
    private volatile Service m_service;
    private Dictionary m_settings;
    private boolean m_propagate;
    private final Logger m_logger;
    static /* synthetic */ Class class$org$osgi$service$cm$ManagedService;

    public ConfigurationDependency(BundleContext context, Logger logger) {
        this.m_context = context;
        this.m_logger = logger;
    }

    public synchronized boolean isAvailable() {
        return this.m_settings != null;
    }

    public boolean isRequired() {
        return true;
    }

    public boolean isPropagated() {
        return this.m_propagate;
    }

    public Dictionary getConfiguration() {
        return this.m_settings;
    }

    public void start(Service service) {
        this.m_service = service;
        Properties props = new Properties();
        props.put("service.pid", this.m_pid);
        this.m_registration = this.m_context.registerService((class$org$osgi$service$cm$ManagedService == null ? (class$org$osgi$service$cm$ManagedService = ConfigurationDependency.class$("org.osgi.service.cm.ManagedService")) : class$org$osgi$service$cm$ManagedService).getName(), (Object)this, (Dictionary)props);
    }

    public void stop(Service service) {
        this.m_registration.unregister();
        this.m_service = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updated(Dictionary settings) throws ConfigurationException {
        ((ServiceImpl)this.m_service).initService();
        Object service = this.m_service.getService();
        if (service != null) {
            if (!(service instanceof ManagedService)) {
                this.m_logger.log(1, "Service " + this.m_service + " with configuration dependency " + this + " does not implement ManagedService.");
                return;
            }
        } else {
            this.m_logger.log(1, "Service " + this.m_service + " with configuration dependency " + this + " could not be instantiated.");
            return;
        }
        ManagedService ms = (ManagedService)service;
        ms.updated(settings);
        Dictionary oldSettings = null;
        ConfigurationDependency configurationDependency = this;
        synchronized (configurationDependency) {
            oldSettings = this.m_settings;
            this.m_settings = settings;
        }
        if (oldSettings == null && settings != null) {
            this.m_service.dependencyAvailable(this);
        }
        if (oldSettings != null && settings == null) {
            this.m_service.dependencyUnavailable(this);
        }
        if (oldSettings != null && settings != null) {
            this.m_service.dependencyChanged(this);
        }
    }

    public ConfigurationDependency setPid(String pid) {
        this.ensureNotActive();
        this.m_pid = pid;
        return this;
    }

    public ConfigurationDependency setPropagate(boolean propagate) {
        this.ensureNotActive();
        this.m_propagate = propagate;
        return this;
    }

    private void ensureNotActive() {
        if (this.m_service != null) {
            throw new IllegalStateException("Cannot modify state while active.");
        }
    }

    public String toString() {
        return "ConfigurationDependency[" + this.m_pid + "]";
    }

    public String getName() {
        return this.m_pid;
    }

    public int getState() {
        return (this.isAvailable() ? 1 : 0) + (this.isRequired() ? 2 : 0);
    }

    public String getType() {
        return "configuration";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

