/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scrplugin.mojo;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.felix.scrplugin.Log;
import org.apache.felix.scrplugin.Options;
import org.apache.felix.scrplugin.Project;
import org.apache.felix.scrplugin.Result;
import org.apache.felix.scrplugin.SCRDescriptorException;
import org.apache.felix.scrplugin.SCRDescriptorFailureException;
import org.apache.felix.scrplugin.SCRDescriptorGenerator;
import org.apache.felix.scrplugin.SpecVersion;
import org.apache.felix.scrplugin.mojo.MavenLog;
import org.apache.felix.scrplugin.mojo.MavenProjectScanner;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SCRDescriptorMojo
extends AbstractMojo {
    private static final String SCR_ANN_GROUPID = "org.apache.felix";
    private static final String SCR_ANN_ARTIFACTID = "org.apache.felix.scr.annotations";
    private static final ArtifactVersion SCR_ANN_MIN_VERSION = new DefaultArtifactVersion("1.6.9");
    private File outputDirectory;
    private MavenProject project;
    private String finalName;
    private String metaTypeName;
    private boolean generateAccessors;
    protected boolean strictMode;
    private String sourceIncludes;
    private String sourceExcludes;
    private Map<String, String> properties = new LinkedHashMap<String, String>();
    private String specVersion;
    private List<String> supportedProjectTypes = Arrays.asList("jar", "bundle");

    public void execute() throws MojoExecutionException, MojoFailureException {
        String projectType = this.project.getArtifact().getType();
        if (!this.supportedProjectTypes.contains(projectType)) {
            this.getLog().debug((CharSequence)("Ignoring project type " + projectType + " - supportedProjectTypes = " + this.supportedProjectTypes));
            return;
        }
        MavenLog scrLog = new MavenLog(this.getLog());
        MavenProjectScanner scanner = new MavenProjectScanner(this.project, this.sourceIncludes, this.sourceExcludes, scrLog);
        Project project = new Project();
        project.setClassLoader((ClassLoader)new URLClassLoader(this.getClassPath(), ((Object)((Object)this)).getClass().getClassLoader()));
        project.setDependencies(scanner.getDependencies());
        project.setSources(scanner.getSources());
        project.setClassesDirectory(this.project.getBuild().getOutputDirectory());
        Options options = new Options();
        options.setOutputDirectory(this.outputDirectory);
        options.setSCRName(this.finalName);
        options.setMetaTypeName(this.metaTypeName);
        options.setGenerateAccessors(this.generateAccessors);
        options.setStrictMode(this.strictMode);
        options.setProperties(this.properties);
        options.setSpecVersion(SpecVersion.fromName((String)this.specVersion));
        if (this.specVersion != null && options.getSpecVersion() == null) {
            throw new MojoExecutionException("Unknown spec version specified: " + this.specVersion);
        }
        try {
            SCRDescriptorGenerator generator = new SCRDescriptorGenerator((Log)scrLog);
            generator.setOptions(options);
            generator.setProject(project);
            Result result = generator.execute();
            this.setServiceComponentHeader(result.getScrFiles());
            this.updateProjectResources();
        }
        catch (SCRDescriptorException sde) {
            throw new MojoExecutionException(sde.getSourceLocation() + " : " + sde.getMessage(), (Exception)((Object)sde));
        }
        catch (SCRDescriptorFailureException sdfe) {
            throw (MojoFailureException)new MojoFailureException(sdfe.getMessage()).initCause((Throwable)sdfe);
        }
    }

    private URL[] getClassPath() throws MojoFailureException {
        List artifacts = this.project.getCompileArtifacts();
        ArrayList<URL> path = new ArrayList<URL>();
        try {
            path.add(new File(this.project.getBuild().getOutputDirectory()).toURI().toURL());
        }
        catch (IOException ioe) {
            throw new MojoFailureException("Unable to add target directory to classloader.");
        }
        for (Artifact a : artifacts) {
            this.assertMinScrAnnotationArtifactVersion(a);
            try {
                path.add(a.getFile().toURI().toURL());
            }
            catch (IOException ioe) {
                throw new MojoFailureException("Unable to get compile class loader.");
            }
        }
        return path.toArray(new URL[path.size()]);
    }

    private void assertMinScrAnnotationArtifactVersion(Artifact a) throws MojoFailureException {
        DefaultArtifactVersion aVersion;
        if (SCR_ANN_ARTIFACTID.equals(a.getArtifactId()) && SCR_ANN_GROUPID.equals(a.getGroupId()) && SCR_ANN_MIN_VERSION.compareTo((Object)(aVersion = new DefaultArtifactVersion(a.getBaseVersion()))) > 0) {
            this.getLog().error((CharSequence)("Project depends on " + a));
            this.getLog().error((CharSequence)("Minimum required version is " + SCR_ANN_MIN_VERSION));
            throw new MojoFailureException("Please use org.apache.felix:org.apache.felix.scr.annotations version " + SCR_ANN_MIN_VERSION + " or newer.");
        }
    }

    private void setServiceComponentHeader(List<String> files) {
        if (files != null && files.size() > 0) {
            String svcHeader = this.project.getProperties().getProperty("Service-Component");
            HashSet<String> xmlFiles = new HashSet<String>();
            if (svcHeader != null) {
                StringTokenizer st = new StringTokenizer(svcHeader, ",");
                while (st.hasMoreTokens()) {
                    String token = st.nextToken();
                    xmlFiles.add(token.trim());
                }
            }
            for (String path : files) {
                xmlFiles.add(path);
            }
            StringBuilder sb = new StringBuilder();
            boolean first = true;
            for (String entry : xmlFiles) {
                if (!first) {
                    sb.append(", ");
                } else {
                    first = false;
                }
                sb.append(entry);
            }
            this.project.getProperties().setProperty("Service-Component", sb.toString());
        }
    }

    private void updateProjectResources() {
        String ourRsrcPath = this.outputDirectory.getAbsolutePath();
        boolean found = false;
        Iterator rsrcIterator = this.project.getResources().iterator();
        while (!found && rsrcIterator.hasNext()) {
            Resource rsrc = (Resource)rsrcIterator.next();
            found = rsrc.getDirectory().equals(ourRsrcPath);
        }
        if (!found) {
            Resource resource = new Resource();
            resource.setDirectory(this.outputDirectory.getAbsolutePath());
            this.project.addResource(resource);
        }
    }
}

