/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scrplugin.xml;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import javax.xml.transform.TransformerException;
import org.apache.felix.scrplugin.SCRDescriptorException;
import org.apache.felix.scrplugin.om.metatype.AttributeDefinition;
import org.apache.felix.scrplugin.om.metatype.Designate;
import org.apache.felix.scrplugin.om.metatype.MTObject;
import org.apache.felix.scrplugin.om.metatype.MetaData;
import org.apache.felix.scrplugin.om.metatype.OCD;
import org.apache.felix.scrplugin.xml.IOUtils;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class MetaTypeIO {
    public static final String NAMESPACE_URI = "http://www.osgi.org/xmlns/metatype/v1.0.0";
    public static final String INNER_NAMESPACE_URI = "";
    public static final String PREFIX = "metatype";
    protected static final String METADATA_ELEMENT = "MetaData";
    protected static final String METADATA_ELEMENT_QNAME = "metatype:MetaData";
    protected static final String OCD_ELEMENT = "OCD";
    protected static final String OCD_ELEMENT_QNAME = "OCD";
    protected static final String DESIGNATE_ELEMENT = "Designate";
    protected static final String DESIGNATE_ELEMENT_QNAME = "Designate";
    protected static final String OBJECT_ELEMENT = "Object";
    protected static final String OBJECT_ELEMENT_QNAME = "Object";
    protected static final String AD_ELEMENT = "AD";
    protected static final String AD_ELEMENT_QNAME = "AD";
    protected static final String OPTION_ELEMENT = "Option";
    protected static final String OPTION_ELEMENT_QNAME = "Option";

    public static void write(MetaData metaData, File file) throws SCRDescriptorException {
        try {
            MetaTypeIO.generateXML(metaData, IOUtils.getSerializer(file));
        }
        catch (TransformerException e) {
            throw new SCRDescriptorException("Unable to write xml", file.toString(), 0, e);
        }
        catch (SAXException e) {
            throw new SCRDescriptorException("Unable to generate xml", file.toString(), 0, e);
        }
        catch (IOException e) {
            throw new SCRDescriptorException("Unable to write xml", file.toString(), 0, e);
        }
    }

    protected static void generateXML(MetaData metaData, ContentHandler contentHandler) throws SAXException {
        contentHandler.startDocument();
        contentHandler.startPrefixMapping(PREFIX, NAMESPACE_URI);
        AttributesImpl ai = new AttributesImpl();
        IOUtils.addAttribute(ai, "localization", metaData.getLocalization());
        contentHandler.startElement(NAMESPACE_URI, METADATA_ELEMENT, METADATA_ELEMENT_QNAME, ai);
        IOUtils.newline(contentHandler);
        for (OCD ocd : metaData.getOCDs()) {
            MetaTypeIO.generateXML(ocd, contentHandler);
        }
        for (Designate d : metaData.getDesignates()) {
            MetaTypeIO.generateXML(d, contentHandler);
        }
        contentHandler.endElement(NAMESPACE_URI, METADATA_ELEMENT, METADATA_ELEMENT_QNAME);
        IOUtils.newline(contentHandler);
        contentHandler.endPrefixMapping(PREFIX);
        contentHandler.endDocument();
    }

    protected static void generateXML(OCD ocd, ContentHandler contentHandler) throws SAXException {
        AttributesImpl ai = new AttributesImpl();
        IOUtils.addAttribute(ai, "id", ocd.getId());
        IOUtils.addAttribute(ai, "name", ocd.getName());
        IOUtils.addAttribute(ai, "description", ocd.getDescription());
        IOUtils.indent(contentHandler, 1);
        contentHandler.startElement(INNER_NAMESPACE_URI, "OCD", "OCD", ai);
        if (ocd.getProperties().size() > 0) {
            IOUtils.newline(contentHandler);
            for (AttributeDefinition ad : ocd.getProperties()) {
                MetaTypeIO.generateXML(ad, contentHandler);
            }
            IOUtils.indent(contentHandler, 1);
        }
        contentHandler.endElement(INNER_NAMESPACE_URI, "OCD", "OCD");
        IOUtils.newline(contentHandler);
    }

    protected static void generateXML(AttributeDefinition ad, ContentHandler contentHandler) throws SAXException {
        AttributesImpl ai = new AttributesImpl();
        IOUtils.addAttribute(ai, "id", ad.getId());
        IOUtils.addAttribute(ai, "type", ad.getType());
        if (ad.getDefaultMultiValue() != null) {
            StringBuffer buf = new StringBuffer();
            for (int i = 0; i < ad.getDefaultMultiValue().length; ++i) {
                if (i > 0) {
                    buf.append(',');
                }
                buf.append(ad.getDefaultMultiValue()[i]);
            }
            IOUtils.addAttribute(ai, "default", buf);
        } else {
            IOUtils.addAttribute(ai, "default", ad.getDefaultValue());
        }
        IOUtils.addAttribute(ai, "name", ad.getName());
        IOUtils.addAttribute(ai, "description", ad.getDescription());
        IOUtils.addAttribute(ai, "cardinality", ad.getCardinality());
        IOUtils.indent(contentHandler, 2);
        contentHandler.startElement(INNER_NAMESPACE_URI, "AD", "AD", ai);
        if (ad.getOptions() != null && ad.getOptions().size() > 0) {
            IOUtils.newline(contentHandler);
            for (Map.Entry<String, String> entry : ad.getOptions().entrySet()) {
                ai.clear();
                IOUtils.addAttribute(ai, "value", entry.getKey());
                IOUtils.addAttribute(ai, "label", entry.getValue());
                IOUtils.indent(contentHandler, 3);
                contentHandler.startElement(INNER_NAMESPACE_URI, "Option", "Option", ai);
                contentHandler.endElement(INNER_NAMESPACE_URI, "Option", "Option");
                IOUtils.newline(contentHandler);
            }
            IOUtils.indent(contentHandler, 2);
        }
        contentHandler.endElement(INNER_NAMESPACE_URI, "AD", "AD");
        IOUtils.newline(contentHandler);
    }

    protected static void generateXML(Designate designate, ContentHandler contentHandler) throws SAXException {
        AttributesImpl ai = new AttributesImpl();
        IOUtils.addAttribute(ai, "pid", designate.getPid());
        IOUtils.addAttribute(ai, "factoryPid", designate.getFactoryPid());
        IOUtils.indent(contentHandler, 1);
        contentHandler.startElement(INNER_NAMESPACE_URI, "Designate", "Designate", ai);
        IOUtils.newline(contentHandler);
        MetaTypeIO.generateXML(designate.getObject(), contentHandler);
        IOUtils.indent(contentHandler, 1);
        contentHandler.endElement(INNER_NAMESPACE_URI, "Designate", "Designate");
        IOUtils.newline(contentHandler);
    }

    protected static void generateXML(MTObject obj, ContentHandler contentHandler) throws SAXException {
        AttributesImpl ai = new AttributesImpl();
        IOUtils.addAttribute(ai, "ocdref", obj.getOcdref());
        IOUtils.indent(contentHandler, 2);
        contentHandler.startElement(INNER_NAMESPACE_URI, "Object", "Object", ai);
        contentHandler.endElement(INNER_NAMESPACE_URI, "Object", "Object");
        IOUtils.newline(contentHandler);
    }
}

