/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.obr.plugin;

import java.io.File;
import java.net.URI;
import java.util.Arrays;
import java.util.List;
import org.apache.felix.obr.plugin.AbstractFileMojo;
import org.apache.felix.obr.plugin.Config;
import org.apache.felix.obr.plugin.ObrUpdate;
import org.apache.felix.obr.plugin.ObrUtils;
import org.apache.felix.obr.plugin.RemoteFileManager;
import org.apache.maven.artifact.manager.WagonManager;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Settings;

public final class ObrDeployFile
extends AbstractFileMojo {
    private boolean ignoreLock;
    private String obrRepository;
    private List supportedProjectTypes = Arrays.asList("jar", "bundle");
    private String repositoryId;
    private String url;
    private String bundleUrl;
    private ArtifactRepository localRepository;
    private Settings settings;
    private WagonManager m_wagonManager;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute() throws MojoExecutionException {
        MavenProject project = this.getProject();
        if (!this.supportedProjectTypes.contains(project.getPackaging())) {
            this.getLog().info((CharSequence)("Ignoring packaging type " + project.getPackaging()));
            return;
        }
        if ("NONE".equalsIgnoreCase(this.obrRepository)) {
            this.getLog().info((CharSequence)"OBR update disabled (enable with -DobrRepository)");
            return;
        }
        URI tempURI = ObrUtils.findRepositoryXml("", this.obrRepository);
        String repositoryName = new File(tempURI.getPath()).getName();
        Log log = this.getLog();
        RemoteFileManager remoteFile = new RemoteFileManager(this.m_wagonManager, this.settings, log);
        remoteFile.connect(this.repositoryId, this.url);
        log.info((CharSequence)("LOCK " + remoteFile + '/' + repositoryName));
        remoteFile.lockFile(repositoryName, this.ignoreLock);
        File downloadedRepositoryXml = null;
        try {
            block9: {
                try {
                    log.info((CharSequence)("Downloading " + repositoryName));
                    downloadedRepositoryXml = remoteFile.get(repositoryName, ".xml");
                    String mavenRepository = this.localRepository.getBasedir();
                    URI repositoryXml = downloadedRepositoryXml.toURI();
                    URI obrXmlFile = ObrUtils.toFileURI(this.obrXml);
                    URI bundleJar = null == this.file ? ObrUtils.findBundleJar(this.localRepository, project.getArtifact()) : this.file.toURI();
                    URI remoteBundleURI = null;
                    if (null != this.bundleUrl) {
                        remoteBundleURI = URI.create(this.bundleUrl);
                    } else if (null != this.file) {
                        remoteBundleURI = URI.create(this.localRepository.pathOf(project.getArtifact()));
                    }
                    Config userConfig = new Config();
                    userConfig.setRemoteBundle(remoteBundleURI);
                    userConfig.setPathRelative(true);
                    userConfig.setRemoteFile(true);
                    ObrUpdate update = new ObrUpdate(repositoryXml, obrXmlFile, project, bundleJar, mavenRepository, userConfig, log);
                    update.updateRepository();
                    if (!downloadedRepositoryXml.exists()) break block9;
                    log.info((CharSequence)("Uploading " + repositoryName));
                    remoteFile.put(downloadedRepositoryXml, repositoryName);
                }
                catch (Exception e) {
                    log.warn((CharSequence)("Exception while updating remote OBR: " + e.getLocalizedMessage()), (Throwable)e);
                    Object var15_16 = null;
                    log.info((CharSequence)("UNLOCK " + remoteFile + '/' + repositoryName));
                    remoteFile.unlockFile(repositoryName);
                    remoteFile.disconnect();
                    if (null == downloadedRepositoryXml) return;
                    downloadedRepositoryXml.delete();
                    return;
                }
            }
            Object var15_15 = null;
            log.info((CharSequence)("UNLOCK " + remoteFile + '/' + repositoryName));
            remoteFile.unlockFile(repositoryName);
            remoteFile.disconnect();
            if (null == downloadedRepositoryXml) return;
            downloadedRepositoryXml.delete();
            return;
        }
        catch (Throwable throwable) {
            Object var15_17 = null;
            log.info((CharSequence)("UNLOCK " + remoteFile + '/' + repositoryName));
            remoteFile.unlockFile(repositoryName);
            remoteFile.disconnect();
            if (null == downloadedRepositoryXml) throw throwable;
            downloadedRepositoryXml.delete();
            throw throwable;
        }
    }
}

