/*
 * Decompiled with CFR 0.152.
 */
package org.apache.edgent.analytics.math3.stat;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import org.apache.commons.math3.stat.regression.OLSMultipleLinearRegression;
import org.apache.edgent.analytics.math3.json.JsonUnivariateAggregator;
import org.apache.edgent.analytics.math3.stat.Regression;
import org.apache.edgent.analytics.math3.utils.Java7Helper;

class JsonOLS
implements JsonUnivariateAggregator {
    private final Regression type;
    private final OLSMultipleLinearRegression ols = new OLSMultipleLinearRegression();
    private double[] values;
    private int yOffset;

    JsonOLS(Regression type) {
        this.type = type;
    }

    @Override
    public void clear(JsonElement partition, int n) {
        this.values = new double[n * 2];
        this.yOffset = 0;
    }

    @Override
    public void increment(double v) {
        this.values[this.yOffset] = v;
        this.yOffset += 2;
    }

    void setSampleData() {
        for (int x = 0; x < this.values.length / 2; ++x) {
            this.values[x * 2 + 1] = x;
        }
        this.ols.newSampleData(this.values, this.values.length / 2, 1);
    }

    @Override
    public void result(JsonElement partition, JsonObject result) {
        double slope;
        if (this.values.length <= 2) {
            return;
        }
        this.setSampleData();
        double[] regressionParams = this.ols.estimateRegressionParameters();
        if (regressionParams.length >= 2 && Java7Helper.doubleIsFinite(slope = regressionParams[1])) {
            result.addProperty(this.type.name(), (Number)slope);
        }
        this.values = null;
    }
}

