/*
 * Decompiled with CFR 0.152.
 */
package org.apache.edgent.analytics.math3;

import java.util.Collection;
import org.apache.edgent.analytics.math3.Aggregations$$Lambda$1;
import org.apache.edgent.analytics.math3.ResultMap;
import org.apache.edgent.analytics.math3.UnivariateAggregate;
import org.apache.edgent.analytics.math3.UnivariateAggregator;
import org.apache.edgent.analytics.math3.utils.Java7Helper;
import org.apache.edgent.function.ToDoubleFunction;

public class Aggregations {
    public static Double sum(Collection<? extends Number> list) {
        double sum = 0.0;
        for (Number number : list) {
            sum += number.doubleValue();
        }
        return sum;
    }

    public static long sumInts(Collection<? extends Number> list) {
        long sum = 0L;
        for (Number number : list) {
            sum += number.longValue();
        }
        return sum;
    }

    public static Double aggregate(Collection<? extends Number> c, UnivariateAggregate aggregate) {
        return (Double)Aggregations.aggregateN(c, aggregate).get(aggregate);
    }

    public static ResultMap aggregateN(Collection<? extends Number> c, UnivariateAggregate ... aggregates) {
        return Aggregations.aggregateN(c, Aggregations$$Lambda$1.lambdaFactory$(), aggregates);
    }

    public static <T> Double aggregate(Collection<T> c, ToDoubleFunction<T> getter, UnivariateAggregate aggregate) {
        return (Double)Aggregations.aggregateN(c, getter, aggregate).get(aggregate);
    }

    public static <T> ResultMap aggregateN(Collection<T> c, ToDoubleFunction<T> getter, UnivariateAggregate ... aggregates) {
        int n = c.size();
        ResultMap result = new ResultMap();
        if (n != 0) {
            UnivariateAggregator[] aggregators = new UnivariateAggregator[aggregates.length];
            for (int i = 0; i < aggregates.length; ++i) {
                aggregators[i] = (UnivariateAggregator)aggregates[i].get();
            }
            for (UnivariateAggregator univariateAggregator : aggregators) {
                univariateAggregator.clear(n);
            }
            for (Object value : c) {
                Double d = getter.applyAsDouble(value);
                for (UnivariateAggregator agg : aggregators) {
                    agg.increment(d);
                }
            }
            for (UnivariateAggregator univariateAggregator : aggregators) {
                double rv = univariateAggregator.getResult();
                if (!Java7Helper.doubleIsFinite(rv)) continue;
                result.put(univariateAggregator.getAggregate(), rv);
            }
        }
        return result;
    }

    static /* synthetic */ double lambda$aggregateN$0(Number num) {
        return num.doubleValue();
    }
}

