/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.spring.security.oauth2;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.dubbo.common.utils.ClassUtils;
import org.apache.dubbo.spring.security.oauth2.AuthorizationGrantTypeMixin;
import org.apache.dubbo.spring.security.oauth2.ClientAuthenticationMethodMixin;
import org.apache.dubbo.spring.security.oauth2.ClientSettingsMixin;
import org.apache.dubbo.spring.security.oauth2.TokenSettingsMixin;
import org.apache.dubbo.spring.security.oauth2.UnmodifiableCollectionMixin;

public class OAuth2SecurityModule
extends SimpleModule {
    public OAuth2SecurityModule() {
        super(OAuth2SecurityModule.class.getName());
    }

    public void setupModule(Module.SetupContext context) {
        this.setMixInAnnotations(context, "org.springframework.security.oauth2.core.OAuth2AuthenticatedPrincipal", "org.apache.dubbo.spring.security.oauth2.OAuth2AuthenticatedPrincipalMixin");
        this.setMixInAnnotations(context, "org.springframework.security.oauth2.core.DefaultOAuth2AuthenticatedPrincipal", "org.apache.dubbo.spring.security.oauth2.OAuth2AuthenticatedPrincipalMixin");
        this.setMixInAnnotations(context, "org.springframework.security.oauth2.server.resource.authentication.BearerTokenAuthentication", "org.apache.dubbo.spring.security.oauth2.BearerTokenAuthenticationMixin");
        this.setMixInAnnotations(context, "org.springframework.security.oauth2.server.authorization.authentication.OAuth2ClientAuthenticationToken", "org.apache.dubbo.spring.security.oauth2.OAuth2ClientAuthenticationTokenMixin");
        this.setMixInAnnotations(context, "org.springframework.security.oauth2.core.ClientAuthenticationMethod", ClientAuthenticationMethodMixin.class);
        this.setMixInAnnotations(context, "org.springframework.security.oauth2.server.authorization.client.RegisteredClient", "org.apache.dubbo.spring.security.oauth2.RegisteredClientMixin");
        this.setMixInAnnotations(context, "org.springframework.security.oauth2.core.AuthorizationGrantType", AuthorizationGrantTypeMixin.class);
        this.setMixInAnnotations(context, "org.springframework.security.oauth2.server.authorization.settings.ClientSettings", ClientSettingsMixin.class);
        this.setMixInAnnotations(context, "org.springframework.security.oauth2.server.authorization.settings.TokenSettings", TokenSettingsMixin.class);
        context.setMixInAnnotations(Collections.unmodifiableCollection(new ArrayList()).getClass(), UnmodifiableCollectionMixin.class);
    }

    private void setMixInAnnotations(Module.SetupContext context, String oauth2ClassName, String mixinClassName) {
        Class<?> oauth2Class = this.loadClassIfPresent(oauth2ClassName);
        if (oauth2Class != null) {
            context.setMixInAnnotations(oauth2Class, this.loadClassIfPresent(mixinClassName));
        }
    }

    private void setMixInAnnotations(Module.SetupContext context, String oauth2ClassName, Class<?> mixinClass) {
        Class<?> oauth2Class = this.loadClassIfPresent(oauth2ClassName);
        if (oauth2Class != null) {
            context.setMixInAnnotations(oauth2Class, mixinClass);
        }
    }

    private Class<?> loadClassIfPresent(String oauth2ClassName) {
        try {
            return ClassUtils.forName((String)oauth2ClassName, (ClassLoader)OAuth2SecurityModule.class.getClassLoader());
        }
        catch (Throwable throwable) {
            return null;
        }
    }
}

