/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.spring.boot.context.event;

import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.dubbo.config.spring.util.DubboBeanUtils;
import org.apache.dubbo.remoting.http12.rest.OpenAPIService;
import org.apache.dubbo.rpc.model.ApplicationModel;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.ApplicationListener;

public class DubboOpenAPIExportListener
implements ApplicationListener<ApplicationReadyEvent> {
    private final AtomicBoolean exported = new AtomicBoolean(false);

    public void onApplicationEvent(ApplicationReadyEvent event) {
        if (!this.exported.compareAndSet(false, true)) {
            return;
        }
        ApplicationModel applicationModel = DubboBeanUtils.getApplicationModel((BeanFactory)event.getApplicationContext());
        if (applicationModel == null) {
            return;
        }
        OpenAPIService openAPIService = (OpenAPIService)applicationModel.getBean(OpenAPIService.class);
        if (openAPIService != null) {
            openAPIService.export();
        }
    }
}

