/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.spring.boot.autoconfigure.observability.zipkin;

import org.apache.dubbo.spring.boot.autoconfigure.observability.zipkin.HttpSender;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;
import zipkin2.reporter.Call;
import zipkin2.reporter.Callback;

class ZipkinRestTemplateSender
extends HttpSender {
    private final String endpoint;
    private final RestTemplate restTemplate;

    ZipkinRestTemplateSender(String endpoint, RestTemplate restTemplate) {
        this.endpoint = endpoint;
        this.restTemplate = restTemplate;
    }

    @Override
    public HttpSender.HttpPostCall sendSpans(byte[] batchedEncodedSpans) {
        return new RestTemplateHttpPostCall(this.endpoint, batchedEncodedSpans, this.restTemplate);
    }

    private static class RestTemplateHttpPostCall
    extends HttpSender.HttpPostCall {
        private final String endpoint;
        private final RestTemplate restTemplate;

        RestTemplateHttpPostCall(String endpoint, byte[] body, RestTemplate restTemplate) {
            super(body);
            this.endpoint = endpoint;
            this.restTemplate = restTemplate;
        }

        public Call<Void> clone() {
            return new RestTemplateHttpPostCall(this.endpoint, this.getUncompressedBody(), this.restTemplate);
        }

        protected Void doExecute() {
            HttpEntity request = new HttpEntity((Object)this.getBody(), (MultiValueMap)this.getDefaultHeaders());
            this.restTemplate.exchange(this.endpoint, HttpMethod.POST, request, Void.class, new Object[0]);
            return null;
        }

        protected void doEnqueue(Callback<Void> callback) {
            try {
                this.doExecute();
                callback.onSuccess(null);
            }
            catch (Exception ex) {
                callback.onError((Throwable)ex);
            }
        }
    }
}

