/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.rest.mapping;

import java.util.Set;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.beans.factory.ScopeBeanFactory;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.remoting.http12.HttpMethods;
import org.apache.dubbo.remoting.http12.HttpRequest;
import org.apache.dubbo.remoting.http12.HttpResponse;
import org.apache.dubbo.remoting.http12.HttpResult;
import org.apache.dubbo.remoting.http12.HttpStatus;
import org.apache.dubbo.remoting.http12.exception.HttpResultPayloadException;
import org.apache.dubbo.remoting.http12.message.MediaType;
import org.apache.dubbo.remoting.http12.message.codec.CodecUtils;
import org.apache.dubbo.rpc.model.FrameworkModel;
import org.apache.dubbo.rpc.protocol.tri.rest.RestConstants;
import org.apache.dubbo.rpc.protocol.tri.rest.RestHttpMessageCodec;
import org.apache.dubbo.rpc.protocol.tri.rest.argument.ArgumentResolver;
import org.apache.dubbo.rpc.protocol.tri.rest.argument.CompositeArgumentResolver;
import org.apache.dubbo.rpc.protocol.tri.rest.argument.GeneralTypeConverter;
import org.apache.dubbo.rpc.protocol.tri.rest.argument.TypeConverter;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.ContentNegotiator;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.DefaultRequestMappingRegistry;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.RequestMapping;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.RequestMappingRegistry;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.condition.MethodsCondition;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.meta.HandlerMeta;
import org.apache.dubbo.rpc.protocol.tri.rest.util.RequestUtils;
import org.apache.dubbo.rpc.protocol.tri.route.RequestHandler;
import org.apache.dubbo.rpc.protocol.tri.route.RequestHandlerMapping;

@Activate(order=-2000)
public final class RestRequestHandlerMapping
implements RequestHandlerMapping {
    private static final Logger LOGGER = LoggerFactory.getLogger(RestRequestHandlerMapping.class);
    private final RequestMappingRegistry requestMappingRegistry;
    private final ArgumentResolver argumentResolver;
    private final TypeConverter typeConverter;
    private final ContentNegotiator contentNegotiator;
    private final CodecUtils codecUtils;

    public RestRequestHandlerMapping(FrameworkModel frameworkModel) {
        ScopeBeanFactory beanFactory = frameworkModel.getBeanFactory();
        this.requestMappingRegistry = (RequestMappingRegistry)beanFactory.getOrRegisterBean(DefaultRequestMappingRegistry.class);
        this.argumentResolver = (ArgumentResolver)beanFactory.getOrRegisterBean(CompositeArgumentResolver.class);
        this.typeConverter = (TypeConverter)beanFactory.getOrRegisterBean(GeneralTypeConverter.class);
        this.contentNegotiator = (ContentNegotiator)beanFactory.getOrRegisterBean(ContentNegotiator.class);
        this.codecUtils = (CodecUtils)beanFactory.getOrRegisterBean(CodecUtils.class);
    }

    @Override
    public RequestHandler getRequestHandler(URL url, HttpRequest request, HttpResponse response) {
        LOGGER.debug("Received http request: {}", new Object[]{request});
        HandlerMeta meta = this.requestMappingRegistry.lookup(request);
        if (meta == null) {
            String path = (String)request.attribute("org.springframework.web.util.UrlPathHelper.PATH");
            if ("/".equals(path) && HttpMethods.OPTIONS.name().equals(request.method())) {
                RestRequestHandlerMapping.handleOptionsRequest(request);
            }
            LOGGER.debug("No handler found for http request: {}", new Object[]{request});
            return null;
        }
        String method = request.method();
        if (HttpMethods.OPTIONS.name().equals(method)) {
            RestRequestHandlerMapping.handleOptionsRequest(request);
        }
        String requestMediaType = request.mediaType();
        String responseMediaType = this.contentNegotiator.negotiate(request, meta);
        if (responseMediaType != null) {
            response.setContentType(responseMediaType);
        } else {
            responseMediaType = requestMediaType != null && !RequestUtils.isFormOrMultiPart(request) ? requestMediaType : MediaType.APPLICATION_JSON.getName();
        }
        RestHttpMessageCodec codec = new RestHttpMessageCodec(request, response, meta.getParameters(), this.argumentResolver, this.typeConverter, this.codecUtils.determineHttpMessageEncoder(url, responseMediaType));
        if (HttpMethods.supportBody((String)method) && !RequestUtils.isFormOrMultiPart(request)) {
            if (StringUtils.isEmpty((String)requestMediaType)) {
                requestMediaType = responseMediaType;
            }
            request.setAttribute(RestConstants.BODY_DECODER_ATTRIBUTE, (Object)this.codecUtils.determineHttpMessageDecoder(url, requestMediaType));
        }
        LOGGER.debug("Content-type negotiate result: request='{}', response='{}'", new Object[]{requestMediaType, responseMediaType});
        RequestHandler handler = new RequestHandler(meta.getInvoker());
        handler.setHasStub(false);
        handler.setMethodDescriptor(meta.getMethodDescriptor());
        handler.setMethodMetadata(meta.getMethodMetadata());
        handler.setServiceDescriptor(meta.getServiceDescriptor());
        handler.setHttpMessageDecoder(codec);
        handler.setHttpMessageEncoder(codec);
        return handler;
    }

    private static void handleOptionsRequest(HttpRequest request) {
        MethodsCondition condition;
        RequestMapping mapping = (RequestMapping)request.attribute(RestConstants.MAPPING_ATTRIBUTE);
        MethodsCondition methodsCondition = condition = mapping == null ? null : mapping.getMethodsCondition();
        if (condition == null) {
            throw new HttpResultPayloadException((HttpResult)HttpResult.builder().status(HttpStatus.NO_CONTENT).header("allow", "GET,HEAD,POST,PUT,PATCH,DELETE,OPTIONS").build());
        }
        Set<String> methods = condition.getMethods();
        if (methods.size() == 1 && methods.contains(HttpMethods.OPTIONS.name())) {
            return;
        }
        throw new HttpResultPayloadException((HttpResult)HttpResult.builder().status(HttpStatus.NO_CONTENT).header("allow", StringUtils.join(methods, (String)",")).build());
    }

    @Override
    public String getType() {
        return "rest";
    }
}

