/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.h12.grpc;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.config.ConfigurationUtils;
import org.apache.dubbo.common.io.StreamUtils;
import org.apache.dubbo.common.utils.ArrayUtils;
import org.apache.dubbo.common.utils.UrlUtils;
import org.apache.dubbo.remoting.http12.exception.DecodeException;
import org.apache.dubbo.remoting.http12.exception.EncodeException;
import org.apache.dubbo.remoting.http12.exception.HttpStatusException;
import org.apache.dubbo.remoting.http12.message.HttpMessageCodec;
import org.apache.dubbo.remoting.http12.message.MediaType;
import org.apache.dubbo.rpc.model.FrameworkModel;
import org.apache.dubbo.rpc.model.MethodDescriptor;
import org.apache.dubbo.rpc.model.PackableMethod;
import org.apache.dubbo.rpc.model.PackableMethodFactory;
import org.apache.dubbo.rpc.model.ScopeModel;

public class GrpcCompositeCodec
implements HttpMessageCodec {
    private static final String PACKABLE_METHOD_CACHE = "PACKABLE_METHOD_CACHE";
    private final URL url;
    private final FrameworkModel frameworkModel;
    private final String mediaType;
    private PackableMethod packableMethod;

    public GrpcCompositeCodec(URL url, FrameworkModel frameworkModel, String mediaType) {
        this.url = url;
        this.frameworkModel = frameworkModel;
        this.mediaType = mediaType;
    }

    public void loadPackableMethod(MethodDescriptor methodDescriptor) {
        if (methodDescriptor instanceof PackableMethod) {
            this.packableMethod = (PackableMethod)methodDescriptor;
            return;
        }
        this.packableMethod = ((ConcurrentHashMap)UrlUtils.computeServiceAttribute((URL)this.url, (String)PACKABLE_METHOD_CACHE, k -> new ConcurrentHashMap())).computeIfAbsent(methodDescriptor, md -> ((PackableMethodFactory)this.frameworkModel.getExtensionLoader(PackableMethodFactory.class).getExtension(ConfigurationUtils.getGlobalConfiguration((ScopeModel)this.url.getApplicationModel()).getString("dubbo.application.parameters.serialize.packable.factory", "default"))).create(methodDescriptor, this.url, this.mediaType));
    }

    public void encode(OutputStream outputStream, Object data, Charset charset) throws EncodeException {
        try {
            int compressed = 0;
            outputStream.write(compressed);
            byte[] bytes = this.packableMethod.packResponse(data);
            this.writeLength(outputStream, bytes.length);
            outputStream.write(bytes);
        }
        catch (HttpStatusException e) {
            throw e;
        }
        catch (Exception e) {
            throw new EncodeException((Throwable)e);
        }
    }

    public Object decode(InputStream inputStream, Class<?> targetType, Charset charset) throws DecodeException {
        try {
            byte[] data = StreamUtils.readBytes((InputStream)inputStream);
            return this.packableMethod.parseRequest(data);
        }
        catch (HttpStatusException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DecodeException((Throwable)e);
        }
    }

    public Object[] decode(InputStream inputStream, Class<?>[] targetTypes, Charset charset) throws DecodeException {
        Object message = this.decode(inputStream, ArrayUtils.isEmpty((Object[])targetTypes) ? null : targetTypes[0], charset);
        if (message instanceof Object[]) {
            return (Object[])message;
        }
        return new Object[]{message};
    }

    private void writeLength(OutputStream outputStream, int length) {
        try {
            outputStream.write(length >> 24 & 0xFF);
            outputStream.write(length >> 16 & 0xFF);
            outputStream.write(length >> 8 & 0xFF);
            outputStream.write(length & 0xFF);
        }
        catch (IOException e) {
            throw new EncodeException((Throwable)e);
        }
    }

    public MediaType mediaType() {
        return MediaType.APPLICATION_GRPC;
    }
}

