/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri;

import io.grpc.health.v1.HealthCheckResponse;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.config.Configuration;
import org.apache.dubbo.common.config.ConfigurationUtils;
import org.apache.dubbo.common.threadpool.manager.ExecutorRepository;
import org.apache.dubbo.common.utils.ExecutorUtil;
import org.apache.dubbo.common.utils.NetUtils;
import org.apache.dubbo.remoting.ChannelHandler;
import org.apache.dubbo.remoting.api.connection.AbstractConnectionClient;
import org.apache.dubbo.remoting.api.pu.DefaultPuHandler;
import org.apache.dubbo.remoting.exchange.PortUnificationExchanger;
import org.apache.dubbo.rpc.Exporter;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.PathResolver;
import org.apache.dubbo.rpc.RpcException;
import org.apache.dubbo.rpc.model.ApplicationModel;
import org.apache.dubbo.rpc.model.FrameworkModel;
import org.apache.dubbo.rpc.model.ScopeModel;
import org.apache.dubbo.rpc.protocol.AbstractExporter;
import org.apache.dubbo.rpc.protocol.AbstractProtocol;
import org.apache.dubbo.rpc.protocol.tri.Http3Exchanger;
import org.apache.dubbo.rpc.protocol.tri.ServletExchanger;
import org.apache.dubbo.rpc.protocol.tri.TripleInvoker;
import org.apache.dubbo.rpc.protocol.tri.compressor.DeCompressor;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.DefaultRequestMappingRegistry;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.RequestMappingRegistry;
import org.apache.dubbo.rpc.protocol.tri.service.TriBuiltinService;

public class TripleProtocol
extends AbstractProtocol {
    private final PathResolver pathResolver;
    private final RequestMappingRegistry mappingRegistry;
    private final TriBuiltinService triBuiltinService;
    private final String acceptEncodings;
    public static boolean CONVERT_NO_LOWER_HEADER = false;
    public static boolean IGNORE_1_0_0_VERSION = false;
    public static boolean RESOLVE_FALLBACK_TO_DEFAULT = true;
    public static boolean VERBOSE_ENABLED = false;
    public static boolean REST_ENABLED = true;
    public static boolean OPENAPI_ENABLED = false;

    public TripleProtocol(FrameworkModel frameworkModel) {
        this.frameworkModel = frameworkModel;
        this.triBuiltinService = new TriBuiltinService(frameworkModel);
        this.pathResolver = (PathResolver)frameworkModel.getDefaultExtension(PathResolver.class);
        this.mappingRegistry = (RequestMappingRegistry)frameworkModel.getOrRegisterBean(DefaultRequestMappingRegistry.class);
        this.acceptEncodings = String.join((CharSequence)",", frameworkModel.getSupportedExtensions(DeCompressor.class));
        Configuration conf = ConfigurationUtils.getEnvConfiguration((ScopeModel)ApplicationModel.defaultModel());
        CONVERT_NO_LOWER_HEADER = conf.getBoolean("dubbo.rpc.tri.support-no-lower-header", true);
        IGNORE_1_0_0_VERSION = conf.getBoolean("dubbo.rpc.tri.ignore-1.0.0-version", false);
        RESOLVE_FALLBACK_TO_DEFAULT = conf.getBoolean("dubbo.rpc.tri.resolve-fallback-to-default", true);
        Configuration globalConf = ConfigurationUtils.getGlobalConfiguration((ScopeModel)frameworkModel.defaultApplication());
        VERBOSE_ENABLED = globalConf.getBoolean("dubbo.protocol.triple.verbose", false);
        REST_ENABLED = globalConf.getBoolean("dubbo.protocol.triple.rest.enabled", true);
        OPENAPI_ENABLED = globalConf.getBoolean("dubbo.protocol.triple.rest.openapi.enabled", false);
        ServletExchanger.init(globalConf);
        Http3Exchanger.init(globalConf);
    }

    public int getDefaultPort() {
        return 50051;
    }

    public <T> Exporter<T> export(final Invoker<T> invoker) throws RpcException {
        final URL url = invoker.getUrl();
        final String key = TripleProtocol.serviceKey((URL)url);
        AbstractExporter exporter = new AbstractExporter<T>(invoker){

            public void afterUnExport() {
                TripleProtocol.this.pathResolver.unregister(invoker);
                if (REST_ENABLED) {
                    TripleProtocol.this.mappingRegistry.unregister(invoker);
                }
                TripleProtocol.this.setServiceStatus(url, false);
                TripleProtocol.this.exporterMap.remove(key);
            }
        };
        this.exporterMap.put(key, exporter);
        this.invokers.add(invoker);
        this.pathResolver.register(invoker);
        if (REST_ENABLED) {
            this.mappingRegistry.register(invoker);
        }
        this.setServiceStatus(url, true);
        ExecutorRepository.getInstance((ApplicationModel)url.getOrDefaultApplicationModel()).createExecutorIfAbsent(ExecutorUtil.setThreadName((URL)url, (String)"DubboServerHandler"));
        this.bindServerPort(url);
        this.optimizeSerialization(url);
        return exporter;
    }

    private void setServiceStatus(URL url, boolean serving) {
        if (this.triBuiltinService.enable()) {
            HealthCheckResponse.ServingStatus status = serving ? HealthCheckResponse.ServingStatus.SERVING : HealthCheckResponse.ServingStatus.NOT_SERVING;
            this.triBuiltinService.getHealthStatusManager().setStatus(url.getServiceKey(), status);
            this.triBuiltinService.getHealthStatusManager().setStatus(url.getServiceInterface(), status);
        }
    }

    private void bindServerPort(URL url) {
        boolean bindPort = true;
        if (ServletExchanger.isEnabled()) {
            int port = url.getParameter("bind.port", url.getPort());
            Integer serverPort = ServletExchanger.getServerPort();
            if (serverPort == null) {
                if (NetUtils.isPortInUsed((int)port)) {
                    bindPort = false;
                }
            } else if (serverPort == port) {
                bindPort = false;
            }
            ServletExchanger.bind(url);
        }
        if (bindPort) {
            PortUnificationExchanger.bind((URL)url, (ChannelHandler)new DefaultPuHandler());
        }
        Http3Exchanger.bind(url);
    }

    public <T> Invoker<T> refer(Class<T> type, URL url) throws RpcException {
        this.optimizeSerialization(url);
        ExecutorService streamExecutor = this.getOrCreateStreamExecutor(url.getOrDefaultApplicationModel(), url);
        AbstractConnectionClient connectionClient = Http3Exchanger.isEnabled(url) ? Http3Exchanger.connect(url) : PortUnificationExchanger.connect((URL)url, (ChannelHandler)new DefaultPuHandler());
        TripleInvoker<T> invoker = new TripleInvoker<T>(type, url, this.acceptEncodings, connectionClient, this.invokers, streamExecutor);
        this.invokers.add(invoker);
        return invoker;
    }

    private ExecutorService getOrCreateStreamExecutor(ApplicationModel applicationModel, URL url) {
        url = url.addParameter("threadname", "DubboClientHandler").addParameterIfAbsent("threadpool", "cached");
        ExecutorService executor = ExecutorRepository.getInstance((ApplicationModel)applicationModel).createExecutorIfAbsent(url);
        Objects.requireNonNull(executor, String.format("No available executor found in %s", url));
        return executor;
    }

    protected <T> Invoker<T> protocolBindingRefer(Class<T> type, URL url) throws RpcException {
        return null;
    }

    public void destroy() {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Destroying protocol [{}] ...", new Object[]{((Object)((Object)this)).getClass().getSimpleName()});
        }
        PortUnificationExchanger.close();
        Http3Exchanger.close();
        this.pathResolver.destroy();
        if (REST_ENABLED) {
            this.mappingRegistry.destroy();
        }
        super.destroy();
    }
}

