/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.transport;

import io.netty.handler.codec.http2.Http2Headers;
import org.apache.dubbo.common.ServiceKey;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.rpc.executor.AbstractIsolationExecutorSupport;
import org.apache.dubbo.rpc.protocol.tri.TripleHeaderEnum;

public class TripleIsolationExecutorSupport
extends AbstractIsolationExecutorSupport {
    private static final ErrorTypeAwareLogger logger = LoggerFactory.getErrorTypeAwareLogger(TripleIsolationExecutorSupport.class);

    public TripleIsolationExecutorSupport(URL url) {
        super(url);
    }

    protected ServiceKey getServiceKey(Object data) {
        if (!(data instanceof Http2Headers)) {
            return null;
        }
        Http2Headers headers = (Http2Headers)data;
        String path = headers.path().toString();
        String[] parts = path.split("/");
        String interfaceName = parts[1];
        String version = headers.contains((Object)TripleHeaderEnum.SERVICE_VERSION.getHeader()) ? ((CharSequence)headers.get((Object)TripleHeaderEnum.SERVICE_VERSION.getHeader())).toString() : null;
        String group = headers.contains((Object)TripleHeaderEnum.SERVICE_GROUP.getHeader()) ? ((CharSequence)headers.get((Object)TripleHeaderEnum.SERVICE_GROUP.getHeader())).toString() : null;
        return new ServiceKey(interfaceName, version, group);
    }
}

