/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.command;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http2.Http2StreamChannel;
import io.netty.handler.codec.http2.Http2StreamChannelBootstrap;
import io.netty.util.concurrent.Future;
import org.apache.dubbo.rpc.protocol.tri.command.QueuedCommand;
import org.apache.dubbo.rpc.protocol.tri.stream.TripleStreamChannelFuture;

public class CreateStreamQueueCommand
extends QueuedCommand {
    private final Http2StreamChannelBootstrap bootstrap;
    private final TripleStreamChannelFuture streamChannelFuture;

    private CreateStreamQueueCommand(Http2StreamChannelBootstrap bootstrap, TripleStreamChannelFuture streamChannelFuture) {
        this.bootstrap = bootstrap;
        this.streamChannelFuture = streamChannelFuture;
        this.promise(streamChannelFuture.getParentChannel().newPromise());
        this.channel(streamChannelFuture.getParentChannel());
    }

    public static CreateStreamQueueCommand create(Http2StreamChannelBootstrap bootstrap, TripleStreamChannelFuture streamChannelFuture) {
        return new CreateStreamQueueCommand(bootstrap, streamChannelFuture);
    }

    @Override
    public void doSend(ChannelHandlerContext ctx, ChannelPromise promise) {
    }

    @Override
    public void run(Channel channel) {
        Future future = this.bootstrap.open();
        if (future.isSuccess()) {
            this.streamChannelFuture.complete((Http2StreamChannel)future.getNow());
        } else {
            this.streamChannelFuture.completeExceptionally(future.cause());
        }
    }
}

