/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.call;

import java.util.Map;
import org.apache.dubbo.rpc.AppResponse;
import org.apache.dubbo.rpc.TriRpcStatus;
import org.apache.dubbo.rpc.protocol.tri.DeadlineFuture;
import org.apache.dubbo.rpc.protocol.tri.call.ClientCall;

public class UnaryClientCallListener
implements ClientCall.Listener {
    private final DeadlineFuture future;
    private Object appResponse;
    private int actualContentLength;

    public UnaryClientCallListener(DeadlineFuture deadlineFuture) {
        this.future = deadlineFuture;
    }

    @Override
    public void onMessage(Object message, int actualContentLength) {
        this.appResponse = message;
        this.actualContentLength = actualContentLength;
    }

    @Override
    public void onClose(TriRpcStatus status, Map<String, Object> trailers, boolean isReturnTriException) {
        AppResponse result = new AppResponse();
        result.setObjectAttachments(trailers);
        if (status.isOk()) {
            if (isReturnTriException) {
                result.setException((Throwable)((Exception)this.appResponse));
            } else {
                result.setValue(this.appResponse);
            }
        } else {
            result.setException((Throwable)((Object)status.asException()));
        }
        result.setAttribute("content-length", (Object)this.actualContentLength);
        this.future.received(status, result);
    }

    @Override
    public void onStart(ClientCall call) {
        this.future.addTimeoutListener(() -> call.cancelByLocal(new IllegalStateException("client timeout")));
        call.request(2);
    }
}

