/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.http;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.googlecode.jsonrpc4j.HttpException;
import com.googlecode.jsonrpc4j.JsonRpcClientException;
import com.googlecode.jsonrpc4j.JsonRpcServer;
import com.googlecode.jsonrpc4j.spring.JsonProxyFactoryBean;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.remoting.RemotingServer;
import org.apache.dubbo.remoting.http.HttpBinder;
import org.apache.dubbo.remoting.http.HttpHandler;
import org.apache.dubbo.remoting.http.HttpServer;
import org.apache.dubbo.rpc.ProtocolServer;
import org.apache.dubbo.rpc.RpcContext;
import org.apache.dubbo.rpc.RpcException;
import org.apache.dubbo.rpc.protocol.AbstractProxyProtocol;
import org.apache.dubbo.rpc.protocol.http.HttpProtocolErrorCode;
import org.apache.dubbo.rpc.protocol.http.JsonRemoteInvocation;
import org.apache.dubbo.rpc.protocol.http.JsonRpcProxyFactoryBean;
import org.apache.dubbo.rpc.service.GenericService;
import org.apache.dubbo.rpc.support.ProtocolUtils;
import org.springframework.remoting.RemoteAccessException;

public class HttpProtocol
extends AbstractProxyProtocol {
    public static final String ACCESS_CONTROL_ALLOW_ORIGIN_HEADER = "Access-Control-Allow-Origin";
    public static final String ACCESS_CONTROL_ALLOW_METHODS_HEADER = "Access-Control-Allow-Methods";
    public static final String ACCESS_CONTROL_ALLOW_HEADERS_HEADER = "Access-Control-Allow-Headers";
    private final Map<String, JsonRpcServer> skeletonMap = new ConcurrentHashMap<String, JsonRpcServer>();
    private HttpBinder httpBinder;

    public HttpProtocol() {
        super(new Class[]{HttpException.class, JsonRpcClientException.class});
    }

    public void setHttpBinder(HttpBinder httpBinder) {
        this.httpBinder = httpBinder;
    }

    public int getDefaultPort() {
        return 80;
    }

    protected <T> Runnable doExport(T impl, Class<T> type, URL url) throws RpcException {
        String addr = this.getAddr(url);
        ProtocolServer protocolServer = (ProtocolServer)this.serverMap.get(addr);
        if (protocolServer == null) {
            HttpServer remotingServer = this.httpBinder.bind(url, (HttpHandler)new InternalHandler(url.getParameter("cors", false)));
            this.serverMap.put(addr, new AbstractProxyProtocol.ProxyProtocolServer((AbstractProxyProtocol)this, (RemotingServer)remotingServer));
        }
        String path = url.getAbsolutePath();
        String genericPath = path + "/" + "generic";
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        JsonRpcServer skeleton = new JsonRpcServer(mapper, impl, type);
        JsonRpcServer genericServer = new JsonRpcServer(mapper, impl, GenericService.class);
        this.skeletonMap.put(path, skeleton);
        this.skeletonMap.put(genericPath, genericServer);
        return () -> {
            this.skeletonMap.remove(path);
            this.skeletonMap.remove(genericPath);
        };
    }

    protected <T> T doRefer(Class<T> serviceType, URL url) throws RpcException {
        String generic = url.getParameter("generic");
        boolean isGeneric = ProtocolUtils.isGeneric((String)generic) || serviceType.equals(GenericService.class);
        JsonProxyFactoryBean jsonProxyFactoryBean = new JsonProxyFactoryBean();
        JsonRpcProxyFactoryBean jsonRpcProxyFactoryBean = new JsonRpcProxyFactoryBean(jsonProxyFactoryBean);
        jsonRpcProxyFactoryBean.setRemoteInvocationFactory(methodInvocation -> {
            JsonRemoteInvocation invocation = new JsonRemoteInvocation(methodInvocation);
            if (isGeneric) {
                invocation.addAttribute("generic", (Serializable)((Object)generic));
            }
            return invocation;
        });
        String key = url.setProtocol("http").toIdentityString();
        if (isGeneric) {
            key = key + "/" + "generic";
        }
        jsonRpcProxyFactoryBean.setServiceUrl(key);
        jsonRpcProxyFactoryBean.setServiceInterface(serviceType);
        jsonProxyFactoryBean.afterPropertiesSet();
        return (T)jsonProxyFactoryBean.getObject();
    }

    protected int getErrorCode(Throwable e) {
        if (e instanceof RemoteAccessException) {
            e = e.getCause();
        }
        if (e != null) {
            Class<?> cls = e.getClass();
            if (SocketTimeoutException.class.equals(cls)) {
                return 2;
            }
            if (IOException.class.isAssignableFrom(cls)) {
                return 1;
            }
            if (ClassNotFoundException.class.isAssignableFrom(cls)) {
                return 5;
            }
            if (e instanceof HttpProtocolErrorCode) {
                return ((HttpProtocolErrorCode)((Object)e)).getErrorCode();
            }
        }
        return super.getErrorCode(e);
    }

    public void destroy() {
        super.destroy();
        for (String key : new ArrayList(this.serverMap.keySet())) {
            ProtocolServer server = (ProtocolServer)this.serverMap.remove(key);
            if (server == null) continue;
            try {
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("Close jsonrpc server " + server.getUrl());
                }
                server.close();
            }
            catch (Throwable t) {
                this.logger.warn(t.getMessage(), t);
            }
        }
    }

    private class InternalHandler
    implements HttpHandler {
        private boolean cors;

        public InternalHandler(boolean cors) {
            this.cors = cors;
        }

        public void handle(HttpServletRequest request, HttpServletResponse response) throws ServletException {
            String uri = request.getRequestURI();
            JsonRpcServer skeleton = (JsonRpcServer)HttpProtocol.this.skeletonMap.get(uri);
            if (this.cors) {
                response.setHeader(HttpProtocol.ACCESS_CONTROL_ALLOW_ORIGIN_HEADER, "*");
                response.setHeader(HttpProtocol.ACCESS_CONTROL_ALLOW_METHODS_HEADER, "POST");
                response.setHeader(HttpProtocol.ACCESS_CONTROL_ALLOW_HEADERS_HEADER, "*");
            }
            if (request.getMethod().equalsIgnoreCase("OPTIONS")) {
                response.setStatus(200);
            } else if (request.getMethod().equalsIgnoreCase("POST")) {
                RpcContext.getContext().setRemoteAddress(request.getRemoteAddr(), request.getRemotePort());
                try {
                    skeleton.handle((InputStream)request.getInputStream(), (OutputStream)response.getOutputStream());
                }
                catch (Throwable e) {
                    throw new ServletException(e);
                }
            } else {
                response.setStatus(500);
            }
        }
    }
}

