/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.rest.support.spring;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import org.apache.dubbo.common.extension.ExtensionAccessor;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.common.utils.DefaultParameterNameReader;
import org.apache.dubbo.common.utils.ParameterNameReader;
import org.apache.dubbo.config.spring.extension.SpringExtensionInjector;
import org.apache.dubbo.remoting.http12.HttpRequest;
import org.apache.dubbo.remoting.http12.HttpResponse;
import org.apache.dubbo.rpc.model.ApplicationModel;
import org.apache.dubbo.rpc.model.FrameworkModel;
import org.apache.dubbo.rpc.protocol.tri.rest.Messages;
import org.apache.dubbo.rpc.protocol.tri.rest.RestException;
import org.apache.dubbo.rpc.protocol.tri.rest.argument.CompositeArgumentResolver;
import org.apache.dubbo.rpc.protocol.tri.rest.argument.GeneralTypeConverter;
import org.apache.dubbo.rpc.protocol.tri.rest.argument.TypeConverter;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.meta.MethodParameterMeta;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.meta.NamedValueMeta;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.meta.ParameterMeta;
import org.apache.dubbo.rpc.protocol.tri.rest.support.spring.BeanArgumentBinder;
import org.apache.dubbo.rpc.protocol.tri.rest.support.spring.ConfigurationWrapper;
import org.apache.dubbo.rpc.protocol.tri.rest.util.RestToolKit;
import org.apache.dubbo.rpc.protocol.tri.rest.util.RestUtils;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.MethodParameter;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.util.PropertyPlaceholderHelper;

final class SpringRestToolKit
implements RestToolKit {
    private static final Logger LOGGER = LoggerFactory.getLogger(SpringRestToolKit.class);
    private final Map<MethodParameterMeta, TypeDescriptor> cache = CollectionUtils.newConcurrentHashMap();
    private final ConfigurableBeanFactory beanFactory;
    private final PropertyPlaceholderHelper placeholderHelper;
    private final ConfigurationWrapper configuration;
    private final ConversionService conversionService;
    private final TypeConverter typeConverter;
    private final BeanArgumentBinder argumentBinder;
    private final ParameterNameReader parameterNameReader;
    private final CompositeArgumentResolver argumentResolver;

    public SpringRestToolKit(FrameworkModel frameworkModel) {
        ApplicationModel applicationModel = frameworkModel.defaultApplication();
        SpringExtensionInjector injector = SpringExtensionInjector.get((ExtensionAccessor)applicationModel);
        ApplicationContext context = injector.getContext();
        if (context instanceof ConfigurableApplicationContext) {
            this.beanFactory = ((ConfigurableApplicationContext)context).getBeanFactory();
            this.placeholderHelper = null;
            this.configuration = null;
        } else {
            this.beanFactory = null;
            this.placeholderHelper = new PropertyPlaceholderHelper("${", "}", ":", true);
            this.configuration = new ConfigurationWrapper(applicationModel);
        }
        this.conversionService = context != null && context.containsBean("mvcConversionService") ? (ConversionService)context.getBean("mvcConversionService", ConversionService.class) : DefaultConversionService.getSharedInstance();
        this.typeConverter = (TypeConverter)frameworkModel.getOrRegisterBean(GeneralTypeConverter.class);
        this.parameterNameReader = (ParameterNameReader)frameworkModel.getOrRegisterBean(DefaultParameterNameReader.class);
        this.argumentResolver = (CompositeArgumentResolver)frameworkModel.getOrRegisterBean(CompositeArgumentResolver.class);
        this.argumentBinder = new BeanArgumentBinder(this.argumentResolver, this.conversionService);
    }

    public int getDialect() {
        return 1;
    }

    public String resolvePlaceholders(String text) {
        if (!RestUtils.hasPlaceholder((String)text)) {
            return text;
        }
        if (this.beanFactory != null) {
            return this.beanFactory.resolveEmbeddedValue(text);
        }
        return this.placeholderHelper.replacePlaceholders(text, (Properties)this.configuration);
    }

    public Object convert(Object value, ParameterMeta parameter) {
        Object target;
        boolean tried = false;
        if (value instanceof Collection || value instanceof Map) {
            tried = true;
            target = this.typeConverter.convert(value, parameter.getGenericType());
            if (target != null) {
                return target;
            }
        }
        if (parameter instanceof MethodParameterMeta) {
            TypeDescriptor targetType = this.cache.computeIfAbsent((MethodParameterMeta)parameter, k -> new TypeDescriptor(new MethodParameter(k.getMethod(), k.getIndex())));
            TypeDescriptor sourceType = TypeDescriptor.forObject((Object)value);
            if (this.conversionService.canConvert(sourceType, targetType)) {
                try {
                    return this.conversionService.convert(value, sourceType, targetType);
                }
                catch (Throwable t) {
                    LOGGER.debug("Spring convert value '{}' from type [{}] to type [{}] failed", new Object[]{value, value.getClass(), parameter.getGenericType(), t});
                }
            }
        }
        Object object = target = tried ? null : this.typeConverter.convert(value, parameter.getGenericType());
        if (target == null && value != null) {
            throw new RestException(Messages.ARGUMENT_CONVERT_ERROR, new Object[]{parameter.getName(), value, value.getClass(), parameter.getGenericType()});
        }
        return target;
    }

    public Object bind(ParameterMeta parameter, HttpRequest request, HttpResponse response) {
        return this.argumentBinder.bind(parameter, request, response);
    }

    public NamedValueMeta getNamedValueMeta(ParameterMeta parameter) {
        return this.argumentResolver.getNamedValueMeta(parameter);
    }

    public String[] getParameterNames(Method method) {
        return this.parameterNameReader.readParameterNames(method);
    }

    public String[] getParameterNames(Constructor<?> ctor) {
        return this.parameterNameReader.readParameterNames(ctor);
    }

    public Map<String, Object> getAttributes(AnnotatedElement element, Annotation annotation) {
        return AnnotatedElementUtils.getMergedAnnotationAttributes((AnnotatedElement)element, annotation.annotationType());
    }
}

