/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.rest.support.spring;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.common.utils.Pair;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.remoting.http12.HttpRequest;
import org.apache.dubbo.remoting.http12.HttpResponse;
import org.apache.dubbo.remoting.http12.HttpResult;
import org.apache.dubbo.rpc.Result;
import org.apache.dubbo.rpc.model.FrameworkModel;
import org.apache.dubbo.rpc.protocol.tri.rest.RestConstants;
import org.apache.dubbo.rpc.protocol.tri.rest.RestException;
import org.apache.dubbo.rpc.protocol.tri.rest.argument.ArgumentResolver;
import org.apache.dubbo.rpc.protocol.tri.rest.argument.CompositeArgumentResolver;
import org.apache.dubbo.rpc.protocol.tri.rest.filter.RestFilter;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.RequestMapping;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.meta.AnnotationMeta;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.meta.HandlerMeta;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.meta.MethodMeta;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.meta.ParameterMeta;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.meta.ResponseMeta;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.meta.ServiceMeta;
import org.apache.dubbo.rpc.protocol.tri.rest.support.spring.Helper;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseStatus;

@Activate(order=-10000, onClass={"org.springframework.http.ResponseEntity"})
public class SpringResponseRestFilter
implements RestFilter,
RestFilter.Listener {
    private final ArgumentResolver argumentResolver;
    private final Map<Key, Optional<MethodMeta>> cache = CollectionUtils.newConcurrentHashMap();

    public SpringResponseRestFilter(FrameworkModel frameworkModel) {
        this.argumentResolver = (ArgumentResolver)frameworkModel.getOrRegisterBean(CompositeArgumentResolver.class);
    }

    public void onResponse(Result result, HttpRequest request, HttpResponse response) {
        if (result.hasException()) {
            HandlerMeta handler = (HandlerMeta)request.attribute(RestConstants.HANDLER_ATTRIBUTE);
            if (handler == null) {
                return;
            }
            Throwable t = result.getException();
            Key key = new Key(handler.getMethod().getMethod(), t.getClass());
            this.cache.computeIfAbsent(key, k -> this.findSuitableExceptionHandler(handler.getService(), ((Key)k).type)).ifPresent(m -> {
                try {
                    result.setValue(this.invokeExceptionHandler((MethodMeta)m, t, request, response));
                    result.setException(null);
                }
                catch (Throwable th) {
                    result.setException(th);
                }
            });
            return;
        }
        Object value = result.getValue();
        if (value instanceof ResponseEntity) {
            ResponseEntity entity = (ResponseEntity)value;
            result.setValue((Object)HttpResult.builder().body(entity.getBody()).status(Helper.getStatusCode(entity)).headers((Map)entity.getHeaders()).build());
            return;
        }
        RequestMapping mapping = (RequestMapping)request.attribute(RestConstants.MAPPING_ATTRIBUTE);
        if (mapping == null) {
            return;
        }
        ResponseMeta responseMeta = mapping.getResponse();
        if (responseMeta == null) {
            return;
        }
        String reason = responseMeta.getReason();
        result.setValue((Object)HttpResult.builder().body(reason == null ? result.getValue() : reason).status(responseMeta.getStatus().intValue()).build());
    }

    private Optional<MethodMeta> findSuitableExceptionHandler(ServiceMeta serviceMeta, Class<?> exType) {
        if (serviceMeta.getExceptionHandlers() == null) {
            return Optional.empty();
        }
        ArrayList<Pair> candidates = new ArrayList<Pair>();
        for (MethodMeta methodMeta : serviceMeta.getExceptionHandlers()) {
            ExceptionHandler anno = methodMeta.getMethod().getAnnotation(ExceptionHandler.class);
            if (anno == null) continue;
            for (Class type : anno.value()) {
                if (!type.isAssignableFrom(exType)) continue;
                candidates.add(Pair.of((Object)type, (Object)methodMeta));
            }
        }
        int size = candidates.size();
        if (size == 0) {
            return Optional.empty();
        }
        if (size > 1) {
            candidates.sort((o1, o2) -> {
                Class c2;
                Class c1 = (Class)o1.getLeft();
                if (c1.equals(c2 = (Class)o2.getLeft())) {
                    return 0;
                }
                return c1.isAssignableFrom(c2) ? 1 : -1;
            });
        }
        return Optional.of((MethodMeta)((Pair)candidates.get(0)).getRight());
    }

    private Object invokeExceptionHandler(MethodMeta meta, Throwable t, HttpRequest request, HttpResponse response) {
        Object value;
        ParameterMeta[] parameters = meta.getParameters();
        int len = parameters.length;
        Object[] args = new Object[len];
        for (int i = 0; i < len; ++i) {
            ParameterMeta parameter = parameters[i];
            args[i] = parameter.getType().isInstance(t) ? t : this.argumentResolver.resolve(parameter, request, response);
        }
        try {
            value = meta.getMethod().invoke(meta.getServiceMeta().getService(), args);
        }
        catch (Exception e) {
            throw new RestException("Failed to invoke exception handler method: " + meta.getMethod(), (Throwable)e);
        }
        AnnotationMeta rs = meta.getAnnotation(ResponseStatus.class);
        if (rs == null) {
            return value;
        }
        HttpStatus status = (HttpStatus)rs.getEnum("value");
        String reason = rs.getString("reason");
        return HttpResult.builder().body(StringUtils.isEmpty((String)reason) ? value : reason).status(status.value()).build();
    }

    private static final class Key {
        private final Method method;
        private final Class<?> type;

        Key(Method method, Class<?> type) {
            this.method = method;
            this.type = type;
        }

        public boolean equals(Object obj) {
            Key other = (Key)obj;
            return this.method.equals(other.method) && this.type.equals(other.type);
        }

        public int hashCode() {
            return this.method.hashCode() * 31 + this.type.hashCode();
        }
    }
}

