/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.rest.openapi.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.dubbo.rpc.protocol.tri.rest.openapi.Context;
import org.apache.dubbo.rpc.protocol.tri.rest.openapi.model.Node;

public final class SecurityRequirement
extends Node<SecurityRequirement> {
    private Map<String, List<String>> requirements;

    public Map<String, List<String>> getRequirements() {
        return this.requirements;
    }

    public void setRequirements(Map<String, List<String>> requirements) {
        this.requirements = requirements;
    }

    public SecurityRequirement addRequirement(String name, String ... scope) {
        return this.addRequirement(name, scope == null ? Collections.emptyList() : Arrays.asList(scope));
    }

    public SecurityRequirement addRequirement(String name, List<String> scopes) {
        if (this.requirements == null) {
            this.requirements = new LinkedHashMap<String, List<String>>();
        }
        if (scopes == null) {
            scopes = Collections.emptyList();
        }
        this.requirements.put(name, scopes);
        return this;
    }

    public void removeRequirement(String name) {
        if (this.requirements != null) {
            this.requirements.remove(name);
        }
    }

    @Override
    public SecurityRequirement clone() {
        SecurityRequirement clone = (SecurityRequirement)super.clone();
        if (this.requirements != null) {
            Map requirements = SecurityRequirement.newMap(this.requirements.size());
            for (Map.Entry<String, List<String>> entry : this.requirements.entrySet()) {
                requirements.put(entry.getKey(), new ArrayList(entry.getValue()));
            }
            clone.requirements = requirements;
        }
        return clone;
    }

    @Override
    public Map<String, Object> writeTo(Map<String, Object> node, Context context) {
        SecurityRequirement.write(node, "requirements", this.requirements);
        this.writeExtensions(node);
        return node;
    }
}

