/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.rest.openapi.model;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.dubbo.remoting.http12.HttpMethods;
import org.apache.dubbo.rpc.protocol.tri.rest.openapi.Context;
import org.apache.dubbo.rpc.protocol.tri.rest.openapi.Helper;
import org.apache.dubbo.rpc.protocol.tri.rest.openapi.model.Node;
import org.apache.dubbo.rpc.protocol.tri.rest.openapi.model.Operation;
import org.apache.dubbo.rpc.protocol.tri.rest.openapi.model.Parameter;
import org.apache.dubbo.rpc.protocol.tri.rest.openapi.model.Server;

public final class PathItem
extends Node<PathItem> {
    private String ref;
    private String summary;
    private String description;
    private Map<HttpMethods, Operation> operations;
    private List<Server> servers;
    private List<Parameter> parameters;

    public String getRef() {
        return this.ref;
    }

    public PathItem setRef(String ref) {
        this.ref = ref;
        return this;
    }

    public String getSummary() {
        return this.summary;
    }

    public PathItem setSummary(String summary) {
        this.summary = summary;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public PathItem setDescription(String description) {
        this.description = description;
        return this;
    }

    public Map<HttpMethods, Operation> getOperations() {
        return this.operations;
    }

    public Operation getOperation(HttpMethods method) {
        return this.operations == null ? null : this.operations.get(method);
    }

    public PathItem setOperations(Map<HttpMethods, Operation> operations) {
        this.operations = operations;
        return this;
    }

    public PathItem addOperation(HttpMethods method, Operation operation) {
        if (this.operations == null) {
            this.operations = new LinkedHashMap<HttpMethods, Operation>();
        }
        this.operations.put(method, operation);
        return this;
    }

    public PathItem removeOperation(HttpMethods method) {
        if (this.operations != null) {
            this.operations.remove(method);
        }
        return this;
    }

    public List<Server> getServers() {
        return this.servers;
    }

    public PathItem setServers(List<Server> servers) {
        this.servers = servers;
        return this;
    }

    public PathItem addServer(Server server) {
        if (this.servers == null) {
            this.servers = new ArrayList<Server>();
        }
        this.servers.add(server);
        return this;
    }

    public PathItem removeServer(Server server) {
        if (this.servers != null) {
            this.servers.remove(server);
        }
        return this;
    }

    public List<Parameter> getParameters() {
        return this.parameters;
    }

    public PathItem setParameters(List<Parameter> parameters) {
        this.parameters = parameters;
        return this;
    }

    public PathItem addParameter(Parameter parameter) {
        List<Parameter> thisParameters = this.parameters;
        if (thisParameters == null) {
            this.parameters = thisParameters = new ArrayList<Parameter>();
        } else {
            int size = thisParameters.size();
            for (int i = 0; i < size; ++i) {
                Parameter tParameter = thisParameters.get(i);
                if (!tParameter.getName().equals(parameter.getName())) continue;
                return this;
            }
        }
        thisParameters.add(parameter);
        return this;
    }

    public PathItem removeParameter(Parameter parameter) {
        if (this.parameters != null) {
            this.parameters.remove(parameter);
        }
        return this;
    }

    @Override
    public PathItem clone() {
        PathItem clone = (PathItem)super.clone();
        clone.operations = PathItem.clone(this.operations);
        clone.servers = PathItem.clone(this.servers);
        clone.parameters = PathItem.clone(this.parameters);
        return clone;
    }

    @Override
    public Map<String, Object> writeTo(Map<String, Object> node, Context context) {
        if (this.ref != null) {
            PathItem.write(node, "$ref", Helper.pathToRef(this.ref));
        } else if (this.operations != null) {
            PathItem.write(node, "summary", this.summary);
            PathItem.write(node, "description", this.description);
            for (Map.Entry<HttpMethods, Operation> entry : this.operations.entrySet()) {
                PathItem.write(node, entry.getKey().name().toLowerCase(), entry.getValue(), context);
            }
            PathItem.write(node, "servers", this.servers, context);
            PathItem.write(node, "parameters", this.parameters, context);
        }
        this.writeExtensions(node);
        return node;
    }
}

