/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.rest.openapi.model;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.dubbo.common.utils.ToStringUtils;
import org.apache.dubbo.rpc.protocol.tri.rest.openapi.Context;

public abstract class Node<T extends Node<T>>
implements Cloneable {
    private Map<String, Object> extensions;

    public Map<String, Object> getExtensions() {
        return this.extensions;
    }

    public T addExtension(String name, Object value) {
        Map<String, Object> extensions = this.extensions;
        if (extensions == null) {
            this.extensions = extensions = new LinkedHashMap<String, Object>();
        }
        extensions.put(name, value);
        return (T)this;
    }

    public T addExtensions(Map<String, ?> extensions) {
        if (extensions == null || extensions.isEmpty()) {
            return (T)this;
        }
        Map<String, Object> thisExtensions = this.extensions;
        if (thisExtensions == null) {
            this.extensions = new LinkedHashMap(extensions);
        } else {
            for (Map.Entry<String, ?> entry : extensions.entrySet()) {
                thisExtensions.putIfAbsent(entry.getKey(), entry.getValue());
            }
        }
        return (T)this;
    }

    public void removeExtension(String name) {
        if (this.extensions != null) {
            this.extensions.remove(name);
        }
    }

    public T setExtensions(Map<String, ?> extensions) {
        if (extensions != null) {
            this.extensions = new LinkedHashMap(extensions);
        }
        return (T)this;
    }

    public T clone() {
        try {
            Node clone = (Node)super.clone();
            if (this.extensions != null) {
                clone.setExtensions(this.extensions);
            }
            return (T)clone;
        }
        catch (CloneNotSupportedException e) {
            throw new UnsupportedOperationException(e);
        }
    }

    public String toString() {
        return ToStringUtils.printToString((Object)this);
    }

    public static <T extends Node<T>> T clone(T node) {
        return (T)(node == null ? null : node.clone());
    }

    public static <T extends Node<T>> List<T> clone(List<T> list) {
        if (list == null) {
            return null;
        }
        int size = list.size();
        if (size == 0) {
            return new ArrayList();
        }
        ArrayList<Object> clone = new ArrayList<Object>(size);
        for (int i = 0; i < size; ++i) {
            clone.add(((Node)list.get(i)).clone());
        }
        return clone;
    }

    public static <K, V extends Node<V>> Map<K, V> clone(Map<K, V> map) {
        if (map == null) {
            return null;
        }
        int size = map.size();
        if (size == 0) {
            return new LinkedHashMap();
        }
        Map<K, Object> clone = Node.newMap(size);
        for (Map.Entry<K, V> entry : map.entrySet()) {
            clone.put(entry.getKey(), ((Node)entry.getValue()).clone());
        }
        return clone;
    }

    protected static void write(Map<String, Object> node, String name, Object value) {
        if (value == null || "".equals(value)) {
            return;
        }
        node.put(name, value instanceof Set ? ((Set)value).toArray() : value);
    }

    protected static void write(Map<String, Object> node, String name, Node<?> value, Context context) {
        if (value == null) {
            return;
        }
        Map<String, Object> valueMap = value.writeTo(new LinkedHashMap<String, Object>(), context);
        if (valueMap == null || valueMap.isEmpty()) {
            return;
        }
        node.put(name, valueMap);
    }

    protected static void write(Map<String, Object> node, String name, List<? extends Node<?>> value, Context context) {
        if (value == null) {
            return;
        }
        int size = value.size();
        if (size > 0) {
            ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(size);
            for (int i = 0; i < size; ++i) {
                Map<String, Object> valueMap = value.get(i).writeTo(new LinkedHashMap<String, Object>(), context);
                if (valueMap == null || valueMap.isEmpty()) continue;
                list.add(valueMap);
            }
            node.put(name, list);
        }
    }

    protected static void write(Map<String, Object> node, String name, Map<?, ? extends Node<?>> value, Context context) {
        if (value == null) {
            return;
        }
        int size = value.size();
        if (size > 0) {
            Map<?, Map<String, Object>> map = Node.newMap(size);
            for (Map.Entry<?, Node<?>> entry : value.entrySet()) {
                Map<String, Object> valueMap = entry.getValue().writeTo(new LinkedHashMap<String, Object>(), context);
                if (valueMap == null || valueMap.isEmpty()) continue;
                map.put(entry.getKey(), valueMap);
            }
            node.put(name, map);
        }
    }

    protected static <K, V> Map<K, V> newMap(int capacity) {
        return new LinkedHashMap(capacity < 3 ? capacity + 1 : (int)((float)capacity / 0.75f + 1.0f));
    }

    protected final void writeExtensions(Map<String, Object> node) {
        if (this.extensions == null) {
            return;
        }
        node.putAll(this.extensions);
    }

    public abstract Map<String, Object> writeTo(Map<String, Object> var1, Context var2);
}

