/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.rest.openapi;

import java.io.File;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.sql.Date;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.Currency;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import org.apache.dubbo.rpc.protocol.tri.rest.openapi.model.Schema;

public enum PrimitiveSchema {
    STRING(String.class, Schema.Type.STRING),
    BOOLEAN(Boolean.class, Schema.Type.BOOLEAN),
    BYTE(Byte.class, Schema.Type.STRING, "byte"),
    BINARY(Byte.class, Schema.Type.STRING, "binary"),
    URI(URI.class, Schema.Type.STRING, "uri"),
    URL(URL.class, Schema.Type.STRING, "url"),
    EMAIL(String.class, Schema.Type.STRING, "email"),
    PASSWORD(String.class, Schema.Type.STRING, "password"),
    UUID(UUID.class, Schema.Type.STRING, "uuid"),
    INT(Integer.class, Schema.Type.INTEGER, "int32"),
    LONG(Long.class, Schema.Type.INTEGER, "int64"),
    FLOAT(Float.class, Schema.Type.NUMBER, "float"),
    DOUBLE(Double.class, Schema.Type.NUMBER, "double"),
    INTEGER(BigInteger.class, Schema.Type.INTEGER),
    DECIMAL(BigDecimal.class, Schema.Type.NUMBER, "number"),
    NUMBER(Number.class, Schema.Type.NUMBER),
    IP_V4(Inet4Address.class, Schema.Type.STRING, "ipv4"),
    IP_V6(Inet6Address.class, Schema.Type.STRING, "ipv6"),
    DATE_TIME(java.util.Date.class, Schema.Type.STRING, "date-time"),
    DATE(LocalDate.class, Schema.Type.STRING, "date"),
    TIME(LocalTime.class, Schema.Type.STRING, "time"),
    DURATION(Duration.class, Schema.Type.STRING, "duration"),
    FILE(File.class, Schema.Type.STRING, "binary"),
    OBJECT(Object.class, Schema.Type.OBJECT),
    ARRAY(Object[].class, Schema.Type.ARRAY);

    private static final Map<Object, PrimitiveSchema> TYPE_MAPPING;
    private final Class<?> keyClass;
    private final Schema.Type type;
    private final String format;

    private PrimitiveSchema(Class<?> keyClass, Schema.Type type, String format) {
        this.keyClass = keyClass;
        this.type = type;
        this.format = format;
    }

    private PrimitiveSchema(Class<?> keyClass, Schema.Type type) {
        this.keyClass = keyClass;
        this.type = type;
        this.format = null;
    }

    public Schema newSchema() {
        return new Schema().setType(this.type).setFormat(this.format);
    }

    public static Schema newSchemaOf(Class<?> type) {
        PrimitiveSchema schema = TYPE_MAPPING.get(type);
        if (schema == null) {
            schema = TYPE_MAPPING.get(type.getName());
        }
        return schema == null ? null : schema.newSchema();
    }

    public static boolean isPrimitive(Class<?> type) {
        return TYPE_MAPPING.containsKey(type);
    }

    public static void addTypeMapping(Object key, PrimitiveSchema schema) {
        TYPE_MAPPING.put(key, schema);
    }

    static {
        TYPE_MAPPING = new ConcurrentHashMap<Object, PrimitiveSchema>();
        for (PrimitiveSchema schema : PrimitiveSchema.values()) {
            TYPE_MAPPING.putIfAbsent(schema.keyClass, schema);
        }
        TYPE_MAPPING.put(Boolean.TYPE, BOOLEAN);
        TYPE_MAPPING.put(Byte.TYPE, BYTE);
        TYPE_MAPPING.put(Character.TYPE, STRING);
        TYPE_MAPPING.put(Character.class, STRING);
        TYPE_MAPPING.put(Short.TYPE, INT);
        TYPE_MAPPING.put(Short.class, INT);
        TYPE_MAPPING.put(Integer.TYPE, INT);
        TYPE_MAPPING.put(Long.TYPE, LONG);
        TYPE_MAPPING.put(Float.TYPE, FLOAT);
        TYPE_MAPPING.put(Double.TYPE, DOUBLE);
        TYPE_MAPPING.put(byte[].class, BYTE);
        TYPE_MAPPING.put(Calendar.class, DATE_TIME);
        TYPE_MAPPING.put(Date.class, DATE_TIME);
        TYPE_MAPPING.put(Instant.class, DATE_TIME);
        TYPE_MAPPING.put(LocalDateTime.class, DATE_TIME);
        TYPE_MAPPING.put(ZonedDateTime.class, DATE_TIME);
        TYPE_MAPPING.put(OffsetDateTime.class, DATE_TIME);
        TYPE_MAPPING.put(OffsetTime.class, TIME);
        TYPE_MAPPING.put(Period.class, DURATION);
        TYPE_MAPPING.put("javax.xml.datatype.XMLGregorianCalendar", DATE_TIME);
        TYPE_MAPPING.put("org.joda.time.LocalDateTime", DATE_TIME);
        TYPE_MAPPING.put("org.joda.time.ReadableDateTime", DATE_TIME);
        TYPE_MAPPING.put("org.joda.time.DateTime", DATE_TIME);
        TYPE_MAPPING.put("org.joda.time.LocalTime", TIME);
        TYPE_MAPPING.put(CharSequence.class, STRING);
        TYPE_MAPPING.put(StringBuffer.class, STRING);
        TYPE_MAPPING.put(StringBuilder.class, STRING);
        TYPE_MAPPING.put(Charset.class, STRING);
        TYPE_MAPPING.put(ZoneId.class, STRING);
        TYPE_MAPPING.put(Currency.class, STRING);
        TYPE_MAPPING.put(Locale.class, STRING);
        TYPE_MAPPING.put(TimeZone.class, STRING);
        TYPE_MAPPING.put(Pattern.class, STRING);
        TYPE_MAPPING.put(InputStream.class, BYTE);
        TYPE_MAPPING.put(InetAddress.class, IP_V4);
        TYPE_MAPPING.put("object", OBJECT);
    }
}

