/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.rest.openapi;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import org.apache.dubbo.common.utils.JsonUtils;
import org.apache.dubbo.remoting.http12.exception.UnsupportedMediaTypeException;
import org.apache.dubbo.remoting.http12.message.codec.YamlCodec;
import org.apache.dubbo.remoting.http12.rest.OpenAPIRequest;
import org.apache.dubbo.rpc.model.FrameworkModel;
import org.apache.dubbo.rpc.protocol.tri.rest.openapi.ContextImpl;
import org.apache.dubbo.rpc.protocol.tri.rest.openapi.ExtensionFactory;
import org.apache.dubbo.rpc.protocol.tri.rest.openapi.ProtoEncoder;
import org.apache.dubbo.rpc.protocol.tri.rest.openapi.SchemaResolver;
import org.apache.dubbo.rpc.protocol.tri.rest.openapi.model.OpenAPI;

final class DefinitionEncoder {
    private final ExtensionFactory extensionFactory;
    private final SchemaResolver schemaResolver;
    private ProtoEncoder protoEncoder;

    DefinitionEncoder(FrameworkModel frameworkModel) {
        this.extensionFactory = (ExtensionFactory)frameworkModel.getOrRegisterBean(ExtensionFactory.class);
        this.schemaResolver = (SchemaResolver)frameworkModel.getOrRegisterBean(SchemaResolver.class);
    }

    public String encode(OpenAPI openAPI, OpenAPIRequest request) {
        if (openAPI == null) {
            openAPI = new OpenAPI();
        }
        LinkedHashMap<String, Object> root = new LinkedHashMap<String, Object>();
        ContextImpl context = new ContextImpl(openAPI, this.schemaResolver, this.extensionFactory, request);
        openAPI.writeTo(root, context);
        String format = request.getFormat();
        switch (format = format == null ? "json" : format.toLowerCase()) {
            case "json": {
                if (Boolean.TRUE.equals(request.getPretty())) {
                    return JsonUtils.toPrettyJson(root);
                }
                return JsonUtils.toJson(root);
            }
            case "yml": 
            case "yaml": {
                ByteArrayOutputStream os = new ByteArrayOutputStream(4096);
                YamlCodec.INSTANCE.encode((OutputStream)os, root, StandardCharsets.UTF_8);
                return new String(os.toByteArray(), StandardCharsets.UTF_8);
            }
            case "proto": {
                if (this.protoEncoder == null) {
                    this.protoEncoder = new ProtoEncoder();
                }
                return this.protoEncoder.encode(openAPI);
            }
        }
        throw new UnsupportedMediaTypeException("text/" + format);
    }
}

