/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.remoting.websocket.netty4;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.FullHttpRequest;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.config.nested.TripleConfig;
import org.apache.dubbo.remoting.http12.command.HttpWriteQueue;
import org.apache.dubbo.remoting.http12.h2.H2StreamChannel;
import org.apache.dubbo.remoting.http12.h2.Http2TransportListener;
import org.apache.dubbo.remoting.http12.h2.command.Http2WriteQueueChannel;
import org.apache.dubbo.remoting.http12.netty4.HttpWriteQueueHandler;
import org.apache.dubbo.remoting.http12.netty4.h2.NettyHttp2FrameHandler;
import org.apache.dubbo.remoting.websocket.WebSocketServerTransportListenerFactory;
import org.apache.dubbo.remoting.websocket.WebSocketTransportListener;
import org.apache.dubbo.remoting.websocket.netty4.NettyWebSocketChannel;
import org.apache.dubbo.rpc.model.FrameworkModel;

public class WebSocketProtocolSelectorHandler
extends SimpleChannelInboundHandler<FullHttpRequest> {
    private final URL url;
    private final FrameworkModel frameworkModel;
    private final TripleConfig tripleConfig;
    private final WebSocketServerTransportListenerFactory defaultWebSocketServerTransportListenerFactory;

    public WebSocketProtocolSelectorHandler(URL url, FrameworkModel frameworkModel, TripleConfig tripleConfig, WebSocketServerTransportListenerFactory defaultWebSocketServerTransportListenerFactory) {
        this.url = url;
        this.frameworkModel = frameworkModel;
        this.tripleConfig = tripleConfig;
        this.defaultWebSocketServerTransportListenerFactory = defaultWebSocketServerTransportListenerFactory;
    }

    protected void channelRead0(ChannelHandlerContext ctx, FullHttpRequest msg) {
        NettyWebSocketChannel streamChannel = new NettyWebSocketChannel(ctx.channel(), this.tripleConfig);
        HttpWriteQueueHandler writeQueueHandler = (HttpWriteQueueHandler)ctx.channel().pipeline().get(HttpWriteQueueHandler.class);
        if (writeQueueHandler != null) {
            HttpWriteQueue writeQueue = writeQueueHandler.getWriteQueue();
            streamChannel = new Http2WriteQueueChannel((H2StreamChannel)streamChannel, writeQueue);
        }
        WebSocketTransportListener webSocketTransportListener = this.defaultWebSocketServerTransportListenerFactory.newInstance(streamChannel, this.url, this.frameworkModel);
        ctx.channel().closeFuture().addListener(future -> webSocketTransportListener.close());
        ctx.pipeline().addLast(new ChannelHandler[]{new NettyHttp2FrameHandler((H2StreamChannel)streamChannel, (Http2TransportListener)webSocketTransportListener)}).remove((ChannelHandler)this);
        ctx.fireChannelRead((Object)msg.retain());
    }
}

