/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.remoting.http3.netty4;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.incubator.codec.quic.QuicStreamChannel;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.remoting.http12.HttpMetadata;
import org.apache.dubbo.remoting.http12.command.HttpWriteQueue;
import org.apache.dubbo.remoting.http12.exception.UnsupportedMediaTypeException;
import org.apache.dubbo.remoting.http12.h2.H2StreamChannel;
import org.apache.dubbo.remoting.http12.h2.Http2TransportListener;
import org.apache.dubbo.remoting.http12.h2.command.Http2WriteQueueChannel;
import org.apache.dubbo.remoting.http12.netty4.HttpWriteQueueHandler;
import org.apache.dubbo.remoting.http12.netty4.h2.NettyHttp2FrameHandler;
import org.apache.dubbo.remoting.http3.Http3ServerTransportListenerFactory;
import org.apache.dubbo.remoting.http3.netty4.NettyHttp3StreamChannel;
import org.apache.dubbo.rpc.model.FrameworkModel;

@ChannelHandler.Sharable
public class NettyHttp3ProtocolSelectorHandler
extends SimpleChannelInboundHandler<HttpMetadata> {
    private final URL url;
    private final FrameworkModel frameworkModel;

    public NettyHttp3ProtocolSelectorHandler(URL url, FrameworkModel frameworkModel) {
        this.url = url;
        this.frameworkModel = frameworkModel;
    }

    protected void channelRead0(ChannelHandlerContext ctx, HttpMetadata metadata) {
        String contentType = metadata.contentType();
        Http3ServerTransportListenerFactory factory = this.determineHttp3ServerTransportListenerFactory(contentType);
        if (factory == null) {
            throw new UnsupportedMediaTypeException(contentType);
        }
        NettyHttp3StreamChannel streamChannel = new NettyHttp3StreamChannel((QuicStreamChannel)ctx.channel());
        HttpWriteQueueHandler writeQueueHandler = (HttpWriteQueueHandler)ctx.channel().pipeline().get(HttpWriteQueueHandler.class);
        if (writeQueueHandler != null) {
            HttpWriteQueue writeQueue = writeQueueHandler.getWriteQueue();
            streamChannel = new Http2WriteQueueChannel((H2StreamChannel)streamChannel, writeQueue);
        }
        ChannelPipeline pipeline = ctx.pipeline();
        pipeline.addLast(new ChannelHandler[]{new NettyHttp2FrameHandler((H2StreamChannel)streamChannel, (Http2TransportListener)factory.newInstance(streamChannel, this.url, this.frameworkModel))});
        pipeline.remove((ChannelHandler)this);
        ctx.fireChannelRead((Object)metadata);
    }

    private Http3ServerTransportListenerFactory determineHttp3ServerTransportListenerFactory(String contentType) {
        for (Http3ServerTransportListenerFactory factory : this.frameworkModel.getActivateExtensions(Http3ServerTransportListenerFactory.class)) {
            if (!factory.supportContentType(contentType)) continue;
            return factory;
        }
        return null;
    }
}

